"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentDetailsRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _common = require("@kbn/spaces-plugin/common");
var _constants = require("../../../common/constants");
var _common2 = require("../../../common");
var _api = require("../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentDetailsRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'internal',
    path: '/internal/osquery/fleet_wrapper/agents/{id}',
    security: {
      authz: {
        requiredPrivileges: [`${_common2.PLUGIN_ID}-read`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_api.GetAgentDetailsRequestParams)
      }
    }
  }, async (context, request, response) => {
    const space = await osqueryContext.service.getActiveSpace(request);
    let agent;
    try {
      var _osqueryContext$servi, _osqueryContext$servi2, _space$id;
      agent = await ((_osqueryContext$servi = osqueryContext.service.getAgentService()) === null || _osqueryContext$servi === void 0 ? void 0 : (_osqueryContext$servi2 = _osqueryContext$servi.asInternalScopedUser((_space$id = space === null || space === void 0 ? void 0 : space.id) !== null && _space$id !== void 0 ? _space$id : _common.DEFAULT_SPACE_ID)) === null || _osqueryContext$servi2 === void 0 ? void 0 : _osqueryContext$servi2.getAgent(request.params.id));
    } catch (err) {
      return response.notFound();
    }
    return response.ok({
      body: {
        item: agent
      }
    });
  });
};
exports.getAgentDetailsRoute = getAgentDetailsRoute;