"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryAppContextService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_integration_namespaces = require("../utils/get_integration_namespaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A singleton that holds shared services that are initialized during the start up phase
 * of the plugin lifecycle. And stop during the stop phase, if needed.
 */
class OsqueryAppContextService {
  constructor() {
    (0, _defineProperty2.default)(this, "agentService", void 0);
    (0, _defineProperty2.default)(this, "packageService", void 0);
    (0, _defineProperty2.default)(this, "packagePolicyService", void 0);
    (0, _defineProperty2.default)(this, "agentPolicyService", void 0);
    (0, _defineProperty2.default)(this, "ruleRegistryService", void 0);
    (0, _defineProperty2.default)(this, "fleetActionsClient", void 0);
    (0, _defineProperty2.default)(this, "spacesService", void 0);
  }
  start(dependencies) {
    var _dependencies$createF;
    this.agentService = dependencies.agentService;
    this.packageService = dependencies.packageService;
    this.packagePolicyService = dependencies.packagePolicyService;
    this.agentPolicyService = dependencies.agentPolicyService;
    this.ruleRegistryService = dependencies.ruleRegistryService;
    this.fleetActionsClient = (_dependencies$createF = dependencies.createFleetActionsClient) === null || _dependencies$createF === void 0 ? void 0 : _dependencies$createF.call(dependencies, 'osquery');
    this.spacesService = dependencies.spacesService;
  }
  stop() {}
  getAgentService() {
    return this.agentService;
  }
  getPackageService() {
    return this.packageService;
  }
  getPackagePolicyService() {
    return this.packagePolicyService;
  }
  getAgentPolicyService() {
    return this.agentPolicyService;
  }
  getRuleRegistryService() {
    return this.ruleRegistryService;
  }
  getFleetActionsClient() {
    return this.fleetActionsClient;
  }
  getActiveSpace(httpRequest) {
    var _this$spacesService;
    return (_this$spacesService = this.spacesService) === null || _this$spacesService === void 0 ? void 0 : _this$spacesService.getActiveSpace(httpRequest);
  }

  /**
   * Retrieves namespaces used by specified integrations.
   */
  async getIntegrationNamespaces(integrationNames, soClient, logger) {
    const packagePolicyService = this.getPackagePolicyService();
    const agentPolicyService = this.getAgentPolicyService();
    if (!packagePolicyService || !agentPolicyService) {
      throw new Error('Fleet services are not available');
    }
    return (0, _get_integration_namespaces.getIntegrationNamespaces)({
      logger,
      soClient,
      packagePolicyService,
      agentPolicyService,
      integrationNames
    });
  }
}

/**
 * The context for Osquery app.
 */
exports.OsqueryAppContextService = OsqueryAppContextService;