"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPackagePolicyDeleteCallback = exports.getAgentPolicyPostUpdateCallback = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/fleet-plugin/common");
var _types = require("../../common/types");
var _common2 = require("../../common");
var _get_internal_saved_object_client = require("../utils/get_internal_saved_object_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentPolicyPostUpdateCallback = core => async (updatedAgentPolicy, requestSpaceId) => {
  const hasOsqueryIntegration = Array.isArray(updatedAgentPolicy.package_policies) && updatedAgentPolicy.package_policies.some(pkg => {
    var _pkg$package;
    return (pkg === null || pkg === void 0 ? void 0 : (_pkg$package = pkg.package) === null || _pkg$package === void 0 ? void 0 : _pkg$package.name) === _common2.OSQUERY_INTEGRATION_NAME;
  });
  if (!hasOsqueryIntegration) {
    return updatedAgentPolicy;
  }
  if (requestSpaceId) {
    var _updatedAgentPolicy$s;
    if (!((_updatedAgentPolicy$s = updatedAgentPolicy.space_ids) !== null && _updatedAgentPolicy$s !== void 0 ? _updatedAgentPolicy$s : []).includes(requestSpaceId)) {
      const spaceScopedSavedObjectClient = (0, _get_internal_saved_object_client.getInternalSavedObjectsClientForSpaceId)(core, requestSpaceId);
      const foundPacks = await spaceScopedSavedObjectClient.find({
        type: _types.packSavedObjectType,
        hasReference: {
          type: _common.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE,
          id: updatedAgentPolicy.id
        },
        perPage: 10000
      });
      if (foundPacks.saved_objects.length) {
        const policyId = updatedAgentPolicy.id;
        await Promise.all((0, _lodash.map)(foundPacks.saved_objects, pack => spaceScopedSavedObjectClient.update(_types.packSavedObjectType, pack.id, {
          shards: (0, _lodash.filter)(pack.attributes.shards, shard => shard.key !== policyId)
        }, {
          references: (0, _lodash.filter)(pack.references, reference => reference.id !== policyId)
        })));
      }
    }
  }
  return updatedAgentPolicy;
};
exports.getAgentPolicyPostUpdateCallback = getAgentPolicyPostUpdateCallback;
const getPackagePolicyDeleteCallback = packsClient => async deletedPackagePolicy => {
  const deletedOsqueryManagerPolicies = (0, _lodash.filter)(deletedPackagePolicy, ['package.name', _common2.OSQUERY_INTEGRATION_NAME]);
  await Promise.all((0, _lodash.map)(deletedOsqueryManagerPolicies, async deletedOsqueryManagerPolicy => {
    var _deletedOsqueryManage;
    const policyIds = (_deletedOsqueryManage = deletedOsqueryManagerPolicy.policy_ids) !== null && _deletedOsqueryManage !== void 0 && _deletedOsqueryManage.length ? deletedOsqueryManagerPolicy.policy_ids : [deletedOsqueryManagerPolicy.policy_id];
    if (policyIds[0] !== undefined) {
      const foundPacks = await packsClient.find({
        type: _types.packSavedObjectType,
        hasReference: policyIds.map(policyId => ({
          type: _common.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE,
          id: policyId
        })),
        perPage: 1000
      });
      await Promise.all((0, _lodash.map)(foundPacks.saved_objects, pack => packsClient.update(_types.packSavedObjectType, pack.id, {
        shards: (0, _lodash.filter)(pack.attributes.shards, shard => policyIds.includes(shard.key))
      }, {
        references: (0, _lodash.filter)(pack.references, reference => policyIds.includes(reference.id))
      })));
    }
  }));
};
exports.getPackagePolicyDeleteCallback = getPackagePolicyDeleteCallback;