"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryManagedCustomButtonExtension = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _navigation_buttons = require("./navigation_buttons");
var _disabled_callout = require("./disabled_callout");
var _missing_privileges = require("../routes/components/missing_privileges");
var _use_fetch_status = require("./use_fetch_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/fleet_integration/osquery_managed_custom_button_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Exports Osquery-specific package policy instructions
 * for use in the Fleet app custom tab
 */
const OsqueryManagedCustomButtonExtension = exports.OsqueryManagedCustomButtonExtension = /*#__PURE__*/_react.default.memo(() => {
  const {
    loading,
    disabled,
    permissionDenied
  } = (0, _use_fetch_status.useFetchStatus)();
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 5,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 14
      }
    });
  }
  if (permissionDenied) {
    return /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivileges, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, disabled ? /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 21
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_navigation_buttons.NavigationButtons, {
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }));
});
OsqueryManagedCustomButtonExtension.displayName = 'OsqueryManagedCustomButtonExtension';