"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _sseUtilsClient = require("@kbn/sse-utils-client");
var _agents = require("@kbn/onechat-common/agents");
var _constants = require("../../../common/constants");
var _errors = require("../utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ChatService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  chat(params) {
    var _params$capabilities;
    const payload = {
      input: params.input,
      agent_id: params.agentId,
      conversation_id: params.conversationId,
      connector_id: params.connectorId,
      capabilities: (_params$capabilities = params.capabilities) !== null && _params$capabilities !== void 0 ? _params$capabilities : (0, _agents.getKibanaDefaultAgentCapabilities)()
    };
    return (0, _rxjs.defer)(() => {
      return this.http.post(`${_constants.publicApiPath}/converse/async`, {
        signal: params.signal,
        asResponse: true,
        rawResponse: true,
        body: JSON.stringify(payload)
      });
    }).pipe(
    // @ts-expect-error SseEvent mixin issue
    (0, _sseUtilsClient.httpResponseIntoObservable)(), (0, _errors.unwrapOnechatErrors)());
  }
}
exports.ChatService = ChatService;