"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversationList = void 0;
var _reactQuery = require("@tanstack/react-query");
var _query_keys = require("../query_keys");
var _use_onechat_service = require("./use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConversationList = ({
  agentId
} = {}) => {
  const {
    conversationsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data: conversations,
    isLoading,
    refetch: refresh
  } = (0, _reactQuery.useQuery)({
    queryKey: agentId ? _query_keys.queryKeys.conversations.byAgent(agentId) : _query_keys.queryKeys.conversations.all,
    queryFn: () => {
      return conversationsService.list({
        agentId
      });
    }
  });
  return {
    conversations,
    isLoading,
    refresh
  };
};
exports.useConversationList = useConversationList;