"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolFormMode = exports.ToolForm = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _configuration = require("./sections/configuration");
var _labels = require("./sections/labels");
var _system_references = require("./sections/system_references");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/tool_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ToolFormMode = exports.ToolFormMode = /*#__PURE__*/function (ToolFormMode) {
  ToolFormMode["Create"] = "create";
  ToolFormMode["Edit"] = "edit";
  ToolFormMode["View"] = "view";
  return ToolFormMode;
}({});
const ToolForm = ({
  mode,
  formId,
  saveTool,
  toolType,
  setToolType
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    handleSubmit
  } = (0, _reactHookForm.useFormContext)();
  const isViewMode = mode === ToolFormMode.View;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    component: "form",
    id: formId,
    onSubmit: !isViewMode ? handleSubmit(saveTool) : undefined,
    fullWidth: true,
    css: (0, _react.css)`
        .euiFormHelpText {
          color: ${euiTheme.colors.textSubdued};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_system_references.SystemReferences, {
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_labels.Labels, {
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), !isViewMode && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_configuration.Configuration, {
    toolType: toolType,
    setToolType: setToolType,
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
};
exports.ToolForm = ToolForm;