"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeESQL = VisualizeESQL;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styles = require("./styles");
var _use_lens_input = require("./use_lens_input");
var _visualization_actions = require("./visualization_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/esql/visualize_esql/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VISUALIZATION_HEIGHT = 240;
function VisualizeESQL({
  lens,
  dataViews,
  uiActions,
  esqlColumns,
  esqlQuery,
  preferredChartType
}) {
  const [isSaveModalOpen, setIsSaveModalOpen] = (0, _react.useState)(false);
  const [lensLoadEvent, setLensLoadEvent] = (0, _react.useState)(null);
  const {
    lensInput,
    setLensInput,
    isLoading
  } = (0, _use_lens_input.useLensInput)({
    lens,
    dataViews,
    esqlQuery,
    esqlColumns,
    preferredChartType
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onLoad = (0, _react.useCallback)((_isLoading, adapters, dataLoading$) => {
    var _adapters$tables;
    if (!_isLoading && adapters !== null && adapters !== void 0 && (_adapters$tables = adapters.tables) !== null && _adapters$tables !== void 0 && _adapters$tables.tables) {
      setLensLoadEvent({
        adapters,
        dataLoading$
      });
    }
  }, []);
  const onOpenSave = (0, _react.useCallback)(() => setIsSaveModalOpen(true), []);
  const onCloseSave = (0, _react.useCallback)(() => setIsSaveModalOpen(false), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "lensVisualization",
    css: (0, _styles.visualizationWrapper)(euiTheme, VISUALIZATION_HEIGHT),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, !isLoading && lensInput && /*#__PURE__*/_react.default.createElement(_visualization_actions.VisualizationActions, {
    onSave: onOpenSave,
    uiActions: uiActions,
    lensInput: lensInput,
    lensLoadEvent: lensLoadEvent,
    setLensInput: setLensInput,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }) : lensInput && /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensInput, {
    style: {
      height: '100%'
    },
    onLoad: onLoad,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }))), isSaveModalOpen && lensInput && /*#__PURE__*/_react.default.createElement(lens.SaveModalComponent, {
    initialInput: lensInput,
    onClose: onCloseSave,
    isSaveable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }));
}