"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatMessageText = ChatMessageText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _use_onechat_service = require("../../../hooks/use_onechat_service");
var _markdown_plugins = require("./markdown_plugins");
var _use_conversation = require("../../../hooks/use_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/chat_message_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component handling markdown support to the assistant's responses.
 * Also handles "loading" state by appending the blinking cursor.
 */
function ChatMessageText({
  content,
  steps: stepsFromCurrentRound
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const containerClassName = (0, _css.css)`
    overflow-wrap: anywhere;

    /* Standardize spacing between numbered list items */
    ol > li:not(:first-child) {
      margin-top: ${euiTheme.size.s};
    }

    ol > li > p {
      margin-bottom: ${euiTheme.size.s};
    }
  `;
  const {
    startDependencies
  } = (0, _use_onechat_service.useOnechatServices)();
  const stepsFromPrevRounds = (0, _use_conversation.useStepsFromPrevRounds)();
  const {
    parsingPluginList,
    processingPluginList
  } = (0, _react.useMemo)(() => {
    const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
    const defaultProcessingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
    const [remarkToRehypePlugin, remarkToRehypeOptions] = defaultProcessingPlugins[0];
    const [rehypeToReactPlugin, rehypeToReactOptions] = defaultProcessingPlugins[1];
    const processingPlugins = [[remarkToRehypePlugin, remarkToRehypeOptions], [rehypeToReactPlugin, rehypeToReactOptions]];
    rehypeToReactOptions.components = {
      ...rehypeToReactOptions.components,
      cursor: _markdown_plugins.Cursor,
      codeBlock: props => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 13
          }
        }, props.value), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 13
          }
        }));
      },
      esql: props => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 13
          }
        }, props.value), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 13
          }
        }));
      },
      table: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, (0, _extends2.default)({}, props, {
        className: (0, _css.css)`
              .euiTableCellContent__text {
                white-space: normal;
              }
            `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      })),
      th: props => {
        const {
          children,
          ...rest
        } = props;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, (0, _extends2.default)({}, rest, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 16
          }
        }), children);
      },
      tr: props => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, (0, _extends2.default)({}, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 22
        }
      })),
      td: props => {
        const {
          children,
          ...rest
        } = props;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, (0, _extends2.default)({
          truncateText: true
        }, rest, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 11
          }
        }), children);
      },
      [_tool_result.visualizationElement.tagName]: (0, _markdown_plugins.createVisualizationRenderer)({
        startDependencies,
        stepsFromCurrentRound,
        stepsFromPrevRounds
      })
    };
    return {
      parsingPluginList: [_markdown_plugins.loadingCursorPlugin, _markdown_plugins.esqlLanguagePlugin, _markdown_plugins.visualizationTagParser, ...parsingPlugins],
      processingPluginList: processingPlugins
    };
  }, [startDependencies, stepsFromCurrentRound, stepsFromPrevRounds]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: containerClassName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "s",
    parsingPluginList: parsingPluginList,
    processingPluginList: processingPluginList,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, content));
}