"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiPrivileges = exports.apiPrivileges = exports.ONECHAT_PATH = exports.ONECHAT_FEATURE_NAME = exports.ONECHAT_FEATURE_ID = exports.ONECHAT_APP_ID = exports.AGENT_BUILDER_SHORT_TITLE = exports.AGENT_BUILDER_FULL_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONECHAT_FEATURE_ID = exports.ONECHAT_FEATURE_ID = 'agentBuilder';
const ONECHAT_FEATURE_NAME = exports.ONECHAT_FEATURE_NAME = 'Agent Builder';
const ONECHAT_APP_ID = exports.ONECHAT_APP_ID = 'agent_builder';
const ONECHAT_PATH = exports.ONECHAT_PATH = '/app/agent_builder';
const AGENT_BUILDER_FULL_TITLE = exports.AGENT_BUILDER_FULL_TITLE = _i18n.i18n.translate('xpack.onechat.app.fullTitle', {
  defaultMessage: 'Agent Builder'
});
const AGENT_BUILDER_SHORT_TITLE = exports.AGENT_BUILDER_SHORT_TITLE = _i18n.i18n.translate('xpack.onechat.app.shortTitle', {
  defaultMessage: 'Agents'
});
const uiPrivileges = exports.uiPrivileges = {
  show: 'show',
  showManagement: 'showManagement'
};
const apiPrivileges = exports.apiPrivileges = {
  readOnechat: 'read_onechat',
  manageOnechat: 'manage_onechat'
};