"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatResourceWithSampledValues = void 0;
var _lodash = require("lodash");
var _formatting = require("../formatting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents a resource as a xml tree,
 * useful for including them into a prompt
 */
const formatResourceWithSampledValues = ({
  resource,
  indentLevel
}) => {
  return (0, _formatting.generateXmlTree)({
    tagName: 'target_resource',
    attributes: {
      name: resource.name,
      type: resource.type
    },
    children: [{
      tagName: 'fields',
      children: resource.fields.map(field => mapFieldWithStats(field, 3))
    }]
  }, {
    initialIndentLevel: indentLevel
  });
};
exports.formatResourceWithSampledValues = formatResourceWithSampledValues;
const mapFieldWithStats = (field, maxValues = 3) => {
  return {
    tagName: 'field',
    attributes: {
      path: field.path,
      type: field.type,
      description: field.meta.description
    },
    children: field.stats.values.length ? [{
      tagName: 'sample_values',
      children: (0, _lodash.take)(field.stats.values, maxValues).map(value => {
        return {
          tagName: 'value',
          children: [truncate(normalizeSpaces(`${value.value}`), 100)]
        };
      })
    }] : undefined
  };
};
const truncate = (text, maxLength) => {
  const str = String(text);
  if (str.length <= maxLength) {
    return str;
  }
  return str.substring(0, maxLength) + '[truncated]';
};
const normalizeSpaces = input => {
  return input.trim().replace(/\s+/g, ' ');
};