"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenMapping = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a flattened representation of the mappings, with all fields at the top level.
 */
const flattenMapping = mapping => {
  var _mapping$properties;
  const properties = (_mapping$properties = mapping.properties) !== null && _mapping$properties !== void 0 ? _mapping$properties : {};
  function extractFields(obj, prefix = '') {
    let fields = [];
    for (const [key, value] of Object.entries(obj)) {
      const fieldPath = prefix ? `${prefix}.${key}` : key;
      if (value.type) {
        var _value$meta;
        // If it's a leaf field, add it
        fields.push({
          type: value.type,
          path: fieldPath,
          meta: (_value$meta = value.meta) !== null && _value$meta !== void 0 ? _value$meta : {}
        });
      }
      if (value.properties) {
        // If it's an object or has nested props, go deeper
        fields = fields.concat(extractFields(value.properties, fieldPath));
      }
    }
    return fields;
  }
  return extractFields(properties);
};
exports.flattenMapping = flattenMapping;