"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSearchTool = void 0;
var _inferenceTracing = require("@kbn/inference-tracing");
var _tools = require("@kbn/onechat-common/tools");
var _graph = require("./graph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runSearchTool = async ({
  nlQuery,
  index,
  model,
  esClient,
  logger,
  events
}) => {
  const toolGraph = (0, _graph.createSearchToolGraph)({
    model,
    esClient,
    logger,
    events
  });
  return (0, _inferenceTracing.withActiveInferenceSpan)('SearchToolGraph', {
    attributes: {
      [_inferenceTracing.ElasticGenAIAttributes.InferenceSpanKind]: 'CHAIN'
    }
  }, async () => {
    const outState = await toolGraph.invoke({
      nlQuery,
      targetPattern: index
    }, {
      tags: ['search_tool'],
      metadata: {
        graphName: 'search_tool'
      }
    });
    if (outState.error) {
      return [{
        type: _tools.ToolResultType.error,
        data: {
          message: outState.error
        }
      }];
    }
    return outState.results;
  });
};
exports.runSearchTool = runSearchTool;