"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRuleEditable = isRuleEditable;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isRuleEditable({
  capabilities,
  rule,
  ruleType,
  ruleTypeRegistry
}) {
  var _capabilities$actions, _ref, _ruleType$authorizedC;
  const canExecuteActions = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.execute;
  const hasAllPrivilege = (_ref = rule && (ruleType === null || ruleType === void 0 ? void 0 : (_ruleType$authorizedC = ruleType.authorizedConsumers[rule.consumer]) === null || _ruleType$authorizedC === void 0 ? void 0 : _ruleType$authorizedC.all)) !== null && _ref !== void 0 ? _ref : false;
  const canSaveRule = rule && hasAllPrivilege && (
  // if the rule has actions, can the user save the rule's action params
  canExecuteActions || !canExecuteActions && rule.actions.length === 0);
  return Boolean(
  // can the user save the rule
  canSaveRule && (
  // is this rule type editable from within Rules Management
  ruleTypeRegistry.has(rule.ruleTypeId) ? !ruleTypeRegistry.get(rule.ruleTypeId).requiresAppContext : false));
}