"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRule = useFetchRule;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchRule({
  ruleId
}) {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchRule', ruleId],
    queryFn: async ({
      signal
    }) => {
      try {
        if (!ruleId) return;
        const res = await http.get(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(ruleId)}`, {
          signal
        });
        return (0, _public.transformRule)(res);
      } catch (error) {
        throw error;
      }
    },
    keepPreviousData: true,
    enabled: Boolean(ruleId),
    refetchOnWindowFocus: false,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleLoadError', {
          defaultMessage: 'Unable to load rule'
        }),
        toastMessage: error instanceof Error ? error.message : typeof error === 'string' ? error : ''
      });
    }
  });
  return {
    rule: data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}