"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPercent = exports.convertToApiThreshold = void 0;
var _corrected_percent_convert = require("./corrected_percent_convert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToApiThreshold = (previous, next, threshold) => {
  const isPreviousPercent = Boolean(previous.every(metric => {
    var _metric$field;
    return (_metric$field = metric.field) === null || _metric$field === void 0 ? void 0 : _metric$field.endsWith('.pct');
  }));
  const isPercent = Boolean(next.every(metric => {
    var _metric$field2;
    return (_metric$field2 = metric.field) === null || _metric$field2 === void 0 ? void 0 : _metric$field2.endsWith('.pct');
  }));
  return isPercent === isPreviousPercent ? threshold : isPercent ? threshold.map(v => (0, _corrected_percent_convert.pctToDecimal)(v)) : isPreviousPercent ? threshold.map(v => (0, _corrected_percent_convert.decimalToPct)(v)) : threshold;
};
exports.convertToApiThreshold = convertToApiThreshold;
const isPercent = metrics => Boolean(metrics.every(metric => {
  var _metric$field3;
  return (_metric$field3 = metric.field) === null || _metric$field3 === void 0 ? void 0 : _metric$field3.endsWith('.pct');
}));
exports.isPercent = isPercent;