"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnnotationPermissions = useAnnotationPermissions;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAnnotationPermissions() {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchAnnotationPermissions'],
    queryFn: async ({}) => {
      return await http.get('/api/observability/annotation/permissions');
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isSuccess,
    isError,
    refetch
  };
}