"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertSearchBarState = void 0;
exports.useAlertSearchBarStateContainer = useAlertSearchBarStateContainer;
var _Either = require("fp-ts/Either");
var _pipeable = require("fp-ts/pipeable");
var t = _interopRequireWildcard(require("io-ts"));
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("@kbn/alerts-ui-shared/src/alert_filter_controls/constants");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/kibana-utils-plugin/public");
var _set_status_on_control_configs = require("../../../utils/alert_controls/set_status_on_control_configs");
var _datemath = require("../../../utils/datemath");
var _constants2 = require("../../../../common/constants");
var _use_timefilter_service = require("../../../hooks/use_timefilter_service");
var _state_container = require("./state_container");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertSearchBarState = exports.alertSearchBarState = t.partial({
  rangeFrom: _datemath.datemathStringRT,
  rangeTo: _datemath.datemathStringRT,
  kuery: t.string,
  status: t.union([t.literal(_ruleDataUtils.ALERT_STATUS_ACTIVE), t.literal(_ruleDataUtils.ALERT_STATUS_RECOVERED), t.literal(_constants2.ALERT_STATUS_ALL), t.literal(_ruleDataUtils.ALERT_STATUS_UNTRACKED)]),
  groupings: t.array(t.string)
});
function useAlertSearchBarStateContainer(urlStorageKey, {
  replace
} = {}, defaultState = _state_container.DEFAULT_STATE) {
  const [savedQuery, setSavedQuery] = (0, _react.useState)();
  const stateContainer = (0, _state_container.useContainer)();
  useUrlStateSyncEffect(stateContainer, urlStorageKey, replace, defaultState);
  const {
    setRangeFrom,
    setRangeTo,
    setKuery,
    setStatus,
    setFilters,
    setSavedQueryId,
    setControlConfigs,
    setGroupings
  } = stateContainer.transitions;
  const {
    rangeFrom,
    rangeTo,
    kuery,
    status,
    filters,
    savedQueryId,
    controlConfigs,
    groupings
  } = (0, _public.useContainerSelector)(stateContainer, state => state);
  (0, _react.useEffect)(() => {
    if (!savedQuery) {
      setSavedQueryId(undefined);
      return;
    }
    if (savedQuery.id !== savedQueryId) {
      var _savedQuery$attribute, _savedQuery$attribute2, _savedQuery$attribute3;
      setSavedQueryId(savedQuery.id);
      if (typeof savedQuery.attributes.query.query === 'string') {
        setKuery(savedQuery.attributes.query.query);
      }
      if ((_savedQuery$attribute = savedQuery.attributes.filters) !== null && _savedQuery$attribute !== void 0 && _savedQuery$attribute.length) {
        setFilters(savedQuery.attributes.filters);
      }
      if ((_savedQuery$attribute2 = savedQuery.attributes.timefilter) !== null && _savedQuery$attribute2 !== void 0 && _savedQuery$attribute2.from) {
        setRangeFrom(savedQuery.attributes.timefilter.from);
      }
      if ((_savedQuery$attribute3 = savedQuery.attributes.timefilter) !== null && _savedQuery$attribute3 !== void 0 && _savedQuery$attribute3.to) {
        setRangeFrom(savedQuery.attributes.timefilter.to);
      }
    }
  }, [savedQuery, savedQueryId, setFilters, setKuery, setRangeFrom, setSavedQueryId, stateContainer]);
  return {
    kuery,
    onKueryChange: setKuery,
    onRangeFromChange: setRangeFrom,
    onRangeToChange: setRangeTo,
    onStatusChange: setStatus,
    onFiltersChange: setFilters,
    onControlConfigsChange: setControlConfigs,
    onGroupingsChange: setGroupings,
    controlConfigs,
    filters,
    rangeFrom,
    rangeTo,
    status,
    savedQuery,
    setSavedQuery,
    groupings
  };
}
function useUrlStateSyncEffect(stateContainer, urlStorageKey, replace = true, defaultState = _state_container.DEFAULT_STATE) {
  const history = (0, _reactRouterDom.useHistory)();
  const timefilterService = (0, _use_timefilter_service.useTimefilterService)();
  (0, _react.useEffect)(() => {
    const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
      history,
      useHash: false,
      useHashQuery: false
    });
    const {
      start,
      stop
    } = setupUrlStateSync(stateContainer, urlStateStorage, urlStorageKey, replace);
    initializeUrlAndStateContainer(timefilterService, stateContainer, urlStateStorage, urlStorageKey, defaultState);
    start();
    return stop;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [stateContainer, history, timefilterService, urlStorageKey, replace]);
}
function setupUrlStateSync(stateContainer, urlStateStorage, urlStorageKey, replace = true, defaultState = _state_container.DEFAULT_STATE) {
  // This handles filling the state when an incomplete URL set is provided
  const setWithDefaults = changedState => {
    stateContainer.set({
      ...defaultState,
      ...changedState
    });
  };
  return (0, _public.syncState)({
    storageKey: urlStorageKey,
    stateContainer: {
      ...stateContainer,
      set: setWithDefaults
    },
    stateStorage: {
      ...urlStateStorage,
      set: (key, state) => urlStateStorage.set(key, state, {
        replace
      })
    }
  });
}
function initializeUrlAndStateContainer(timefilterService, stateContainer, urlStateStorage, urlStorageKey, defaultState) {
  const urlState = alertSearchBarState.decode(urlStateStorage.get(urlStorageKey));
  const validUrlState = (0, _Either.isRight)(urlState) ? (0, _pipeable.pipe)(urlState).right : {};
  const timeFilterTime = timefilterService.getTime();
  const timeFilterState = timefilterService.isTimeTouched() ? {
    rangeFrom: timeFilterTime.from,
    rangeTo: timeFilterTime.to
  } : {};

  // This part is for backward compatibility. Previously, we saved status in the status query
  // parameter. Now, we save it in the controlConfigs.
  if (validUrlState.status) {
    var _validUrlState$contro;
    validUrlState.controlConfigs = (0, _set_status_on_control_configs.setStatusOnControlConfigs)(validUrlState.status, (_validUrlState$contro = validUrlState.controlConfigs) !== null && _validUrlState$contro !== void 0 ? _validUrlState$contro : _constants.DEFAULT_CONTROLS);
    validUrlState.status = undefined;
  }
  const currentState = {
    ...defaultState,
    ...timeFilterState,
    ...validUrlState
  };
  stateContainer.set(currentState);
  urlStateStorage.set(urlStorageKey, currentState, {
    replace: true
  });
  urlStateStorage.kbnUrlControls.flush();
}