"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentSteps = InstallElasticAgentSteps;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _buffer = require("buffer");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _step_status = require("./step_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/shared/install_elastic_agent_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function InstallElasticAgentSteps({
  installAgentPlatformOptions,
  onSelectPlatform,
  selectedPlatform,
  installAgentCommand,
  autoDownloadConfig,
  onToggleAutoDownloadConfig,
  installAgentStatus,
  showInstallProgressSteps,
  installProgressSteps,
  configureAgentStatus,
  configureAgentYaml,
  appendedSteps = []
}) {
  var _installAgentPlatform, _installAgentPlatform2;
  const configPath = selectedPlatform === 'macos' ? '/Library/Elastic/Agent/elastic-agent.yml' : '/opt/Elastic/Agent/elastic-agent.yml';
  const isInstallStarted = (0, _lodash.intersection)(Object.keys(installProgressSteps), Object.keys(PROGRESS_STEP_TITLES(configPath))).length > 0;
  const autoDownloadConfigStep = getStep('ea-config', installProgressSteps, configPath);
  const customInstallStep = (_installAgentPlatform = installAgentPlatformOptions.find(step => step.id === selectedPlatform)) === null || _installAgentPlatform === void 0 ? void 0 : _installAgentPlatform.children;
  const disableSteps = (_installAgentPlatform2 = installAgentPlatformOptions.find(step => step.id === selectedPlatform)) === null || _installAgentPlatform2 === void 0 ? void 0 : _installAgentPlatform2.disableSteps;
  const installStepDefault = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, installAgentCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), showInstallProgressSteps && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, ['ea-download', 'ea-extract', 'ea-install', 'ea-status'].map(stepId => {
    const {
      title,
      status,
      message
    } = getStep(stepId, installProgressSteps, configPath);
    return /*#__PURE__*/_react.default.createElement(_step_status.StepStatus, {
      status: status,
      title: title,
      message: message,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 22
      }
    });
  }))));
  const configureStep = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, autoDownloadConfig ? _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.auto.description', {
    defaultMessage: 'The agent config below will be downloaded by the install script and written to ({configPath}). This will overwrite any existing agent configuration.',
    values: {
      configPath
    }
  }) : _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.manual.description', {
    defaultMessage: 'Add the following configuration to {configPath} on the host where you installed the Elastic Agent.',
    values: {
      configPath
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: false,
    contentAriaLabel: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.yamlCodeBlockdescription', {
      defaultMessage: 'Elastic Agent yaml configuration'
    }),
    width: "100%",
    height: 300,
    borderRadius: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    style: {
      opacity: autoDownloadConfig ? '.5' : '1'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, configureAgentYaml)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "download",
    color: "primary",
    href: `data:application/yaml;base64,${_buffer.Buffer.from(configureAgentYaml, 'utf8').toString('base64')}`,
    download: "elastic-agent.yml",
    target: "_blank",
    isDisabled: autoDownloadConfig,
    "data-test-subj": "obltOnboardingConfigureElasticAgentStepDownloadConfig",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.downloadConfigButton', {
    defaultMessage: 'Download config file'
  })), showInstallProgressSteps && autoDownloadConfig ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_step_status.StepStatus, {
    status: autoDownloadConfigStep.status,
    title: autoDownloadConfigStep.title,
    message: autoDownloadConfigStep.message,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }))) : null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      'data-test-subj': 'obltOnboardingInstallElasticAgentStep',
      title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.title', {
        defaultMessage: 'Install the Elastic Agent'
      }),
      status: installAgentStatus,
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.installElasticAgent.installStep.description",
        defaultMessage: "Select your platform, and run the install command in your terminal to enroll and start the Elastic Agent. Do this for each host. Review {hostRequirementsLink} before installing.",
        values: {
          hostRequirementsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "observabilityOnboardingInstallElasticAgentStepsHostRequirementsAndOtherInstallationOptionsLink",
            external: true,
            href: "https://www.elastic.co/guide/en/fleet/8.7/elastic-agent-installation.html",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 214,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.hostRequirements', {
            defaultMessage: 'host requirements and other installation options'
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "xs",
          responsive: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 234,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 235,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig', {
          defaultMessage: "Automatically download the agent's config"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 243,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig.tooltip', {
            defaultMessage: "Turn on to add a string to the following code block that downloads the agent's standard configuration to your host during installation. Turn off to manually configure the agent in the next step."
          }),
          position: "right",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 244,
            columnNumber: 23
          }
        }))),
        checked: autoDownloadConfig,
        onChange: onToggleAutoDownloadConfig,
        disabled: disableSteps || isInstallStarted,
        "data-test-subj": "obltOnboardingInstallElasticAgentAutoDownloadConfig",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 232,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 15
        }
      }), autoDownloadConfig && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig.overwriteWarning', {
          defaultMessage: 'Automatically downloading the agent config will overwrite any existing agent config on your host.'
        }),
        color: "warning",
        iconType: "warning",
        "data-test-subj": "obltOnboardingInstallElasticAgentAutoDownloadConfigCallout",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 277,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        isFullWidth: true,
        legend: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform', {
          defaultMessage: 'Choose platform'
        }),
        options: installAgentPlatformOptions.map(({
          id,
          label,
          isDisabled
        }) => ({
          id,
          label,
          isDisabled
        })),
        type: "single",
        idSelected: selectedPlatform,
        onChange: id => {
          onSelectPlatform(id);
        },
        isDisabled: isInstallStarted,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 15
        }
      }), customInstallStep || installStepDefault)
    }, {
      'data-test-subj': 'obltOnboardingConfigureElasticAgentStep',
      title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configureStep.title', {
        defaultMessage: 'Configure the Elastic Agent'
      }),
      status: disableSteps ? 'disabled' : configureAgentStatus,
      children: disableSteps ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : configureStep
    }, ...appendedSteps.map(euiStep => ({
      children: null,
      ...euiStep,
      status: disableSteps ? 'disabled' : euiStep.status,
      'data-test-subj': euiStep['data-test-subj']
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 5
    }
  });
}
function getStep(id, installProgressSteps, configPath) {
  const {
    loadingTitle,
    completedTitle,
    incompleteTitle
  } = PROGRESS_STEP_TITLES(configPath)[id];
  const stepProgress = installProgressSteps[id];
  if (stepProgress) {
    const {
      status,
      message
    } = stepProgress;
    const title = status === 'loading' ? loadingTitle : status === 'complete' ? completedTitle : incompleteTitle;
    return {
      title,
      status: status !== null && status !== void 0 ? status : 'incomplete',
      message
    };
  }
  return {
    title: incompleteTitle,
    status: 'incomplete'
  };
}
const PROGRESS_STEP_TITLES = configPath => ({
  'ea-download': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.incompleteTitle', {
      defaultMessage: 'Download Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.loadingTitle', {
      defaultMessage: 'Downloading Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.completedTitle', {
      defaultMessage: 'Elastic Agent downloaded'
    })
  },
  'ea-extract': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.incompleteTitle', {
      defaultMessage: 'Extract Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.loadingTitle', {
      defaultMessage: 'Extracting Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.completedTitle', {
      defaultMessage: 'Elastic Agent extracted'
    })
  },
  'ea-install': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.incompleteTitle', {
      defaultMessage: 'Install Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.loadingTitle', {
      defaultMessage: 'Installing Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.completedTitle', {
      defaultMessage: 'Elastic Agent installed'
    })
  },
  'ea-status': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.incompleteTitle', {
      defaultMessage: 'Connect to the Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.loadingTitle', {
      defaultMessage: 'Connecting to the Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.completedTitle', {
      defaultMessage: 'Connected to the Elastic Agent'
    })
  },
  'ea-config': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.incompleteTitle', {
      defaultMessage: 'Configure the agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.loadingTitle', {
      defaultMessage: 'Downloading Elastic Agent config'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.completedTitle', {
      defaultMessage: 'Elastic Agent config written to {configPath}',
      values: {
        configPath
      }
    })
  }
});