"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DASHBOARDS = void 0;
exports.useOnboardingFlow = useOnboardingFlow;
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _public = require("@kbn/kibana-react-plugin/public");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _react = require("react");
var _telemetry_events = require("../../../../common/telemetry_events");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _get_onboarding_status = require("./get_onboarding_status");
var _get_installed_integrations = require("./get_installed_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARDS = exports.DASHBOARDS = {
  'apache-Logs-Apache-Dashboard': {
    type: 'logs'
  },
  'docker-AV4REOpp5NkDleZmzKkE': {
    type: 'metrics'
  },
  'nginx-55a9e6e0-a29e-11e7-928f-5dbe6f6f5519': {
    type: 'logs'
  },
  'system-79ffd6e0-faa0-11e6-947f-177f697178b8': {
    type: 'metrics'
  },
  'mysql-Logs-MySQL-Dashboard': {
    type: 'logs'
  },
  'postgresql-158be870-87f4-11e7-ad9c-db80de0bf8d3': {
    type: 'logs'
  },
  'redis-7fea2930-478e-11e7-b1f0-cb29bac6bf8b': {
    type: 'logs'
  },
  'haproxy-3560d580-aa34-11e8-9c06-877f0445e3e0': {
    type: 'logs'
  },
  'rabbitmq-AV4YobKIge1VCbKU_qVo': {
    type: 'metrics'
  },
  'kafka-943caca0-87ee-11e7-ad9c-db80de0bf8d3': {
    type: 'logs'
  },
  'apache_tomcat-8fd54a20-1f0d-11ee-9d6b-bb41d08322c8': {
    type: 'logs'
  },
  'mongodb-abcf35b0-0a82-11e8-bffe-ff7d4f68cf94': {
    type: 'logs'
  },
  'prometheus-c181a040-3d96-11ed-b624-b12467b8df74': {
    type: 'metrics'
  }
};
function useOnboardingFlow() {
  var _assetsState$value;
  const {
    services: {
      fleet,
      analytics
    }
  } = (0, _public.useKibana)();
  const [dataReceivedTelemetrySent, setDataReceivedTelemetrySent] = (0, _react.useState)(false);

  // Create onboarding session
  const {
    data,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApi => callApi('POST /internal/observability_onboarding/flow'), [], {
    showToastOnError: false
  });
  const onboardingId = data === null || data === void 0 ? void 0 : data.onboardingFlow.id;

  // Fetch onboarding progress
  const {
    data: progressData,
    status: progressStatus,
    refetch: refetchProgress
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (onboardingId) {
      return callApi('GET /internal/observability_onboarding/flow/{onboardingId}/progress', {
        params: {
          path: {
            onboardingId
          }
        }
      });
    }
  }, [onboardingId]);
  const status = (0, _get_onboarding_status.getOnboardingStatus)(progressData);
  const installedIntegrations = (0, _get_installed_integrations.getInstalledIntegrations)(progressData);

  // Fetch metadata for installed Kibana assets
  const assetsState = (0, _useAsync.default)(async () => {
    if (installedIntegrations.length === 0) {
      return [];
    }
    const assetsMetadata = await fleet.hooks.epm.getBulkAssets({
      assetIds: installedIntegrations.map(integration => integration.kibanaAssets).flat().filter(asset => Object.keys(DASHBOARDS).includes(asset.id))
    });
    return installedIntegrations.map(integration => {
      return {
        ...integration,
        // Enrich installed Kibana assets with metadata from Fleet API (e.g. title, description, etc.)
        kibanaAssets: integration.kibanaAssets.reduce((acc, asset) => {
          var _assetsMetadata$data;
          const assetWithMetadata = (_assetsMetadata$data = assetsMetadata.data) === null || _assetsMetadata$data === void 0 ? void 0 : _assetsMetadata$data.items.find(({
            id
          }) => id === asset.id);
          if (assetWithMetadata) {
            acc.push(assetWithMetadata);
          }
          return acc;
        }, [])
      };
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [installedIntegrations.length]);
  (0, _useInterval.default)(refetchProgress, progressStatus === _use_fetcher.FETCH_STATUS.SUCCESS && status !== 'dataReceived' ? 3000 : null);
  (0, _react.useEffect)(() => {
    if (status === 'dataReceived' && !dataReceivedTelemetrySent) {
      setDataReceivedTelemetrySent(true);
      analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_TELEMETRY_EVENT.eventType, {
        flow_type: 'autoDetect',
        flow_id: onboardingId,
        step: 'logs-ingest',
        step_status: 'complete'
      });
    }
  }, [analytics, dataReceivedTelemetrySent, onboardingId, status]);
  return {
    data,
    error,
    refetch,
    status,
    installedIntegrations: (_assetsState$value = assetsState.value) !== null && _assetsState$value !== void 0 ? _assetsState$value : []
  };
}