"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALERTS_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.ALERTS_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "CHANGES_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.CHANGES_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "CONTEXT_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.CONTEXT_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "ELASTICSEARCH_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.ELASTICSEARCH_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "EXECUTE_CONNECTOR_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.EXECUTE_CONNECTOR_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "EXECUTE_QUERY_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.EXECUTE_QUERY_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_ALERTS_DATASET_INFO_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_ALERTS_DATASET_INFO_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_APM_DATASET_INFO_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_APM_DATASET_INFO_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_APM_DOWNSTREAM_DEPENDENCIES_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_APM_DOWNSTREAM_DEPENDENCIES_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_APM_SERVICES_LIST_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_APM_SERVICES_LIST_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_APM_TIMESERIES_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_APM_TIMESERIES_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_DATASET_INFO_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_DATASET_INFO_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "GET_DATA_ON_SCREEN_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.GET_DATA_ON_SCREEN_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "KIBANA_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.KIBANA_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "LENS_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.LENS_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "QUERY_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.QUERY_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "RETRIEVE_ELASTIC_DOC_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.RETRIEVE_ELASTIC_DOC_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "SELECT_RELEVANT_FIELDS_NAME", {
  enumerable: true,
  get: function () {
    return _common.SELECT_RELEVANT_FIELDS_NAME;
  }
});
Object.defineProperty(exports, "SUMMARIZE_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.SUMMARIZE_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "VISUALIZE_QUERY_FUNCTION_NAME", {
  enumerable: true,
  get: function () {
    return _common.VISUALIZE_QUERY_FUNCTION_NAME;
  }
});
Object.defineProperty(exports, "aiAssistantLogsIndexPattern", {
  enumerable: true,
  get: function () {
    return _common.aiAssistantLogsIndexPattern;
  }
});
Object.defineProperty(exports, "aiAssistantSearchConnectorIndexPattern", {
  enumerable: true,
  get: function () {
    return _common.aiAssistantSearchConnectorIndexPattern;
  }
});
Object.defineProperty(exports, "aiAssistantSimulatedFunctionCalling", {
  enumerable: true,
  get: function () {
    return _common.aiAssistantSimulatedFunctionCalling;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createFunctionRequestMessage", {
  enumerable: true,
  get: function () {
    return _create_function_request_message.createFunctionRequestMessage;
  }
});
Object.defineProperty(exports, "createFunctionResponseMessage", {
  enumerable: true,
  get: function () {
    return _create_function_response_message.createFunctionResponseMessage;
  }
});
Object.defineProperty(exports, "getInferenceIdFromWriteIndex", {
  enumerable: true,
  get: function () {
    return _get_inference_id_from_write_index.getInferenceIdFromWriteIndex;
  }
});
exports.plugin = void 0;
Object.defineProperty(exports, "streamIntoObservable", {
  enumerable: true,
  get: function () {
    return _stream_into_observable.streamIntoObservable;
  }
});
var _config = require("./config");
var _common = require("../common");
var _stream_into_observable = require("./service/util/stream_into_observable");
var _create_function_request_message = require("../common/utils/create_function_request_message");
var _create_function_response_message = require("../common/utils/create_function_response_message");
var _get_inference_id_from_write_index = require("./service/knowledge_base_service/get_inference_id_from_write_index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const config = exports.config = {
  deprecations: ({
    unusedFromRoot
  }) => [unusedFromRoot('xpack.observability.aiAssistant.enabled', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.azureOpenAI.deploymentId', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.azureOpenAI.resourceName', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.azureOpenAI.apiKey', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.openAI.apiKey', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.openAI.model', {
    level: 'warning'
  })],
  exposeToBrowser: {
    scope: true
  },
  schema: _config.config
};
const plugin = async ctx => {
  const {
    ObservabilityAIAssistantPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ObservabilityAIAssistantPlugin(ctx);
};
exports.plugin = plugin;