"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("./analytics");
var _observability_ai_assistant_chat_service_context = require("./context/observability_ai_assistant_chat_service_context");
var _observability_ai_assistant_multipane_flyout_context = require("./context/observability_ai_assistant_multipane_flyout_context");
var _observability_ai_assistant_provider = require("./context/observability_ai_assistant_provider");
var _use_genai_connectors = require("./hooks/use_genai_connectors");
var _use_observability_ai_assistant_chat_service = require("./hooks/use_observability_ai_assistant_chat_service");
var _use_chat = require("./hooks/use_chat");
var _create_service = require("./service/create_service");
var _create_screen_context_action = require("./utils/create_screen_context_action");
var _get_contextual_insight_messages = require("./utils/get_contextual_insight_messages");
var _capabilities = require("../common/capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ObservabilityAIAssistantPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "service", void 0);
    (0, _defineProperty2.default)(this, "scopeFromConfig", void 0);
    this.logger = context.logger.get();
    const config = context.config.get();
    this.scopeFromConfig = config.scope;
  }
  setup(coreSetup, pluginsSetup) {
    (0, _analytics.registerTelemetryEventTypes)(coreSetup.analytics);
    return {};
  }
  start(coreStart, pluginsStart) {
    const service = this.service = (0, _create_service.createService)({
      analytics: coreStart.analytics,
      coreStart,
      enabled: coreStart.application.capabilities.observabilityAIAssistant[_capabilities.aiAssistantCapabilities.show] === true,
      scopes: this.scopeFromConfig ? [this.scopeFromConfig] : ['all'],
      scopeIsMutable: !!this.scopeFromConfig
    });
    const withProviders = (Component, services) => /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: services,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_provider.ObservabilityAIAssistantProvider, {
      value: service,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      ref: ref,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    })))));
    const services = {
      ...coreStart,
      plugins: {
        start: pluginsStart
      }
    };
    const isEnabled = service.isEnabled();
    return {
      service,
      useGenAIConnectors: () => (0, _use_genai_connectors.useGenAIConnectorsWithoutContext)(service),
      useChat: (0, _use_chat.createUseChat)({
        notifications: coreStart.notifications
      }),
      ObservabilityAIAssistantMultipaneFlyoutContext: _observability_ai_assistant_multipane_flyout_context.ObservabilityAIAssistantMultipaneFlyoutContext,
      ObservabilityAIAssistantChatServiceContext: _observability_ai_assistant_chat_service_context.ObservabilityAIAssistantChatServiceContext,
      useObservabilityAIAssistantChatService: _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService,
      ObservabilityAIAssistantContextualInsight: isEnabled ? (0, _sharedUxUtility.withSuspense)(withProviders(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/insight/insight'))).then(m => ({
        default: m.Insight
      }))), services)) : null,
      getContextualInsightMessages: _get_contextual_insight_messages.getContextualInsightMessages,
      createScreenContextAction: _create_screen_context_action.createScreenContextAction
    };
  }
}
exports.ObservabilityAIAssistantPlugin = ObservabilityAIAssistantPlugin;