"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductDocSetting = ProductDocSetting;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/settings_tab/product_doc_setting.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statusToLabelMap = {
  installed: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installProductDocInstalledLabel', {
    defaultMessage: 'Installed'
  }),
  uninstalled: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.status.uninstalled', {
    defaultMessage: 'Not installed'
  }),
  installing: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installingText', {
    defaultMessage: 'Installing…'
  }),
  uninstalling: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.status.uninstalling', {
    defaultMessage: 'Uninstalling…'
  })
};
function ProductDocSetting({
  knowledgeBase,
  currentlyDeployedInferenceId
}) {
  const {
    overlays
  } = (0, _use_kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [actionError, setActionError] = (0, _react.useState)(null);
  const {
    status,
    isProductDocInstalling,
    isProductDocUninstalling,
    installProductDoc,
    uninstallProductDoc
  } = knowledgeBase;
  const kb = status === null || status === void 0 ? void 0 : status.value;
  const kbProductDocStatus = kb === null || kb === void 0 ? void 0 : kb.productDocStatus;
  const canInstallProductDoc = currentlyDeployedInferenceId !== undefined && !(knowledgeBase.isInstalling || knowledgeBase.isWarmingUpModel) && (kb === null || kb === void 0 ? void 0 : kb.inferenceModelState) === _public.InferenceModelState.READY;
  const isLoading = isProductDocInstalling || isProductDocUninstalling || kbProductDocStatus === 'installing' || kbProductDocStatus === 'uninstalling';
  const productDocStatus = isProductDocInstalling || kbProductDocStatus === 'installing' ? 'installing' : isProductDocUninstalling || kbProductDocStatus === 'uninstalling' ? 'uninstalling' : kbProductDocStatus !== null && kbProductDocStatus !== void 0 ? kbProductDocStatus : 'uninstalled';
  const hasBackendError = kbProductDocStatus === 'error';
  const showErrorCallout = hasBackendError || Boolean(actionError);
  const badgeColor = productDocStatus === 'installed' ? 'success' : hasBackendError ? 'warning' : 'default';
  const statusLabel = hasBackendError ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.notAvailableLabel', {
    defaultMessage: 'Not available'
  }) : statusToLabelMap[productDocStatus];
  const linkCss = {
    display: 'inline-flex',
    alignItems: 'center',
    gap: euiTheme.size.xs,
    fontWeight: euiTheme.font.weight.regular
  };
  const onClickInstall = (0, _react.useCallback)(async () => {
    try {
      setActionError(null);
      if (!currentlyDeployedInferenceId) {
        throw new Error('Inference ID is required to install product documentation');
      }
      await installProductDoc(currentlyDeployedInferenceId);
    } catch (e) {
      const msg = e instanceof Error && e.message ? e.message : String(e);
      setActionError(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocInstallErrorTitle', {
        defaultMessage: 'Elastic documentation failed to install'
      }) + `: ${msg}`);
    }
  }, [installProductDoc, currentlyDeployedInferenceId]);
  const onClickUninstall = (0, _react.useCallback)(() => {
    overlays.openConfirm(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocUninstallConfirmText', {
      defaultMessage: `Are you sure you want to uninstall the Elastic documentation?`
    }), {
      title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocUninstallConfirmTitle', {
        defaultMessage: `Uninstalling Elastic documentation`
      })
    }).then(confirmed => {
      if (confirmed && currentlyDeployedInferenceId) {
        uninstallProductDoc(currentlyDeployedInferenceId);
      }
    });
  }, [overlays, uninstallProductDoc, currentlyDeployedInferenceId]);
  const onRetry = (0, _react.useCallback)(async () => {
    try {
      setActionError(null);
      if (!currentlyDeployedInferenceId) {
        throw new Error('Inference ID is required to install product documentation');
      }
      await installProductDoc(currentlyDeployedInferenceId);
    } catch (e) {
      setActionError(e instanceof Error ? e.message : String(e));
    }
  }, [installProductDoc, currentlyDeployedInferenceId]);
  const TechPreviewTip = /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    tooltipPosition: "bottom",
    label: "",
    tooltipContent: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.techPreviewAriaLabel', {
      defaultMessage: 'Technical preview'
    }),
    iconType: "beaker",
    size: "s",
    anchorProps: {
      style: {
        verticalAlign: 'middle'
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  });
  const RetryLink = !isLoading && showErrorCallout ? canInstallProductDoc ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onRetry,
    color: "primary",
    "data-test-subj": "productDocRetryLink",
    css: linkCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "refresh",
    size: "s",
    "data-test-subj": "productDocRetryIcon",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.retryLinkLabel', {
    defaultMessage: 'Retry'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installDissabledTooltip', {
      defaultMessage: 'Knowledge Base has to be installed first.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    component: "span",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onRetry,
    color: "primary",
    "data-test-subj": "productDocRetryLink",
    "aria-disabled": true,
    css: linkCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "refresh",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.retryLinkLabel', {
    defaultMessage: 'Retry'
  }))))) : null;
  const ActionLink = (() => {
    if (isLoading || showErrorCallout || (kb === null || kb === void 0 ? void 0 : kb.inferenceModelState) === _public.InferenceModelState.NOT_INSTALLED) return null;
    if (productDocStatus === 'installed') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onClickUninstall,
        color: "primary",
        "data-test-subj": "productDocActionLink",
        "aria-label": "Uninstall Elastic documentation",
        css: linkCss,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "cross",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 248,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.uninstallProductDocButtonLabel', {
        defaultMessage: 'Uninstall'
      })));
    }
    const installInner = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onClickInstall,
      color: "primary",
      "data-test-subj": "productDocActionLink",
      "aria-disabled": !canInstallProductDoc,
      css: linkCss,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "download",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installProductDocButtonLabel', {
      defaultMessage: 'Install'
    })));
    return canInstallProductDoc ? installInner : null;
  })();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      marginBottom: 16,
      marginTop: 8
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }, "\u2022", ' ', _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocStatusPrefix', {
    defaultMessage: 'Elastic documentation '
  }), ' ', TechPreviewTip, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocStatus', {
    defaultMessage: ' status:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    "data-test-subj": "productDocStatusBadge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 13
    }
  }, statusLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "observabilityAiAssistantProductDocLoadingSpinner",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  })), RetryLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 25
    }
  }, RetryLink), ActionLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 26
    }
  }, ActionLink))), showErrorCallout && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    style: {
      width: 528,
      marginBottom: 16
    },
    "data-test-subj": "productDocNotAvailableCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      alignItems: 'flex-start',
      columnGap: 8
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocNotAvailableLine1', {
    defaultMessage: 'The Elastic Documentation is not available. If you are in an air-gapped environment, try using a local artifact to access the product docs and make them available to Kibana.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocNotAvailableLine2Prefix', {
    defaultMessage: 'Check our '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/docs/reference/kibana/configuration-reference/ai-assistant-settings",
    target: "_blank",
    external: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.documentation', {
    defaultMessage: 'documentation'
  })))))));
}