"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateKnowledgeBaseUserInstruction = useCreateKnowledgeBaseUserInstruction;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateKnowledgeBaseUserInstruction() {
  const {
    observabilityAIAssistant,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const observabilityAIAssistantApi = observabilityAIAssistant.service.callApi;
  return (0, _reactQuery.useMutation)([_constants.REACT_QUERY_KEYS.CREATE_KB_ENTRIES], ({
    entry
  }) => {
    return observabilityAIAssistantApi('PUT /internal/observability_ai_assistant/kb/user_instructions', {
      signal: null,
      params: {
        body: {
          id: entry.id,
          text: entry.text,
          public: entry.public
        }
      }
    });
  }, {
    networkMode: 'always',
    onSuccess: (_data, {
      entry
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.addUserInstruction.successNotification', {
        defaultMessage: 'User instruction saved'
      }));
      queryClient.invalidateQueries({
        queryKey: [_constants.REACT_QUERY_KEYS.GET_KB_USER_INSTRUCTIONS],
        refetchType: 'all'
      });
    },
    onError: (error, {
      entry
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.addUserInstruction.errorNotification', {
          defaultMessage: 'Something went wrong while creating {name}',
          values: {
            name: entry.id
          }
        })
      });
    }
  });
}