"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavControlScreenContext = useNavControlScreenContext;
var _react = require("react");
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _aiAssistant = require("@kbn/ai-assistant");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useNavControlScreenContext() {
  const service = (0, _aiAssistant.useAIAssistantAppService)();
  const {
    services: {
      plugins: {
        start: {
          data
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    from,
    to
  } = data.query.timefilter.timefilter.getTime();
  const [href, setHref] = (0, _react.useState)(window.location.href);
  (0, _react.useEffect)(() => {
    const originalPushState = window.history.pushState.bind(window.history);
    const originalReplaceState = window.history.replaceState.bind(window.history);
    let unmounted = false;
    function updateHref() {
      if (!unmounted) {
        setHref(window.location.href);
      }
    }
    window.history.pushState = (...args) => {
      originalPushState(...args);
      updateHref();
    };
    window.history.replaceState = (...args) => {
      originalReplaceState(...args);
      updateHref();
    };
    window.addEventListener('popstate', updateHref);
    window.addEventListener('hashchange', updateHref);
    return () => {
      unmounted = true;
      window.removeEventListener('popstate', updateHref);
      window.removeEventListener('hashchange', updateHref);
    };
  }, []);
  (0, _react.useEffect)(() => {
    var _datemath$parse$toISO, _datemath$parse, _datemath$parse$toISO2, _datemath$parse2;
    const start = (_datemath$parse$toISO = (_datemath$parse = _datemath.default.parse(from)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.toISOString()) !== null && _datemath$parse$toISO !== void 0 ? _datemath$parse$toISO : (0, _moment.default)().subtract(1, 'day').toISOString();
    const end = (_datemath$parse$toISO2 = (_datemath$parse2 = _datemath.default.parse(to)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.toISOString()) !== null && _datemath$parse$toISO2 !== void 0 ? _datemath$parse$toISO2 : (0, _moment.default)().toISOString();
    return service.setScreenContext({
      screenDescription: `The user is looking at ${href}. The current time range is ${start} - ${end}.`
    });
  }, [service, from, to, href]);
}