"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatBytesUsage = formatBytesUsage;
exports.formatMetric = formatMetric;
exports.formatNumber = formatNumber;
exports.formatPercentageUsage = formatPercentageUsage;
var _moment = _interopRequireDefault(require("moment"));
require("moment-duration-format");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatBytesUsage(used, max) {
  return formatNumber(used, 'byte') + ' / ' + formatNumber(max, 'byte');
}
function formatPercentageUsage(used, max) {
  return formatNumber(used / max, '0.00%');
}
function formatNumber(num, which) {
  const isNan = Number.isNaN(num);
  let format = '0,0.0';
  if (typeof num !== 'number' || isNan) {
    if (num !== undefined && !isNan) {
      return num; // strings such as 'N/A' stay untouched
    }
    num = 0;
    format = '0'; // NaN/undefined becomes '0' not '0.0'
  }
  let postfix = '';
  switch (which) {
    case 'time_since':
      return (0, _moment.default)((0, _moment.default)() - num).from((0, _moment.default)(), true);
    case 'time':
      return (0, _moment.default)(num).format('H:mm:ss');
    case 'int_commas':
      format = '0,0';
      break;
    case 'byte':
    case 'bytes':
      format += ' b';
      break;
    case 'ms':
      postfix = 'ms';
      break;
    default:
      if (which) {
        format = which;
      }
  }
  return (0, _numeral.default)(num).format(format) + postfix;
}
function formatMetric(value, format, suffix, options = {}) {
  const {
    prependSpace = true
  } = options;
  if (Boolean(value) || value === 0) {
    let _suffix = '';
    if (suffix !== undefined) {
      if (prependSpace) {
        _suffix = ` ${suffix}`;
      } else {
        _suffix = suffix;
      }
    }
    return formatNumber(value, format) + _suffix;
  }
  return _i18n.i18n.translate('xpack.monitoring.formatNumbers.notAvailableLabel', {
    defaultMessage: 'N/A'
  });
}