"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableStorageSetter = exports.tableStorageGetter = exports.euiTableStorageSetter = exports.euiTableStorageGetter = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tableStorageGetter = keyPrefix => {
  return storage => {
    const localStorageData = storage.get(_constants.STORAGE_KEY) || {};
    const filterText = (0, _lodash.get)(localStorageData, [keyPrefix, 'filterText']);
    const pageIndex = (0, _lodash.get)(localStorageData, [keyPrefix, 'pageIndex']);
    const sortKey = (0, _lodash.get)(localStorageData, [keyPrefix, 'sortKey']);
    const sortOrder = (0, _lodash.get)(localStorageData, [keyPrefix, 'sortOrder']);
    return {
      pageIndex,
      filterText,
      sortKey,
      sortOrder
    };
  };
};
exports.tableStorageGetter = tableStorageGetter;
const tableStorageSetter = keyPrefix => {
  return (storage, {
    filterText,
    pageIndex,
    sortKey,
    sortOrder
  }) => {
    const localStorageData = storage.get(_constants.STORAGE_KEY) || {};
    (0, _saferLodashSet.set)(localStorageData, [keyPrefix, 'filterText'], filterText || undefined); // don`t store empty data
    (0, _saferLodashSet.set)(localStorageData, [keyPrefix, 'pageIndex'], pageIndex || undefined);
    (0, _saferLodashSet.set)(localStorageData, [keyPrefix, 'sortKey'], sortKey || undefined);
    (0, _saferLodashSet.set)(localStorageData, [keyPrefix, 'sortOrder'], sortOrder || undefined);
    storage.set(_constants.STORAGE_KEY, localStorageData);
    return localStorageData;
  };
};
exports.tableStorageSetter = tableStorageSetter;
const euiTableStorageGetter = keyPrefix => {
  return storage => {
    const localStorageData = storage.get(_constants.STORAGE_KEY) || {};
    const sort = (0, _lodash.get)(localStorageData, [keyPrefix, 'sort']);
    const page = (0, _lodash.get)(localStorageData, [keyPrefix, 'page']);
    return {
      page,
      sort
    };
  };
};
exports.euiTableStorageGetter = euiTableStorageGetter;
const euiTableStorageSetter = keyPrefix => {
  return (storage, {
    sort,
    page
  }) => {
    const localStorageData = storage.get(_constants.STORAGE_KEY) || {};
    (0, _saferLodashSet.set)(localStorageData, [keyPrefix, 'sort'], sort || undefined); // don`t store empty data
    (0, _saferLodashSet.set)(localStorageData, [keyPrefix, 'page'], page || undefined);
    storage.set(_constants.STORAGE_KEY, localStorageData);
    return localStorageData;
  };
};
exports.euiTableStorageSetter = euiTableStorageSetter;