"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.edgeFactory = edgeFactory;
var _edge = require("./edge");
var _boolean_edge = require("./boolean_edge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function edgeFactory(graph, edgeJson) {
  const type = edgeJson.type;
  switch (type) {
    case 'plain':
      return new _edge.Edge(graph, edgeJson);
    case 'boolean':
      return new _boolean_edge.BooleanEdge(graph, edgeJson);
    default:
      throw new Error(`Unknown edge type ${type}! This shouldn't happen!`);
  }
}