"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestActive = LatestActive;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/beats/overview/latest_active.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LatestActive({
  latestActive
}) {
  const rangeMap = {
    last1m: _i18n.i18n.translate('xpack.monitoring.beats.overview.latestActive.last1MinuteLabel', {
      defaultMessage: 'Last 1 minute'
    }),
    last5m: _i18n.i18n.translate('xpack.monitoring.beats.overview.latestActive.last5MinutesLabel', {
      defaultMessage: 'Last 5 minutes'
    }),
    last20m: _i18n.i18n.translate('xpack.monitoring.beats.overview.latestActive.last20MinutesLabel', {
      defaultMessage: 'Last 20 minutes'
    }),
    last1h: _i18n.i18n.translate('xpack.monitoring.beats.overview.latestActive.last1HourLabel', {
      defaultMessage: 'Last 1 hour'
    }),
    last1d: _i18n.i18n.translate('xpack.monitoring.beats.overview.latestActive.last1DayLabel', {
      defaultMessage: 'Last 1 day'
    })
  };
  const activity = latestActive.map(({
    range,
    count
  }) => ({
    range: rangeMap[range],
    count
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: activity,
    columns: [{
      field: 'range',
      name: ''
    }, {
      field: 'count',
      dataType: 'number',
      name: ''
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
}
LatestActive.propTypes = {
  latestActive: _propTypes.default.arrayOf(_propTypes.default.shape({
    range: _propTypes.default.string.isRequired,
    count: _propTypes.default.number.isRequired
  })).isRequired
};