"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogstashTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _page_template = require("../page_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/logstash/logstash_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LogstashTemplate = ({
  cluster,
  instance,
  pipelineId,
  pipelineVersions,
  tabsDisabled,
  ...props
}) => {
  const tabs = [];
  if (!tabsDisabled) {
    if (!instance && !pipelineId) {
      tabs.push({
        id: 'overview',
        label: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.overviewLinkText', {
          defaultMessage: 'Overview'
        }),
        route: '/logstash'
      });
      tabs.push({
        id: 'nodes',
        label: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.nodesLinkText', {
          defaultMessage: 'Nodes'
        }),
        route: '/logstash/nodes'
      });
      tabs.push({
        id: 'pipelines',
        label: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.pipelinesLinkText', {
          defaultMessage: 'Pipelines'
        }),
        route: '/logstash/pipelines'
      });
    } else if (instance) {
      var _instance$nodeSummary, _instance$nodeSummary2, _instance$nodeSummary3;
      tabs.push({
        id: 'overview',
        label: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.instance.overviewLinkText', {
          defaultMessage: 'Overview'
        }),
        route: `/logstash/node/${(_instance$nodeSummary = instance.nodeSummary) === null || _instance$nodeSummary === void 0 ? void 0 : _instance$nodeSummary.uuid}`
      });
      tabs.push({
        id: 'pipeline',
        label: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.instance.pipelinesLinkText', {
          defaultMessage: 'Pipelines'
        }),
        route: `/logstash/node/${(_instance$nodeSummary2 = instance.nodeSummary) === null || _instance$nodeSummary2 === void 0 ? void 0 : _instance$nodeSummary2.uuid}/pipelines`,
        testSubj: 'logstashNodeDetailPipelinesLink'
      });
      tabs.push({
        id: 'advanced',
        label: _i18n.i18n.translate('xpack.monitoring.logstashNavigation.instance.advancedLinkText', {
          defaultMessage: 'Advanced'
        }),
        route: `/logstash/node/${(_instance$nodeSummary3 = instance.nodeSummary) === null || _instance$nodeSummary3 === void 0 ? void 0 : _instance$nodeSummary3.uuid}/advanced`,
        testSubj: 'logstashNodeDetailAdvancedLink'
      });
    }
  }
  if (pipelineVersions && pipelineVersions.length) {
    // todo add this in: https://github.com/elastic/kibana/blob/4584a8b570402aa07832cf3e5b520e5d2cfa7166/x-pack/plugins/monitoring/public/directives/main/index.js#L36, https://github.com/elastic/kibana/blob/c07a512e4647a40d8e891eb24f5912783b561fba/x-pack/plugins/monitoring/public/directives/main/index.html#L293-L298
    // tabs.push({
    //   id: 'dropdown-elm',
    // })
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, props, {
    tabs: tabs,
    product: "logstash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 10
    }
  }));
};
exports.LogstashTemplate = LogstashTemplate;