"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validate(opts) {
  const validationResult = {
    errors: {}
  };
  const errors = {
    duration: [],
    limit: []
  };
  if (!opts.duration) {
    errors.duration.push(_i18n.i18n.translate('xpack.monitoring.alerts.missingData.validation.duration', {
      defaultMessage: 'A valid duration is required.'
    }));
  }
  if (!opts.limit) {
    errors.limit.push(_i18n.i18n.translate('xpack.monitoring.alerts.missingData.validation.limit', {
      defaultMessage: 'A valid limit is required.'
    }));
  }
  validationResult.errors = errors;
  return validationResult;
}