"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "YAML_LANG_ID", {
  enumerable: true,
  get: function () {
    return _constants.ID;
  }
});
exports.configureMonacoYamlSchema = exports.YamlLang = void 0;
var _monaco_imports = require("../../monaco_imports");
var _language = require("./language");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const YamlLang = exports.YamlLang = {
  ID: _constants.ID,
  languageConfiguration: _language.languageConfiguration,
  lexerRules: _language.lexerRules
};
const monacoYamlDefaultOptions = {
  completion: true,
  hover: true,
  validate: true
};
const configureMonacoYamlSchema = async (schemas, options) => {
  const {
    configureMonacoYaml
  } = await Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "monaco-yaml" */'monaco-yaml')));
  const finalOptions = {
    ...monacoYamlDefaultOptions,
    ...(options || {}),
    schemas
  };
  return configureMonacoYaml(_monaco_imports.monaco, finalOptions);
};
exports.configureMonacoYamlSchema = configureMonacoYamlSchema;