"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFunctionTokens = addFunctionTokens;
exports.mergeTokens = mergeTokens;
var _constants = require("./constants");
var _esql_token = require("./esql_token");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function nonNullable(value) {
  return value != null;
}
function addFunctionTokens(tokens) {
  // need to trim spaces as "abs (arg)" is still valid as function
  const myTokensWithoutSpaces = tokens.filter(({
    scopes
  }) => scopes !== 'expr_ws' + _constants.ESQL_TOKEN_POSTFIX);
  // find out all unquoted_identifiers index
  const possiblyFunctions = myTokensWithoutSpaces.map((t, i) => t.scopes === 'unquoted_identifier' + _constants.ESQL_TOKEN_POSTFIX ? i : undefined).filter(nonNullable);

  // then check if the token next is an opening bracket
  for (const index of possiblyFunctions) {
    var _myTokensWithoutSpace;
    if (((_myTokensWithoutSpace = myTokensWithoutSpaces[index + 1]) === null || _myTokensWithoutSpace === void 0 ? void 0 : _myTokensWithoutSpace.scopes) === 'lp' + _constants.ESQL_TOKEN_POSTFIX) {
      // set the custom "functions" token (only used in theming)
      myTokensWithoutSpaces[index].scopes = 'functions' + _constants.ESQL_TOKEN_POSTFIX;
    }
  }
  return [...tokens];
}
const mergeRules = [[['nulls', 'expr_ws', 'first'], 'nulls_order'], [['nulls', 'expr_ws', 'last'], 'nulls_order'], [['integer', 'unquoted_identifier'], 'timespan_literal'], [['integer_literal', 'expr_ws', 'unquoted_identifier'], 'timespan_literal']];
function mergeTokens(tokens) {
  for (const [scopes, newScope] of mergeRules) {
    let foundAnyMatches = false;
    do {
      foundAnyMatches = false;
      for (let i = 0; i < tokens.length; i++) {
        if (tokens[i].scopes === scopes[0] + _constants.ESQL_TOKEN_POSTFIX) {
          // first matched so look ahead if there's room
          if (i + scopes.length > tokens.length) {
            continue;
          }
          let match = true;
          for (let j = 1; j < scopes.length; j++) {
            if (tokens[i + j].scopes !== scopes[j] + _constants.ESQL_TOKEN_POSTFIX) {
              match = false;
              break;
            }
          }
          if (match) {
            foundAnyMatches = true;
            const mergedToken = new _esql_token.ESQLToken(newScope, tokens[i].startIndex, tokens[i + scopes.length - 1].stopIndex);
            tokens.splice(i, scopes.length, mergedToken);
          }
        }
      }
    } while (foundAnyMatches);
  }
  return tokens;
}