"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMatchAllQuery = isMatchAllQuery;
exports.matchAllQuery = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents a query that matches all documents.
 */
const matchAllQuery = exports.matchAllQuery = {
  /**
   * 'match_all' property specifies a query that matches all documents.
   */
  match_all: {}
};

/**
 * Checks if an argument is a `match_all` query.
 * @param {unknown} query - Argument to check.
 * @returns {boolean} True if `query` is a `match_all` query, false otherwise.
 */
function isMatchAllQuery(query) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(query, ['match_all']) && typeof query.match_all === 'object' && query.match_all !== null && Object.keys(query.match_all).length === 0;
}