/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.ml_bundle_jsonpfunction=self.ml_bundle_jsonpfunction||[]).push([[2096],{22096:e=>{e.exports=JSON.parse('{"type":"object","properties":{"allow_lazy_open":{"description":"Advanced configuration option. Specifies whether this job can open when there is insufficient machine learning node capacity for it to be immediately assigned to a node. By default, if a machine learning node with capacity to run the job cannot immediately be found, the open anomaly detection jobs API returns an error. However, this is also subject to the cluster-wide `xpack.ml.max_lazy_ml_nodes` setting. If this option is set to true, the open anomaly detection jobs API does not return an error and the job waits in the opening state until sufficient machine learning node capacity is available.","type":"boolean"},"analysis_config":{"$ref":"#/components/schemas/ml._types:AnalysisConfig"},"analysis_limits":{"$ref":"#/components/schemas/ml._types:AnalysisLimits"},"background_persist_interval":{"$ref":"#/components/schemas/_types:Duration"},"custom_settings":{"$ref":"#/components/schemas/ml._types:CustomSettings"},"daily_model_snapshot_retention_after_days":{"description":"Advanced configuration option, which affects the automatic removal of old model snapshots for this job. It specifies a period of time (in days) after which only the first snapshot per day is retained. This period is relative to the timestamp of the most recent snapshot for this job. Valid values range from 0 to `model_snapshot_retention_days`.","type":"number"},"data_description":{"$ref":"#/components/schemas/ml._types:DataDescription"},"datafeed_config":{"$ref":"#/components/schemas/ml._types:DatafeedConfig"},"description":{"description":"A description of the job.","type":"string"},"job_id":{"type":"string","description":"Identifier for the anomaly detection job."},"groups":{"description":"A list of job groups. A job can belong to no groups or many.","type":"array","items":{"type":"string"}},"model_plot_config":{"$ref":"#/components/schemas/ml._types:ModelPlotConfig"},"model_snapshot_retention_days":{"description":"Advanced configuration option, which affects the automatic removal of old model snapshots for this job. It specifies the maximum period of time (in days) that snapshots are retained. This period is relative to the timestamp of the most recent snapshot for this job. By default, snapshots ten days older than the newest snapshot are deleted.","type":"number"},"renormalization_window_days":{"description":"Advanced configuration option. The period over which adjustments to the score are applied, as new data is seen. The default value is the longer of 30 days or 100 bucket spans.","type":"number"},"results_index_name":{"$ref":"#/components/schemas/_types:IndexName"},"results_retention_days":{"description":"Advanced configuration option. The period of time (in days) that results are retained. Age is calculated relative to the timestamp of the latest bucket result. If this property has a non-null value, once per day at 00:30 (server time), results that are the specified number of days older than the latest bucket result are deleted from Elasticsearch. The default value is null, which means all results are retained. Annotations generated by the system also count as results for retention purposes; they are deleted after the same number of days as results. Annotations added by users are retained forever.","type":"number"}},"required":["analysis_config","data_description"],"components":{"schemas":{"ml._types:AnalysisConfig":{"type":"object","properties":{"bucket_span":{"$ref":"#/components/schemas/_types:Duration"},"categorization_analyzer":{"$ref":"#/components/schemas/ml._types:CategorizationAnalyzer"},"categorization_field_name":{"$ref":"#/components/schemas/_types:Field"},"categorization_filters":{"description":"If `categorization_field_name` is specified, you can also define optional filters. This property expects an array of regular expressions. The expressions are used to filter out matching sequences from the categorization field values. You can use this functionality to fine tune the categorization by excluding sequences from consideration when categories are defined. For example, you can exclude SQL statements that appear in your log files. This property cannot be used at the same time as `categorization_analyzer`. If you only want to define simple regular expression filters that are applied prior to tokenization, setting this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering, use the `categorization_analyzer` property instead and include the filters as pattern_replace character filters. The effect is exactly the same.","type":"array","items":{"type":"string"}},"detectors":{"description":"Detector configuration objects specify which data fields a job analyzes. They also specify which analytical functions are used. You can specify multiple detectors for a job. If the detectors array does not contain at least one detector, no analysis can occur and an error is returned.","type":"array","items":{"$ref":"#/components/schemas/ml._types:Detector"}},"influencers":{"description":"A comma separated list of influencer field names. Typically these can be the by, over, or partition fields that are used in the detector configuration. You might also want to use a field name that is not specifically named in a detector, but is available as part of the input data. When you use multiple detectors, the use of influencers is recommended as it aggregates results for each influencer entity.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"latency":{"$ref":"#/components/schemas/_types:Duration"},"model_prune_window":{"$ref":"#/components/schemas/_types:Duration"},"multivariate_by_fields":{"description":"This functionality is reserved for internal use. It is not supported for use in customer environments and is not subject to the support SLA of official GA features. If set to `true`, the analysis will automatically find correlations between metrics for a given by field value and report anomalies when those correlations cease to hold. For example, suppose CPU and memory usage on host A is usually highly correlated with the same metrics on host B. Perhaps this correlation occurs because they are running a load-balanced application. If you enable this property, anomalies will be reported when, for example, CPU usage on host A is high and the value of CPU usage on host B is low. That is to say, you’ll see an anomaly when the CPU of host A is unusual given the CPU of host B. To use the `multivariate_by_fields` property, you must also specify `by_field_name` in your detector.","type":"boolean"},"per_partition_categorization":{"$ref":"#/components/schemas/ml._types:PerPartitionCategorization"},"summary_count_field_name":{"$ref":"#/components/schemas/_types:Field"}},"required":["detectors"]},"_types:Duration":{"description":"A duration. Units can be `nanos`, `micros`, `ms` (milliseconds), `s` (seconds), `m` (minutes), `h` (hours) and\\n`d` (days). Also accepts \\"0\\" without a unit and \\"-1\\" to indicate an unspecified value.","oneOf":[{"type":"string"},{"type":"string","enum":["-1"]},{"type":"string","enum":["0"]}]},"ml._types:CategorizationAnalyzer":{"oneOf":[{"type":"string"},{"$ref":"#/components/schemas/ml._types:CategorizationAnalyzerDefinition"}]},"ml._types:CategorizationAnalyzerDefinition":{"type":"object","properties":{"char_filter":{"description":"One or more character filters. In addition to the built-in character filters, other plugins can provide more character filters. If this property is not specified, no character filters are applied prior to categorization. If you are customizing some other aspect of the analyzer and you need to achieve the equivalent of `categorization_filters` (which are not permitted when some other aspect of the analyzer is customized), add them here as pattern replace character filters.","type":"array","items":{"$ref":"#/components/schemas/_types.analysis:CharFilter"}},"filter":{"description":"One or more token filters. In addition to the built-in token filters, other plugins can provide more token filters. If this property is not specified, no token filters are applied prior to categorization.","type":"array","items":{"$ref":"#/components/schemas/_types.analysis:TokenFilter"}},"tokenizer":{"$ref":"#/components/schemas/_types.analysis:Tokenizer"}}},"_types.analysis:CharFilter":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-charfilters.html"},"oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types.analysis:CharFilterDefinition"}]},"_types.analysis:CharFilterDefinition":{"discriminator":{"propertyName":"type"},"oneOf":[{"$ref":"#/components/schemas/_types.analysis:HtmlStripCharFilter"},{"$ref":"#/components/schemas/_types.analysis:MappingCharFilter"},{"$ref":"#/components/schemas/_types.analysis:PatternReplaceCharFilter"},{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationCharFilter"},{"$ref":"#/components/schemas/_types.analysis:KuromojiIterationMarkCharFilter"}]},"_types.analysis:HtmlStripCharFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CharFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["html_strip"]},"escaped_tags":{"type":"array","items":{"type":"string"}}},"required":["type"]}]},"_types.analysis:CharFilterBase":{"type":"object","properties":{"version":{"$ref":"#/components/schemas/_types:VersionString"}}},"_types:VersionString":{"type":"string"},"_types.analysis:MappingCharFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CharFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["mapping"]},"mappings":{"type":"array","items":{"type":"string"}},"mappings_path":{"type":"string"}},"required":["type"]}]},"_types.analysis:PatternReplaceCharFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CharFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["pattern_replace"]},"flags":{"type":"string"},"pattern":{"type":"string"},"replacement":{"type":"string"}},"required":["type","pattern"]}]},"_types.analysis:IcuNormalizationCharFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CharFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["icu_normalizer"]},"mode":{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationMode"},"name":{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationType"}},"required":["type"]}]},"_types.analysis:IcuNormalizationMode":{"type":"string","enum":["decompose","compose"]},"_types.analysis:IcuNormalizationType":{"type":"string","enum":["nfc","nfkc","nfkc_cf"]},"_types.analysis:KuromojiIterationMarkCharFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CharFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["kuromoji_iteration_mark"]},"normalize_kana":{"type":"boolean"},"normalize_kanji":{"type":"boolean"}},"required":["type","normalize_kana","normalize_kanji"]}]},"_types.analysis:TokenFilter":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-tokenfilters.html"},"oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types.analysis:TokenFilterDefinition"}]},"_types.analysis:TokenFilterDefinition":{"discriminator":{"propertyName":"type"},"oneOf":[{"$ref":"#/components/schemas/_types.analysis:AsciiFoldingTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:CommonGramsTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:ConditionTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:DelimitedPayloadTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:EdgeNGramTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:ElisionTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:FingerprintTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:HunspellTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:HyphenationDecompounderTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KeepTypesTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KeepWordsTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KeywordMarkerTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KStemTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:LengthTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:LimitTokenCountTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:LowercaseTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:MultiplexerTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:NGramTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:NoriPartOfSpeechTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:PatternCaptureTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:PatternReplaceTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:PorterStemTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:PredicateTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:RemoveDuplicatesTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:ReverseTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:ShingleTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:SnowballTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:StemmerOverrideTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:StemmerTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:StopTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:SynonymGraphTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:SynonymTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:TrimTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:TruncateTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:UniqueTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:UppercaseTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:WordDelimiterGraphTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:WordDelimiterTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KuromojiStemmerTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KuromojiReadingFormTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:KuromojiPartOfSpeechTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:IcuCollationTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:IcuFoldingTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:IcuTransformTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:PhoneticTokenFilter"},{"$ref":"#/components/schemas/_types.analysis:DictionaryDecompounderTokenFilter"}]},"_types.analysis:AsciiFoldingTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["asciifolding"]},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"}},"required":["type"]}]},"_types.analysis:TokenFilterBase":{"type":"object","properties":{"version":{"$ref":"#/components/schemas/_types:VersionString"}}},"_spec_utils:Stringifiedboolean":{"description":"Some APIs will return values such as numbers also as a string (notably epoch timestamps). This behavior\\nis used to capture this behavior while keeping the semantics of the field type.\\n\\nDepending on the target language, code generators can keep the union or remove it and leniently parse\\nstrings to the target type.","oneOf":[{"type":"boolean"},{"type":"string"}]},"_types.analysis:CommonGramsTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["common_grams"]},"common_words":{"type":"array","items":{"type":"string"}},"common_words_path":{"type":"string"},"ignore_case":{"type":"boolean"},"query_mode":{"type":"boolean"}},"required":["type"]}]},"_types.analysis:ConditionTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["condition"]},"filter":{"type":"array","items":{"type":"string"}},"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["type","filter","script"]}]},"_types:Script":{"type":"object","properties":{"source":{"description":"The script source.","type":"string"},"id":{"$ref":"#/components/schemas/_types:Id"},"params":{"description":"Specifies any named parameters that are passed into the script as variables.\\nUse parameters instead of hard-coded values to decrease compile time.","type":"object","additionalProperties":{"type":"object"}},"lang":{"$ref":"#/components/schemas/_types:ScriptLanguage"},"options":{"type":"object","additionalProperties":{"type":"string"}}}},"_types:Id":{"type":"string"},"_types:ScriptLanguage":{"anyOf":[{"type":"string","enum":["painless","expression","mustache","java"]},{"type":"string"}]},"_types.analysis:DelimitedPayloadTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["delimited_payload"]},"delimiter":{"type":"string"},"encoding":{"$ref":"#/components/schemas/_types.analysis:DelimitedPayloadEncoding"}},"required":["type"]}]},"_types.analysis:DelimitedPayloadEncoding":{"type":"string","enum":["int","float","identity"]},"_types.analysis:EdgeNGramTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["edge_ngram"]},"max_gram":{"type":"number"},"min_gram":{"type":"number"},"side":{"$ref":"#/components/schemas/_types.analysis:EdgeNGramSide"},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"}},"required":["type"]}]},"_types.analysis:EdgeNGramSide":{"type":"string","enum":["front","back"]},"_types.analysis:ElisionTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["elision"]},"articles":{"type":"array","items":{"type":"string"}},"articles_path":{"type":"string"},"articles_case":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"}},"required":["type"]}]},"_types.analysis:FingerprintTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["fingerprint"]},"max_output_size":{"type":"number"},"separator":{"type":"string"}},"required":["type"]}]},"_types.analysis:HunspellTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["hunspell"]},"dedup":{"type":"boolean"},"dictionary":{"type":"string"},"locale":{"type":"string"},"longest_only":{"type":"boolean"}},"required":["type","locale"]}]},"_types.analysis:HyphenationDecompounderTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CompoundWordTokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["hyphenation_decompounder"]}},"required":["type"]}]},"_types.analysis:CompoundWordTokenFilterBase":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"hyphenation_patterns_path":{"type":"string"},"max_subword_size":{"type":"number"},"min_subword_size":{"type":"number"},"min_word_size":{"type":"number"},"only_longest_match":{"type":"boolean"},"word_list":{"type":"array","items":{"type":"string"}},"word_list_path":{"type":"string"}}}]},"_types.analysis:KeepTypesTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["keep_types"]},"mode":{"$ref":"#/components/schemas/_types.analysis:KeepTypesMode"},"types":{"type":"array","items":{"type":"string"}}},"required":["type"]}]},"_types.analysis:KeepTypesMode":{"type":"string","enum":["include","exclude"]},"_types.analysis:KeepWordsTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["keep"]},"keep_words":{"type":"array","items":{"type":"string"}},"keep_words_case":{"type":"boolean"},"keep_words_path":{"type":"string"}},"required":["type"]}]},"_types.analysis:KeywordMarkerTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["keyword_marker"]},"ignore_case":{"type":"boolean"},"keywords":{"oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},"keywords_path":{"type":"string"},"keywords_pattern":{"type":"string"}},"required":["type"]}]},"_types.analysis:KStemTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["kstem"]}},"required":["type"]}]},"_types.analysis:LengthTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["length"]},"max":{"type":"number"},"min":{"type":"number"}},"required":["type"]}]},"_types.analysis:LimitTokenCountTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["limit"]},"consume_all_tokens":{"type":"boolean"},"max_token_count":{"$ref":"#/components/schemas/_spec_utils:Stringifiedinteger"}},"required":["type"]}]},"_spec_utils:Stringifiedinteger":{"description":"Some APIs will return values such as numbers also as a string (notably epoch timestamps). This behavior\\nis used to capture this behavior while keeping the semantics of the field type.\\n\\nDepending on the target language, code generators can keep the union or remove it and leniently parse\\nstrings to the target type.","oneOf":[{"type":"number"},{"type":"string"}]},"_types.analysis:LowercaseTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["lowercase"]},"language":{"type":"string"}},"required":["type"]}]},"_types.analysis:MultiplexerTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["multiplexer"]},"filters":{"type":"array","items":{"type":"string"}},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"}},"required":["type","filters"]}]},"_types.analysis:NGramTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["ngram"]},"max_gram":{"type":"number"},"min_gram":{"type":"number"},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"}},"required":["type"]}]},"_types.analysis:NoriPartOfSpeechTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["nori_part_of_speech"]},"stoptags":{"type":"array","items":{"type":"string"}}},"required":["type"]}]},"_types.analysis:PatternCaptureTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["pattern_capture"]},"patterns":{"type":"array","items":{"type":"string"}},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"}},"required":["type","patterns"]}]},"_types.analysis:PatternReplaceTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["pattern_replace"]},"all":{"type":"boolean"},"flags":{"type":"string"},"pattern":{"type":"string"},"replacement":{"type":"string"}},"required":["type","pattern"]}]},"_types.analysis:PorterStemTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["porter_stem"]}},"required":["type"]}]},"_types.analysis:PredicateTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["predicate_token_filter"]},"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["type","script"]}]},"_types.analysis:RemoveDuplicatesTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["remove_duplicates"]}},"required":["type"]}]},"_types.analysis:ReverseTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["reverse"]}},"required":["type"]}]},"_types.analysis:ShingleTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["shingle"]},"filler_token":{"type":"string"},"max_shingle_size":{"oneOf":[{"type":"number"},{"type":"string"}]},"min_shingle_size":{"oneOf":[{"type":"number"},{"type":"string"}]},"output_unigrams":{"type":"boolean"},"output_unigrams_if_no_shingles":{"type":"boolean"},"token_separator":{"type":"string"}},"required":["type"]}]},"_types.analysis:SnowballTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["snowball"]},"language":{"$ref":"#/components/schemas/_types.analysis:SnowballLanguage"}},"required":["type"]}]},"_types.analysis:SnowballLanguage":{"type":"string","enum":["Armenian","Basque","Catalan","Danish","Dutch","English","Finnish","French","German","German2","Hungarian","Italian","Kp","Lovins","Norwegian","Porter","Portuguese","Romanian","Russian","Spanish","Swedish","Turkish"]},"_types.analysis:StemmerOverrideTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["stemmer_override"]},"rules":{"type":"array","items":{"type":"string"}},"rules_path":{"type":"string"}},"required":["type"]}]},"_types.analysis:StemmerTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["stemmer"]},"language":{"type":"string"}},"required":["type"]}]},"_types.analysis:StopTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["stop"]},"ignore_case":{"type":"boolean"},"remove_trailing":{"type":"boolean"},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"},"stopwords_path":{"type":"string"}},"required":["type"]}]},"_types.analysis:StopWords":{"description":"Language value, such as _arabic_ or _thai_. Defaults to _english_.\\nEach language value corresponds to a predefined list of stop words in Lucene. See Stop words by language for supported language values and their stop words.\\nAlso accepts an array of stop words.","oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},"_types.analysis:SynonymGraphTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["synonym_graph"]},"expand":{"type":"boolean"},"format":{"$ref":"#/components/schemas/_types.analysis:SynonymFormat"},"lenient":{"type":"boolean"},"synonyms":{"type":"array","items":{"type":"string"}},"synonyms_path":{"type":"string"},"synonyms_set":{"type":"string"},"tokenizer":{"type":"string"},"updateable":{"type":"boolean"}},"required":["type"]}]},"_types.analysis:SynonymFormat":{"type":"string","enum":["solr","wordnet"]},"_types.analysis:SynonymTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["synonym"]},"expand":{"type":"boolean"},"format":{"$ref":"#/components/schemas/_types.analysis:SynonymFormat"},"lenient":{"type":"boolean"},"synonyms":{"type":"array","items":{"type":"string"}},"synonyms_path":{"type":"string"},"synonyms_set":{"type":"string"},"tokenizer":{"type":"string"},"updateable":{"type":"boolean"}},"required":["type"]}]},"_types.analysis:TrimTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["trim"]}},"required":["type"]}]},"_types.analysis:TruncateTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["truncate"]},"length":{"type":"number"}},"required":["type"]}]},"_types.analysis:UniqueTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["unique"]},"only_on_same_position":{"type":"boolean"}},"required":["type"]}]},"_types.analysis:UppercaseTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["uppercase"]}},"required":["type"]}]},"_types.analysis:WordDelimiterGraphTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["word_delimiter_graph"]},"adjust_offsets":{"type":"boolean"},"catenate_all":{"type":"boolean"},"catenate_numbers":{"type":"boolean"},"catenate_words":{"type":"boolean"},"generate_number_parts":{"type":"boolean"},"generate_word_parts":{"type":"boolean"},"ignore_keywords":{"type":"boolean"},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"},"protected_words":{"type":"array","items":{"type":"string"}},"protected_words_path":{"type":"string"},"split_on_case_change":{"type":"boolean"},"split_on_numerics":{"type":"boolean"},"stem_english_possessive":{"type":"boolean"},"type_table":{"type":"array","items":{"type":"string"}},"type_table_path":{"type":"string"}},"required":["type"]}]},"_types.analysis:WordDelimiterTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["word_delimiter"]},"catenate_all":{"type":"boolean"},"catenate_numbers":{"type":"boolean"},"catenate_words":{"type":"boolean"},"generate_number_parts":{"type":"boolean"},"generate_word_parts":{"type":"boolean"},"preserve_original":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"},"protected_words":{"type":"array","items":{"type":"string"}},"protected_words_path":{"type":"string"},"split_on_case_change":{"type":"boolean"},"split_on_numerics":{"type":"boolean"},"stem_english_possessive":{"type":"boolean"},"type_table":{"type":"array","items":{"type":"string"}},"type_table_path":{"type":"string"}},"required":["type"]}]},"_types.analysis:KuromojiStemmerTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["kuromoji_stemmer"]},"minimum_length":{"type":"number"}},"required":["type","minimum_length"]}]},"_types.analysis:KuromojiReadingFormTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["kuromoji_readingform"]},"use_romaji":{"type":"boolean"}},"required":["type","use_romaji"]}]},"_types.analysis:KuromojiPartOfSpeechTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["kuromoji_part_of_speech"]},"stoptags":{"type":"array","items":{"type":"string"}}},"required":["type","stoptags"]}]},"_types.analysis:IcuCollationTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["icu_collation"]},"alternate":{"$ref":"#/components/schemas/_types.analysis:IcuCollationAlternate"},"case_first":{"$ref":"#/components/schemas/_types.analysis:IcuCollationCaseFirst"},"case_level":{"type":"boolean"},"country":{"type":"string"},"decomposition":{"$ref":"#/components/schemas/_types.analysis:IcuCollationDecomposition"},"hiragana_quaternary_mode":{"type":"boolean"},"language":{"type":"string"},"numeric":{"type":"boolean"},"rules":{"type":"string"},"strength":{"$ref":"#/components/schemas/_types.analysis:IcuCollationStrength"},"variable_top":{"type":"string"},"variant":{"type":"string"}},"required":["type"]}]},"_types.analysis:IcuCollationAlternate":{"type":"string","enum":["shifted","non-ignorable"]},"_types.analysis:IcuCollationCaseFirst":{"type":"string","enum":["lower","upper"]},"_types.analysis:IcuCollationDecomposition":{"type":"string","enum":["no","identical"]},"_types.analysis:IcuCollationStrength":{"type":"string","enum":["primary","secondary","tertiary","quaternary","identical"]},"_types.analysis:IcuFoldingTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["icu_folding"]},"unicode_set_filter":{"type":"string"}},"required":["type","unicode_set_filter"]}]},"_types.analysis:IcuNormalizationTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["icu_normalizer"]},"name":{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationType"}},"required":["type","name"]}]},"_types.analysis:IcuTransformTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["icu_transform"]},"dir":{"$ref":"#/components/schemas/_types.analysis:IcuTransformDirection"},"id":{"type":"string"}},"required":["type","id"]}]},"_types.analysis:IcuTransformDirection":{"type":"string","enum":["forward","reverse"]},"_types.analysis:PhoneticTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["phonetic"]},"encoder":{"$ref":"#/components/schemas/_types.analysis:PhoneticEncoder"},"languageset":{"oneOf":[{"$ref":"#/components/schemas/_types.analysis:PhoneticLanguage"},{"type":"array","items":{"$ref":"#/components/schemas/_types.analysis:PhoneticLanguage"}}]},"max_code_len":{"type":"number"},"name_type":{"$ref":"#/components/schemas/_types.analysis:PhoneticNameType"},"replace":{"type":"boolean"},"rule_type":{"$ref":"#/components/schemas/_types.analysis:PhoneticRuleType"}},"required":["type","encoder"]}]},"_types.analysis:PhoneticEncoder":{"type":"string","enum":["metaphone","double_metaphone","soundex","refined_soundex","caverphone1","caverphone2","cologne","nysiis","koelnerphonetik","haasephonetik","beider_morse","daitch_mokotoff"]},"_types.analysis:PhoneticLanguage":{"type":"string","enum":["any","common","cyrillic","english","french","german","hebrew","hungarian","polish","romanian","russian","spanish"]},"_types.analysis:PhoneticNameType":{"type":"string","enum":["generic","ashkenazi","sephardic"]},"_types.analysis:PhoneticRuleType":{"type":"string","enum":["approx","exact"]},"_types.analysis:DictionaryDecompounderTokenFilter":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:CompoundWordTokenFilterBase"},{"type":"object","properties":{"type":{"type":"string","enum":["dictionary_decompounder"]}},"required":["type"]}]},"_types.analysis:Tokenizer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-tokenizers.html"},"oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types.analysis:TokenizerDefinition"}]},"_types.analysis:TokenizerDefinition":{"discriminator":{"propertyName":"type"},"oneOf":[{"$ref":"#/components/schemas/_types.analysis:CharGroupTokenizer"},{"$ref":"#/components/schemas/_types.analysis:ClassicTokenizer"},{"$ref":"#/components/schemas/_types.analysis:EdgeNGramTokenizer"},{"$ref":"#/components/schemas/_types.analysis:KeywordTokenizer"},{"$ref":"#/components/schemas/_types.analysis:LetterTokenizer"},{"$ref":"#/components/schemas/_types.analysis:LowercaseTokenizer"},{"$ref":"#/components/schemas/_types.analysis:NGramTokenizer"},{"$ref":"#/components/schemas/_types.analysis:PathHierarchyTokenizer"},{"$ref":"#/components/schemas/_types.analysis:PatternTokenizer"},{"$ref":"#/components/schemas/_types.analysis:SimplePatternTokenizer"},{"$ref":"#/components/schemas/_types.analysis:SimplePatternSplitTokenizer"},{"$ref":"#/components/schemas/_types.analysis:StandardTokenizer"},{"$ref":"#/components/schemas/_types.analysis:ThaiTokenizer"},{"$ref":"#/components/schemas/_types.analysis:UaxEmailUrlTokenizer"},{"$ref":"#/components/schemas/_types.analysis:WhitespaceTokenizer"},{"$ref":"#/components/schemas/_types.analysis:IcuTokenizer"},{"$ref":"#/components/schemas/_types.analysis:KuromojiTokenizer"},{"$ref":"#/components/schemas/_types.analysis:NoriTokenizer"}]},"_types.analysis:CharGroupTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["char_group"]},"tokenize_on_chars":{"type":"array","items":{"type":"string"}},"max_token_length":{"type":"number"}},"required":["type","tokenize_on_chars"]}]},"_types.analysis:TokenizerBase":{"type":"object","properties":{"version":{"$ref":"#/components/schemas/_types:VersionString"}}},"_types.analysis:ClassicTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["classic"]},"max_token_length":{"type":"number"}},"required":["type"]}]},"_types.analysis:EdgeNGramTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["edge_ngram"]},"custom_token_chars":{"type":"string"},"max_gram":{"type":"number"},"min_gram":{"type":"number"},"token_chars":{"type":"array","items":{"$ref":"#/components/schemas/_types.analysis:TokenChar"}}},"required":["type"]}]},"_types.analysis:TokenChar":{"type":"string","enum":["letter","digit","whitespace","punctuation","symbol","custom"]},"_types.analysis:KeywordTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["keyword"]},"buffer_size":{"type":"number"}},"required":["type"]}]},"_types.analysis:LetterTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["letter"]}},"required":["type"]}]},"_types.analysis:LowercaseTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["lowercase"]}},"required":["type"]}]},"_types.analysis:NGramTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["ngram"]},"custom_token_chars":{"type":"string"},"max_gram":{"type":"number"},"min_gram":{"type":"number"},"token_chars":{"type":"array","items":{"$ref":"#/components/schemas/_types.analysis:TokenChar"}}},"required":["type"]}]},"_types.analysis:PathHierarchyTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["path_hierarchy"]},"buffer_size":{"$ref":"#/components/schemas/_spec_utils:Stringifiedinteger"},"delimiter":{"type":"string"},"replacement":{"type":"string"},"reverse":{"$ref":"#/components/schemas/_spec_utils:Stringifiedboolean"},"skip":{"$ref":"#/components/schemas/_spec_utils:Stringifiedinteger"}},"required":["type"]}]},"_types.analysis:PatternTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["pattern"]},"flags":{"type":"string"},"group":{"type":"number"},"pattern":{"type":"string"}},"required":["type"]}]},"_types.analysis:SimplePatternTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["simple_pattern"]},"pattern":{"type":"string"}},"required":["type"]}]},"_types.analysis:SimplePatternSplitTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["simple_pattern_split"]},"pattern":{"type":"string"}},"required":["type"]}]},"_types.analysis:StandardTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["standard"]},"max_token_length":{"type":"number"}},"required":["type"]}]},"_types.analysis:ThaiTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["thai"]}},"required":["type"]}]},"_types.analysis:UaxEmailUrlTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["uax_url_email"]},"max_token_length":{"type":"number"}},"required":["type"]}]},"_types.analysis:WhitespaceTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["whitespace"]},"max_token_length":{"type":"number"}},"required":["type"]}]},"_types.analysis:IcuTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["icu_tokenizer"]},"rule_files":{"type":"string"}},"required":["type","rule_files"]}]},"_types.analysis:KuromojiTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["kuromoji_tokenizer"]},"discard_punctuation":{"type":"boolean"},"mode":{"$ref":"#/components/schemas/_types.analysis:KuromojiTokenizationMode"},"nbest_cost":{"type":"number"},"nbest_examples":{"type":"string"},"user_dictionary":{"type":"string"},"user_dictionary_rules":{"type":"array","items":{"type":"string"}},"discard_compound_token":{"type":"boolean"}},"required":["type","mode"]}]},"_types.analysis:KuromojiTokenizationMode":{"type":"string","enum":["normal","search","extended"]},"_types.analysis:NoriTokenizer":{"allOf":[{"$ref":"#/components/schemas/_types.analysis:TokenizerBase"},{"type":"object","properties":{"type":{"type":"string","enum":["nori_tokenizer"]},"decompound_mode":{"$ref":"#/components/schemas/_types.analysis:NoriDecompoundMode"},"discard_punctuation":{"type":"boolean"},"user_dictionary":{"type":"string"},"user_dictionary_rules":{"type":"array","items":{"type":"string"}}},"required":["type"]}]},"_types.analysis:NoriDecompoundMode":{"type":"string","enum":["discard","none","mixed"]},"_types:Field":{"description":"Path to field or array of paths. Some API\'s support wildcards in the path to select multiple fields.","type":"string"},"ml._types:Detector":{"type":"object","properties":{"by_field_name":{"$ref":"#/components/schemas/_types:Field"},"custom_rules":{"description":"Custom rules enable you to customize the way detectors operate. For example, a rule may dictate conditions under which results should be skipped. Kibana refers to custom rules as job rules.","type":"array","items":{"$ref":"#/components/schemas/ml._types:DetectionRule"}},"detector_description":{"description":"A description of the detector.","type":"string"},"detector_index":{"description":"A unique identifier for the detector. This identifier is based on the order of the detectors in the `analysis_config`, starting at zero. If you specify a value for this property, it is ignored.","type":"number"},"exclude_frequent":{"$ref":"#/components/schemas/ml._types:ExcludeFrequent"},"field_name":{"$ref":"#/components/schemas/_types:Field"},"function":{"description":"The analysis function that is used. For example, `count`, `rare`, `mean`, `min`, `max`, or `sum`.","type":"string"},"over_field_name":{"$ref":"#/components/schemas/_types:Field"},"partition_field_name":{"$ref":"#/components/schemas/_types:Field"},"use_null":{"description":"Defines whether a new series is used as the null series when there is no value for the by or partition fields.","type":"boolean"}}},"ml._types:DetectionRule":{"type":"object","properties":{"actions":{"description":"The set of actions to be triggered when the rule applies. If more than one action is specified the effects of all actions are combined.","type":"array","items":{"$ref":"#/components/schemas/ml._types:RuleAction"}},"conditions":{"description":"An array of numeric conditions when the rule applies. A rule must either have a non-empty scope or at least one condition. Multiple conditions are combined together with a logical AND.","type":"array","items":{"$ref":"#/components/schemas/ml._types:RuleCondition"}},"scope":{"description":"A scope of series where the rule applies. A rule must either have a non-empty scope or at least one condition. By default, the scope includes all series. Scoping is allowed for any of the fields that are also specified in `by_field_name`, `over_field_name`, or `partition_field_name`.","type":"object","additionalProperties":{"$ref":"#/components/schemas/ml._types:FilterRef"}}}},"ml._types:RuleAction":{"type":"string","enum":["skip_result","skip_model_update"]},"ml._types:RuleCondition":{"type":"object","properties":{"applies_to":{"$ref":"#/components/schemas/ml._types:AppliesTo"},"operator":{"$ref":"#/components/schemas/ml._types:ConditionOperator"},"value":{"description":"The value that is compared against the `applies_to` field using the operator.","type":"number"}},"required":["applies_to","operator","value"]},"ml._types:AppliesTo":{"type":"string","enum":["actual","typical","diff_from_typical","time"]},"ml._types:ConditionOperator":{"type":"string","enum":["gt","gte","lt","lte"]},"ml._types:FilterRef":{"type":"object","properties":{"filter_id":{"$ref":"#/components/schemas/_types:Id"},"filter_type":{"$ref":"#/components/schemas/ml._types:FilterType"}},"required":["filter_id"]},"ml._types:FilterType":{"type":"string","enum":["include","exclude"]},"ml._types:ExcludeFrequent":{"type":"string","enum":["all","none","by","over"]},"ml._types:PerPartitionCategorization":{"type":"object","properties":{"enabled":{"description":"To enable this setting, you must also set the `partition_field_name` property to the same value in every detector that uses the keyword `mlcategory`. Otherwise, job creation fails.","type":"boolean"},"stop_on_warn":{"description":"This setting can be set to true only if per-partition categorization is enabled. If true, both categorization and subsequent anomaly detection stops for partitions where the categorization status changes to warn. This setting makes it viable to have a job where it is expected that categorization works well for some partitions but not others; you do not pay the cost of bad categorization forever in the partitions where it works badly.","type":"boolean"}}},"ml._types:AnalysisLimits":{"type":"object","properties":{"categorization_examples_limit":{"description":"The maximum number of examples stored per category in memory and in the results data store. If you increase this value, more examples are available, however it requires that you have more storage available. If you set this value to 0, no examples are stored. NOTE: The `categorization_examples_limit` applies only to analysis that uses categorization.","type":"number"},"model_memory_limit":{"$ref":"#/components/schemas/_types:ByteSize"}}},"_types:ByteSize":{"oneOf":[{"type":"number"},{"type":"string"}]},"ml._types:CustomSettings":{"description":"Custom metadata about the job","type":"object"},"ml._types:DataDescription":{"type":"object","properties":{"format":{"description":"Only JSON format is supported at this time.","type":"string"},"time_field":{"$ref":"#/components/schemas/_types:Field"},"time_format":{"description":"The time format, which can be `epoch`, `epoch_ms`, or a custom pattern. The value `epoch` refers to UNIX or Epoch time (the number of seconds since 1 Jan 1970). The value `epoch_ms` indicates that time is measured in milliseconds since the epoch. The `epoch` and `epoch_ms` time formats accept either integer or real values. Custom patterns must conform to the Java DateTimeFormatter class. When you use date-time formatting patterns, it is recommended that you provide the full date, time and time zone. For example: `yyyy-MM-dd\'T\'HH:mm:ssX`. If the pattern that you specify is not sufficient to produce a complete timestamp, job creation fails.","type":"string"},"field_delimiter":{"type":"string"}}},"ml._types:DatafeedConfig":{"type":"object","properties":{"aggregations":{"description":"If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only with low cardinality data.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.aggregations:AggregationContainer"}},"chunking_config":{"$ref":"#/components/schemas/ml._types:ChunkingConfig"},"datafeed_id":{"$ref":"#/components/schemas/_types:Id"},"delayed_data_check_config":{"$ref":"#/components/schemas/ml._types:DelayedDataCheckConfig"},"frequency":{"$ref":"#/components/schemas/_types:Duration"},"indices":{"$ref":"#/components/schemas/_types:Indices"},"indices_options":{"$ref":"#/components/schemas/_types:IndicesOptions"},"job_id":{"$ref":"#/components/schemas/_types:Id"},"max_empty_searches":{"description":"If a real-time datafeed has never seen any data (including during any initial training period) then it will automatically stop itself and close its associated job after this many real-time searches that return no documents. In other words, it will stop after `frequency` times `max_empty_searches` of real-time operation. If not set then a datafeed with no end time that sees no data will remain started until it is explicitly stopped.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"query_delay":{"$ref":"#/components/schemas/_types:Duration"},"runtime_mappings":{"$ref":"#/components/schemas/_types.mapping:RuntimeFields"},"script_fields":{"description":"Specifies scripts that evaluate custom expressions and returns script fields to the datafeed. The detector configuration objects in a job can contain functions that use these script fields.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:ScriptField"}},"scroll_size":{"description":"The size parameter that is used in Elasticsearch searches when the datafeed does not use aggregations. The maximum value is the value of `index.max_result_window`, which is 10,000 by default.","type":"number"}}},"_types.aggregations:AggregationContainer":{"allOf":[{"type":"object","properties":{"aggregations":{"description":"Sub-aggregations for this aggregation.\\nOnly applies to bucket aggregations.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.aggregations:AggregationContainer"}},"meta":{"$ref":"#/components/schemas/_types:Metadata"}}},{"type":"object","properties":{"adjacency_matrix":{"$ref":"#/components/schemas/_types.aggregations:AdjacencyMatrixAggregation"},"auto_date_histogram":{"$ref":"#/components/schemas/_types.aggregations:AutoDateHistogramAggregation"},"avg":{"$ref":"#/components/schemas/_types.aggregations:AverageAggregation"},"avg_bucket":{"$ref":"#/components/schemas/_types.aggregations:AverageBucketAggregation"},"boxplot":{"$ref":"#/components/schemas/_types.aggregations:BoxplotAggregation"},"bucket_script":{"$ref":"#/components/schemas/_types.aggregations:BucketScriptAggregation"},"bucket_selector":{"$ref":"#/components/schemas/_types.aggregations:BucketSelectorAggregation"},"bucket_sort":{"$ref":"#/components/schemas/_types.aggregations:BucketSortAggregation"},"bucket_count_ks_test":{"$ref":"#/components/schemas/_types.aggregations:BucketKsAggregation"},"bucket_correlation":{"$ref":"#/components/schemas/_types.aggregations:BucketCorrelationAggregation"},"cardinality":{"$ref":"#/components/schemas/_types.aggregations:CardinalityAggregation"},"categorize_text":{"$ref":"#/components/schemas/_types.aggregations:CategorizeTextAggregation"},"children":{"$ref":"#/components/schemas/_types.aggregations:ChildrenAggregation"},"composite":{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregation"},"cumulative_cardinality":{"$ref":"#/components/schemas/_types.aggregations:CumulativeCardinalityAggregation"},"cumulative_sum":{"$ref":"#/components/schemas/_types.aggregations:CumulativeSumAggregation"},"date_histogram":{"$ref":"#/components/schemas/_types.aggregations:DateHistogramAggregation"},"date_range":{"$ref":"#/components/schemas/_types.aggregations:DateRangeAggregation"},"derivative":{"$ref":"#/components/schemas/_types.aggregations:DerivativeAggregation"},"diversified_sampler":{"$ref":"#/components/schemas/_types.aggregations:DiversifiedSamplerAggregation"},"extended_stats":{"$ref":"#/components/schemas/_types.aggregations:ExtendedStatsAggregation"},"extended_stats_bucket":{"$ref":"#/components/schemas/_types.aggregations:ExtendedStatsBucketAggregation"},"frequent_item_sets":{"$ref":"#/components/schemas/_types.aggregations:FrequentItemSetsAggregation"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"filters":{"$ref":"#/components/schemas/_types.aggregations:FiltersAggregation"},"geo_bounds":{"$ref":"#/components/schemas/_types.aggregations:GeoBoundsAggregation"},"geo_centroid":{"$ref":"#/components/schemas/_types.aggregations:GeoCentroidAggregation"},"geo_distance":{"$ref":"#/components/schemas/_types.aggregations:GeoDistanceAggregation"},"geohash_grid":{"$ref":"#/components/schemas/_types.aggregations:GeoHashGridAggregation"},"geo_line":{"$ref":"#/components/schemas/_types.aggregations:GeoLineAggregation"},"geotile_grid":{"$ref":"#/components/schemas/_types.aggregations:GeoTileGridAggregation"},"geohex_grid":{"$ref":"#/components/schemas/_types.aggregations:GeohexGridAggregation"},"global":{"$ref":"#/components/schemas/_types.aggregations:GlobalAggregation"},"histogram":{"$ref":"#/components/schemas/_types.aggregations:HistogramAggregation"},"ip_range":{"$ref":"#/components/schemas/_types.aggregations:IpRangeAggregation"},"ip_prefix":{"$ref":"#/components/schemas/_types.aggregations:IpPrefixAggregation"},"inference":{"$ref":"#/components/schemas/_types.aggregations:InferenceAggregation"},"line":{"$ref":"#/components/schemas/_types.aggregations:GeoLineAggregation"},"matrix_stats":{"$ref":"#/components/schemas/_types.aggregations:MatrixStatsAggregation"},"max":{"$ref":"#/components/schemas/_types.aggregations:MaxAggregation"},"max_bucket":{"$ref":"#/components/schemas/_types.aggregations:MaxBucketAggregation"},"median_absolute_deviation":{"$ref":"#/components/schemas/_types.aggregations:MedianAbsoluteDeviationAggregation"},"min":{"$ref":"#/components/schemas/_types.aggregations:MinAggregation"},"min_bucket":{"$ref":"#/components/schemas/_types.aggregations:MinBucketAggregation"},"missing":{"$ref":"#/components/schemas/_types.aggregations:MissingAggregation"},"moving_avg":{"$ref":"#/components/schemas/_types.aggregations:MovingAverageAggregation"},"moving_percentiles":{"$ref":"#/components/schemas/_types.aggregations:MovingPercentilesAggregation"},"moving_fn":{"$ref":"#/components/schemas/_types.aggregations:MovingFunctionAggregation"},"multi_terms":{"$ref":"#/components/schemas/_types.aggregations:MultiTermsAggregation"},"nested":{"$ref":"#/components/schemas/_types.aggregations:NestedAggregation"},"normalize":{"$ref":"#/components/schemas/_types.aggregations:NormalizeAggregation"},"parent":{"$ref":"#/components/schemas/_types.aggregations:ParentAggregation"},"percentile_ranks":{"$ref":"#/components/schemas/_types.aggregations:PercentileRanksAggregation"},"percentiles":{"$ref":"#/components/schemas/_types.aggregations:PercentilesAggregation"},"percentiles_bucket":{"$ref":"#/components/schemas/_types.aggregations:PercentilesBucketAggregation"},"range":{"$ref":"#/components/schemas/_types.aggregations:RangeAggregation"},"rare_terms":{"$ref":"#/components/schemas/_types.aggregations:RareTermsAggregation"},"rate":{"$ref":"#/components/schemas/_types.aggregations:RateAggregation"},"reverse_nested":{"$ref":"#/components/schemas/_types.aggregations:ReverseNestedAggregation"},"sampler":{"$ref":"#/components/schemas/_types.aggregations:SamplerAggregation"},"scripted_metric":{"$ref":"#/components/schemas/_types.aggregations:ScriptedMetricAggregation"},"serial_diff":{"$ref":"#/components/schemas/_types.aggregations:SerialDifferencingAggregation"},"significant_terms":{"$ref":"#/components/schemas/_types.aggregations:SignificantTermsAggregation"},"significant_text":{"$ref":"#/components/schemas/_types.aggregations:SignificantTextAggregation"},"stats":{"$ref":"#/components/schemas/_types.aggregations:StatsAggregation"},"stats_bucket":{"$ref":"#/components/schemas/_types.aggregations:StatsBucketAggregation"},"string_stats":{"$ref":"#/components/schemas/_types.aggregations:StringStatsAggregation"},"sum":{"$ref":"#/components/schemas/_types.aggregations:SumAggregation"},"sum_bucket":{"$ref":"#/components/schemas/_types.aggregations:SumBucketAggregation"},"terms":{"$ref":"#/components/schemas/_types.aggregations:TermsAggregation"},"time_series":{"$ref":"#/components/schemas/_types.aggregations:TimeSeriesAggregation"},"top_hits":{"$ref":"#/components/schemas/_types.aggregations:TopHitsAggregation"},"t_test":{"$ref":"#/components/schemas/_types.aggregations:TTestAggregation"},"top_metrics":{"$ref":"#/components/schemas/_types.aggregations:TopMetricsAggregation"},"value_count":{"$ref":"#/components/schemas/_types.aggregations:ValueCountAggregation"},"weighted_avg":{"$ref":"#/components/schemas/_types.aggregations:WeightedAverageAggregation"},"variable_width_histogram":{"$ref":"#/components/schemas/_types.aggregations:VariableWidthHistogramAggregation"}},"minProperties":1,"maxProperties":1}]},"_types:Metadata":{"type":"object","additionalProperties":{"type":"object"}},"_types.aggregations:AdjacencyMatrixAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"filters":{"description":"Filters used to create buckets.\\nAt least one filter is required.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"separator":{"description":"Separator used to concatenate filter names. Defaults to &.","type":"string"}}}]},"_types.aggregations:BucketAggregationBase":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object"}]},"_types.aggregations:Aggregation":{"type":"object"},"_types.query_dsl:QueryContainer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html"},"description":"An Elasticsearch Query DSL (Domain Specific Language) object that defines a query.","type":"object","properties":{"bool":{"$ref":"#/components/schemas/_types.query_dsl:BoolQuery"},"boosting":{"$ref":"#/components/schemas/_types.query_dsl:BoostingQuery"},"common":{"deprecated":true,"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:CommonTermsQuery"},"minProperties":1,"maxProperties":1},"combined_fields":{"$ref":"#/components/schemas/_types.query_dsl:CombinedFieldsQuery"},"constant_score":{"$ref":"#/components/schemas/_types.query_dsl:ConstantScoreQuery"},"dis_max":{"$ref":"#/components/schemas/_types.query_dsl:DisMaxQuery"},"distance_feature":{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQuery"},"exists":{"$ref":"#/components/schemas/_types.query_dsl:ExistsQuery"},"function_score":{"$ref":"#/components/schemas/_types.query_dsl:FunctionScoreQuery"},"fuzzy":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-fuzzy-query.html"},"description":"Returns documents that contain terms similar to the search term, as measured by a Levenshtein edit distance.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:FuzzyQuery"},"minProperties":1,"maxProperties":1},"geo_bounding_box":{"$ref":"#/components/schemas/_types.query_dsl:GeoBoundingBoxQuery"},"geo_distance":{"$ref":"#/components/schemas/_types.query_dsl:GeoDistanceQuery"},"geo_polygon":{"$ref":"#/components/schemas/_types.query_dsl:GeoPolygonQuery"},"geo_shape":{"$ref":"#/components/schemas/_types.query_dsl:GeoShapeQuery"},"has_child":{"$ref":"#/components/schemas/_types.query_dsl:HasChildQuery"},"has_parent":{"$ref":"#/components/schemas/_types.query_dsl:HasParentQuery"},"ids":{"$ref":"#/components/schemas/_types.query_dsl:IdsQuery"},"intervals":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-intervals-query.html"},"description":"Returns documents based on the order and proximity of matching terms.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsQuery"},"minProperties":1,"maxProperties":1},"knn":{"$ref":"#/components/schemas/_types:KnnQuery"},"match":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-query.html"},"description":"Returns documents that match a provided text, number, date or boolean value.\\nThe provided text is analyzed before matching.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchQuery"},"minProperties":1,"maxProperties":1},"match_all":{"$ref":"#/components/schemas/_types.query_dsl:MatchAllQuery"},"match_bool_prefix":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-bool-prefix-query.html"},"description":"Analyzes its input and constructs a `bool` query from the terms.\\nEach term except the last is used in a `term` query.\\nThe last term is used in a prefix query.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchBoolPrefixQuery"},"minProperties":1,"maxProperties":1},"match_none":{"$ref":"#/components/schemas/_types.query_dsl:MatchNoneQuery"},"match_phrase":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-query-phrase.html"},"description":"Analyzes the text and creates a phrase query out of the analyzed text.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchPhraseQuery"},"minProperties":1,"maxProperties":1},"match_phrase_prefix":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-query-phrase-prefix.html"},"description":"Returns documents that contain the words of a provided text, in the same order as provided.\\nThe last term of the provided text is treated as a prefix, matching any words that begin with that term.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchPhrasePrefixQuery"},"minProperties":1,"maxProperties":1},"more_like_this":{"$ref":"#/components/schemas/_types.query_dsl:MoreLikeThisQuery"},"multi_match":{"$ref":"#/components/schemas/_types.query_dsl:MultiMatchQuery"},"nested":{"$ref":"#/components/schemas/_types.query_dsl:NestedQuery"},"parent_id":{"$ref":"#/components/schemas/_types.query_dsl:ParentIdQuery"},"percolate":{"$ref":"#/components/schemas/_types.query_dsl:PercolateQuery"},"pinned":{"$ref":"#/components/schemas/_types.query_dsl:PinnedQuery"},"prefix":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-prefix-query.html"},"description":"Returns documents that contain a specific prefix in a provided field.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:PrefixQuery"},"minProperties":1,"maxProperties":1},"query_string":{"$ref":"#/components/schemas/_types.query_dsl:QueryStringQuery"},"range":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-range-query.html"},"description":"Returns documents that contain terms within a provided range.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:RangeQuery"},"minProperties":1,"maxProperties":1},"rank_feature":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureQuery"},"regexp":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-regexp-query.html"},"description":"Returns documents that contain terms matching a regular expression.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:RegexpQuery"},"minProperties":1,"maxProperties":1},"rule":{"$ref":"#/components/schemas/_types.query_dsl:RuleQuery"},"script":{"$ref":"#/components/schemas/_types.query_dsl:ScriptQuery"},"script_score":{"$ref":"#/components/schemas/_types.query_dsl:ScriptScoreQuery"},"semantic":{"$ref":"#/components/schemas/_types.query_dsl:SemanticQuery"},"shape":{"$ref":"#/components/schemas/_types.query_dsl:ShapeQuery"},"simple_query_string":{"$ref":"#/components/schemas/_types.query_dsl:SimpleQueryStringQuery"},"span_containing":{"$ref":"#/components/schemas/_types.query_dsl:SpanContainingQuery"},"span_field_masking":{"$ref":"#/components/schemas/_types.query_dsl:SpanFieldMaskingQuery"},"span_first":{"$ref":"#/components/schemas/_types.query_dsl:SpanFirstQuery"},"span_multi":{"$ref":"#/components/schemas/_types.query_dsl:SpanMultiTermQuery"},"span_near":{"$ref":"#/components/schemas/_types.query_dsl:SpanNearQuery"},"span_not":{"$ref":"#/components/schemas/_types.query_dsl:SpanNotQuery"},"span_or":{"$ref":"#/components/schemas/_types.query_dsl:SpanOrQuery"},"span_term":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-span-term-query.html"},"description":"Matches spans containing a term.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:SpanTermQuery"},"minProperties":1,"maxProperties":1},"span_within":{"$ref":"#/components/schemas/_types.query_dsl:SpanWithinQuery"},"sparse_vector":{"$ref":"#/components/schemas/_types.query_dsl:SparseVectorQuery"},"term":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-term-query.html"},"description":"Returns documents that contain an exact term in a provided field.\\nTo return a document, the query term must exactly match the queried field\'s value, including whitespace and capitalization.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:TermQuery"},"minProperties":1,"maxProperties":1},"terms":{"$ref":"#/components/schemas/_types.query_dsl:TermsQuery"},"terms_set":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-terms-set-query.html"},"description":"Returns documents that contain a minimum number of exact terms in a provided field.\\nTo return a document, a required number of terms must exactly match the field values, including whitespace and capitalization.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:TermsSetQuery"},"minProperties":1,"maxProperties":1},"text_expansion":{"deprecated":true,"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-text-expansion-query.html"},"description":"Uses a natural language processing model to convert the query text into a list of token-weight pairs which are then used in a query against a sparse vector or rank features field.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:TextExpansionQuery"},"minProperties":1,"maxProperties":1},"weighted_tokens":{"deprecated":true,"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-weighted-tokens-query.html"},"description":"Supports returning text_expansion query results by sending in precomputed tokens with the query.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:WeightedTokensQuery"},"minProperties":1,"maxProperties":1},"wildcard":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-wildcard-query.html"},"description":"Returns documents that contain terms matching a wildcard pattern.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:WildcardQuery"},"minProperties":1,"maxProperties":1},"wrapper":{"$ref":"#/components/schemas/_types.query_dsl:WrapperQuery"},"type":{"$ref":"#/components/schemas/_types.query_dsl:TypeQuery"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:BoolQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"filter":{"description":"The clause (query) must appear in matching documents.\\nHowever, unlike `must`, the score of the query will be ignored.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"must":{"description":"The clause (query) must appear in matching documents and will contribute to the score.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"must_not":{"description":"The clause (query) must not appear in the matching documents.\\nBecause scoring is ignored, a score of `0` is returned for all documents.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"should":{"description":"The clause (query) should appear in the matching document.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]}}}]},"_types.query_dsl:QueryBase":{"type":"object","properties":{"boost":{"description":"Floating point number used to decrease or increase the relevance scores of the query.\\nBoost values are relative to the default value of 1.0.\\nA boost value between 0 and 1.0 decreases the relevance score.\\nA value greater than 1.0 increases the relevance score.","type":"number"},"_name":{"type":"string"}}},"_types:MinimumShouldMatch":{"description":"The minimum number of terms that should match as integer, percentage or range","oneOf":[{"type":"number"},{"type":"string"}]},"_types.query_dsl:BoostingQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"negative_boost":{"description":"Floating point number between 0 and 1.0 used to decrease the relevance scores of documents matching the `negative` query.","type":"number"},"negative":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"positive":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["negative_boost","negative","positive"]}]},"_types.query_dsl:CommonTermsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"type":"string"},"cutoff_frequency":{"type":"number"},"high_freq_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"low_freq_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"query":{"type":"string"}},"required":["query"]}]},"_types.query_dsl:Operator":{"type":"string","enum":["and","AND","or","OR"]},"_types.query_dsl:CombinedFieldsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"fields":{"description":"List of fields to search. Field wildcard patterns are allowed. Only `text` fields are supported, and they must all have the same search `analyzer`.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"query":{"description":"Text to search for in the provided `fields`.\\nThe `combined_fields` query analyzes the provided text before performing a search.","type":"string"},"auto_generate_synonyms_phrase_query":{"description":"If true, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:CombinedFieldsOperator"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:CombinedFieldsZeroTerms"}},"required":["fields","query"]}]},"_types.query_dsl:CombinedFieldsOperator":{"type":"string","enum":["or","and"]},"_types.query_dsl:CombinedFieldsZeroTerms":{"type":"string","enum":["none","all"]},"_types.query_dsl:ConstantScoreQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["filter"]}]},"_types.query_dsl:DisMaxQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"queries":{"description":"One or more query clauses.\\nReturned documents must match one or more of these queries.\\nIf a document matches multiple queries, Elasticsearch uses the highest relevance score.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"tie_breaker":{"description":"Floating point number between 0 and 1.0 used to increase the relevance scores of documents matching multiple query clauses.","type":"number"}},"required":["queries"]}]},"_types.query_dsl:DistanceFeatureQuery":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-distance-feature-query.html"},"oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:UntypedDistanceFeatureQuery"},{"$ref":"#/components/schemas/_types.query_dsl:GeoDistanceFeatureQuery"},{"$ref":"#/components/schemas/_types.query_dsl:DateDistanceFeatureQuery"}]},"_types.query_dsl:UntypedDistanceFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQueryBase"},{"type":"object"}]},"_types.query_dsl:DistanceFeatureQueryBase":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"origin":{"description":"Date or point of origin used to calculate distances.\\nIf the `field` value is a `date` or `date_nanos` field, the `origin` value must be a date.\\nDate Math, such as `now-1h`, is supported.\\nIf the field value is a `geo_point` field, the `origin` value must be a geopoint.","type":"object"},"pivot":{"description":"Distance from the `origin` at which relevance scores receive half of the `boost` value.\\nIf the `field` value is a `date` or `date_nanos` field, the `pivot` value must be a time unit, such as `1h` or `10d`. If the `field` value is a `geo_point` field, the `pivot` value must be a distance unit, such as `1km` or `12m`.","type":"object"},"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["origin","pivot","field"]}]},"_types.query_dsl:GeoDistanceFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQueryBaseGeoLocationDistance"},{"type":"object"}]},"_types.query_dsl:DistanceFeatureQueryBaseGeoLocationDistance":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"origin":{"$ref":"#/components/schemas/_types:GeoLocation"},"pivot":{"$ref":"#/components/schemas/_types:Distance"},"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["origin","pivot","field"]}]},"_types:GeoLocation":{"description":"A latitude/longitude as a 2 dimensional point. It can be represented in various ways:\\n- as a `{lat, long}` object\\n- as a geo hash value\\n- as a `[lon, lat]` array\\n- as a string in `\\"<lat>, <lon>\\"` or WKT point formats","oneOf":[{"$ref":"#/components/schemas/_types:LatLonGeoLocation"},{"$ref":"#/components/schemas/_types:GeoHashLocation"},{"type":"array","items":{"type":"number"}},{"type":"string"}]},"_types:LatLonGeoLocation":{"type":"object","properties":{"lat":{"description":"Latitude","type":"number"},"lon":{"description":"Longitude","type":"number"}},"required":["lat","lon"]},"_types:GeoHashLocation":{"type":"object","properties":{"geohash":{"$ref":"#/components/schemas/_types:GeoHash"}},"required":["geohash"]},"_types:GeoHash":{"type":"string"},"_types:Distance":{"type":"string"},"_types.query_dsl:DateDistanceFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQueryBaseDateMathDuration"},{"type":"object"}]},"_types.query_dsl:DistanceFeatureQueryBaseDateMathDuration":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"origin":{"$ref":"#/components/schemas/_types:DateMath"},"pivot":{"$ref":"#/components/schemas/_types:Duration"},"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["origin","pivot","field"]}]},"_types:DateMath":{"type":"string"},"_types.query_dsl:ExistsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["field"]}]},"_types.query_dsl:FunctionScoreQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"boost_mode":{"$ref":"#/components/schemas/_types.query_dsl:FunctionBoostMode"},"functions":{"description":"One or more functions that compute a new score for each document returned by the query.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:FunctionScoreContainer"}},"max_boost":{"description":"Restricts the new score to not exceed the provided limit.","type":"number"},"min_score":{"description":"Excludes documents that do not meet the provided score threshold.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score_mode":{"$ref":"#/components/schemas/_types.query_dsl:FunctionScoreMode"}}}]},"_types.query_dsl:FunctionBoostMode":{"type":"string","enum":["multiply","replace","sum","avg","max","min"]},"_types.query_dsl:FunctionScoreContainer":{"allOf":[{"type":"object","properties":{"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"weight":{"type":"number"}}},{"type":"object","properties":{"exp":{"$ref":"#/components/schemas/_types.query_dsl:DecayFunction"},"gauss":{"$ref":"#/components/schemas/_types.query_dsl:DecayFunction"},"linear":{"$ref":"#/components/schemas/_types.query_dsl:DecayFunction"},"field_value_factor":{"$ref":"#/components/schemas/_types.query_dsl:FieldValueFactorScoreFunction"},"random_score":{"$ref":"#/components/schemas/_types.query_dsl:RandomScoreFunction"},"script_score":{"$ref":"#/components/schemas/_types.query_dsl:ScriptScoreFunction"}},"minProperties":1,"maxProperties":1}]},"_types.query_dsl:DecayFunction":{"oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:UntypedDecayFunction"},{"$ref":"#/components/schemas/_types.query_dsl:DateDecayFunction"},{"$ref":"#/components/schemas/_types.query_dsl:NumericDecayFunction"},{"$ref":"#/components/schemas/_types.query_dsl:GeoDecayFunction"}]},"_types.query_dsl:UntypedDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBase"},{"type":"object"}]},"_types.query_dsl:DecayFunctionBase":{"type":"object","properties":{"multi_value_mode":{"$ref":"#/components/schemas/_types.query_dsl:MultiValueMode"}}},"_types.query_dsl:MultiValueMode":{"type":"string","enum":["min","max","avg","sum"]},"_types.query_dsl:DateDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBaseDateMathDuration"},{"type":"object"}]},"_types.query_dsl:DecayFunctionBaseDateMathDuration":{"type":"object","properties":{"multi_value_mode":{"$ref":"#/components/schemas/_types.query_dsl:MultiValueMode"}}},"_types.query_dsl:NumericDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBasedoubledouble"},{"type":"object"}]},"_types.query_dsl:DecayFunctionBasedoubledouble":{"type":"object","properties":{"multi_value_mode":{"$ref":"#/components/schemas/_types.query_dsl:MultiValueMode"}}},"_types.query_dsl:GeoDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBaseGeoLocationDistance"},{"type":"object"}]},"_types.query_dsl:DecayFunctionBaseGeoLocationDistance":{"type":"object","properties":{"multi_value_mode":{"$ref":"#/components/schemas/_types.query_dsl:MultiValueMode"}}},"_types.query_dsl:FieldValueFactorScoreFunction":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"factor":{"description":"Optional factor to multiply the field value with.","type":"number"},"missing":{"description":"Value used if the document doesn’t have that field.\\nThe modifier and factor are still applied to it as though it were read from the document.","type":"number"},"modifier":{"$ref":"#/components/schemas/_types.query_dsl:FieldValueFactorModifier"}},"required":["field"]},"_types.query_dsl:FieldValueFactorModifier":{"type":"string","enum":["none","log","log1p","log2p","ln","ln1p","ln2p","square","sqrt","reciprocal"]},"_types.query_dsl:RandomScoreFunction":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"seed":{"oneOf":[{"type":"number"},{"type":"string"}]}}},"_types.query_dsl:ScriptScoreFunction":{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["script"]},"_types.query_dsl:FunctionScoreMode":{"type":"string","enum":["multiply","sum","avg","first","max","min"]},"_types.query_dsl:FuzzyQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"max_expansions":{"description":"Maximum number of variations created.","type":"number"},"prefix_length":{"description":"Number of beginning characters left unchanged when creating expansions.","type":"number"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"transpositions":{"description":"Indicates whether edits include transpositions of two adjacent characters (for example `ab` to `ba`).","type":"boolean"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"value":{"description":"Term you wish to find in the provided field.","oneOf":[{"type":"string"},{"type":"number"},{"type":"boolean"}]}},"required":["value"]}]},"_types:MultiTermQueryRewrite":{"type":"string"},"_types:Fuzziness":{"oneOf":[{"type":"string"},{"type":"number"}]},"_types.query_dsl:GeoBoundingBoxQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_types.query_dsl:GeoExecution"},"validation_method":{"$ref":"#/components/schemas/_types.query_dsl:GeoValidationMethod"},"ignore_unmapped":{"description":"Set to `true` to ignore an unmapped field and not match any documents for this query.\\nSet to `false` to throw an exception if the field is not mapped.","type":"boolean"}}}]},"_types.query_dsl:GeoExecution":{"type":"string","enum":["memory","indexed"]},"_types.query_dsl:GeoValidationMethod":{"type":"string","enum":["coerce","ignore_malformed","strict"]},"_types.query_dsl:GeoDistanceQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"distance":{"$ref":"#/components/schemas/_types:Distance"},"distance_type":{"$ref":"#/components/schemas/_types:GeoDistanceType"},"validation_method":{"$ref":"#/components/schemas/_types.query_dsl:GeoValidationMethod"},"ignore_unmapped":{"description":"Set to `true` to ignore an unmapped field and not match any documents for this query.\\nSet to `false` to throw an exception if the field is not mapped.","type":"boolean"}},"required":["distance"]}]},"_types:GeoDistanceType":{"type":"string","enum":["arc","plane"]},"_types.query_dsl:GeoPolygonQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"validation_method":{"$ref":"#/components/schemas/_types.query_dsl:GeoValidationMethod"},"ignore_unmapped":{"type":"boolean"}}}]},"_types.query_dsl:GeoShapeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Set to `true` to ignore an unmapped field and not match any documents for this query.\\nSet to `false` to throw an exception if the field is not mapped.","type":"boolean"}}}]},"_types.query_dsl:HasChildQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped `type` and not return any documents instead of an error.","type":"boolean"},"inner_hits":{"$ref":"#/components/schemas/_global.search._types:InnerHits"},"max_children":{"description":"Maximum number of child documents that match the query allowed for a returned parent document.\\nIf the parent document exceeds this limit, it is excluded from the search results.","type":"number"},"min_children":{"description":"Minimum number of child documents that match the query required to match the query for a returned parent document.\\nIf the parent document does not meet this limit, it is excluded from the search results.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score_mode":{"$ref":"#/components/schemas/_types.query_dsl:ChildScoreMode"},"type":{"$ref":"#/components/schemas/_types:RelationName"}},"required":["query","type"]}]},"_global.search._types:InnerHits":{"type":"object","properties":{"name":{"$ref":"#/components/schemas/_types:Name"},"size":{"description":"The maximum number of hits to return per `inner_hits`.","type":"number"},"from":{"description":"Inner hit starting document offset.","type":"number"},"collapse":{"$ref":"#/components/schemas/_global.search._types:FieldCollapse"},"docvalue_fields":{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:FieldAndFormat"}},"explain":{"type":"boolean"},"highlight":{"$ref":"#/components/schemas/_global.search._types:Highlight"},"ignore_unmapped":{"type":"boolean"},"script_fields":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:ScriptField"}},"seq_no_primary_term":{"type":"boolean"},"fields":{"$ref":"#/components/schemas/_types:Fields"},"sort":{"$ref":"#/components/schemas/_types:Sort"},"_source":{"$ref":"#/components/schemas/_global.search._types:SourceConfig"},"stored_fields":{"$ref":"#/components/schemas/_types:Fields"},"track_scores":{"type":"boolean"},"version":{"type":"boolean"}}},"_types:Name":{"type":"string"},"_global.search._types:FieldCollapse":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"inner_hits":{"description":"The number of inner hits and their sort order","oneOf":[{"$ref":"#/components/schemas/_global.search._types:InnerHits"},{"type":"array","items":{"$ref":"#/components/schemas/_global.search._types:InnerHits"}}]},"max_concurrent_group_searches":{"description":"The number of concurrent requests allowed to retrieve the inner_hits per group","type":"number"},"collapse":{"$ref":"#/components/schemas/_global.search._types:FieldCollapse"}},"required":["field"]},"_types.query_dsl:FieldAndFormat":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"format":{"description":"Format in which the values are returned.","type":"string"},"include_unmapped":{"type":"boolean"}},"required":["field"]},"_global.search._types:Highlight":{"allOf":[{"$ref":"#/components/schemas/_global.search._types:HighlightBase"},{"type":"object","properties":{"encoder":{"$ref":"#/components/schemas/_global.search._types:HighlighterEncoder"},"fields":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_global.search._types:HighlightField"}}},"required":["fields"]}]},"_global.search._types:HighlightBase":{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_global.search._types:HighlighterType"},"boundary_chars":{"description":"A string that contains each boundary character.","type":"string"},"boundary_max_scan":{"description":"How far to scan for boundary characters.","type":"number"},"boundary_scanner":{"$ref":"#/components/schemas/_global.search._types:BoundaryScanner"},"boundary_scanner_locale":{"description":"Controls which locale is used to search for sentence and word boundaries.\\nThis parameter takes a form of a language tag, for example: `\\"en-US\\"`, `\\"fr-FR\\"`, `\\"ja-JP\\"`.","type":"string"},"force_source":{"deprecated":true,"type":"boolean"},"fragmenter":{"$ref":"#/components/schemas/_global.search._types:HighlighterFragmenter"},"fragment_size":{"description":"The size of the highlighted fragment in characters.","type":"number"},"highlight_filter":{"type":"boolean"},"highlight_query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"max_fragment_length":{"type":"number"},"max_analyzed_offset":{"description":"If set to a non-negative value, highlighting stops at this defined maximum limit.\\nThe rest of the text is not processed, thus not highlighted and no error is returned\\nThe `max_analyzed_offset` query setting does not override the `index.highlight.max_analyzed_offset` setting, which prevails when it’s set to lower value than the query setting.","type":"number"},"no_match_size":{"description":"The amount of text you want to return from the beginning of the field if there are no matching fragments to highlight.","type":"number"},"number_of_fragments":{"description":"The maximum number of fragments to return.\\nIf the number of fragments is set to `0`, no fragments are returned.\\nInstead, the entire field contents are highlighted and returned.\\nThis can be handy when you need to highlight short texts such as a title or address, but fragmentation is not required.\\nIf `number_of_fragments` is `0`, `fragment_size` is ignored.","type":"number"},"options":{"type":"object","additionalProperties":{"type":"object"}},"order":{"$ref":"#/components/schemas/_global.search._types:HighlighterOrder"},"phrase_limit":{"description":"Controls the number of matching phrases in a document that are considered.\\nPrevents the `fvh` highlighter from analyzing too many phrases and consuming too much memory.\\nWhen using `matched_fields`, `phrase_limit` phrases per matched field are considered. Raising the limit increases query time and consumes more memory.\\nOnly supported by the `fvh` highlighter.","type":"number"},"post_tags":{"description":"Use in conjunction with `pre_tags` to define the HTML tags to use for the highlighted text.\\nBy default, highlighted text is wrapped in `<em>` and `</em>` tags.","type":"array","items":{"type":"string"}},"pre_tags":{"description":"Use in conjunction with `post_tags` to define the HTML tags to use for the highlighted text.\\nBy default, highlighted text is wrapped in `<em>` and `</em>` tags.","type":"array","items":{"type":"string"}},"require_field_match":{"description":"By default, only fields that contains a query match are highlighted.\\nSet to `false` to highlight all fields.","type":"boolean"},"tags_schema":{"$ref":"#/components/schemas/_global.search._types:HighlighterTagsSchema"}}},"_global.search._types:HighlighterType":{"anyOf":[{"type":"string","enum":["plain","fvh","unified"]},{"type":"string"}]},"_global.search._types:BoundaryScanner":{"type":"string","enum":["chars","sentence","word"]},"_global.search._types:HighlighterFragmenter":{"type":"string","enum":["simple","span"]},"_global.search._types:HighlighterOrder":{"type":"string","enum":["score"]},"_global.search._types:HighlighterTagsSchema":{"type":"string","enum":["styled"]},"_global.search._types:HighlighterEncoder":{"type":"string","enum":["default","html"]},"_global.search._types:HighlightField":{"allOf":[{"$ref":"#/components/schemas/_global.search._types:HighlightBase"},{"type":"object","properties":{"fragment_offset":{"type":"number"},"matched_fields":{"$ref":"#/components/schemas/_types:Fields"}}}]},"_types:Fields":{"oneOf":[{"$ref":"#/components/schemas/_types:Field"},{"type":"array","items":{"$ref":"#/components/schemas/_types:Field"}}]},"_types:ScriptField":{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"},"ignore_failure":{"type":"boolean"}},"required":["script"]},"_types:Sort":{"oneOf":[{"$ref":"#/components/schemas/_types:SortCombinations"},{"type":"array","items":{"$ref":"#/components/schemas/_types:SortCombinations"}}]},"_types:SortCombinations":{"oneOf":[{"$ref":"#/components/schemas/_types:Field"},{"$ref":"#/components/schemas/_types:SortOptions"}]},"_types:SortOptions":{"type":"object","properties":{"_score":{"$ref":"#/components/schemas/_types:ScoreSort"},"_doc":{"$ref":"#/components/schemas/_types:ScoreSort"},"_geo_distance":{"$ref":"#/components/schemas/_types:GeoDistanceSort"},"_script":{"$ref":"#/components/schemas/_types:ScriptSort"}},"minProperties":1,"maxProperties":1},"_types:ScoreSort":{"type":"object","properties":{"order":{"$ref":"#/components/schemas/_types:SortOrder"}}},"_types:SortOrder":{"type":"string","enum":["asc","desc"]},"_types:GeoDistanceSort":{"type":"object","properties":{"mode":{"$ref":"#/components/schemas/_types:SortMode"},"distance_type":{"$ref":"#/components/schemas/_types:GeoDistanceType"},"ignore_unmapped":{"type":"boolean"},"order":{"$ref":"#/components/schemas/_types:SortOrder"},"unit":{"$ref":"#/components/schemas/_types:DistanceUnit"},"nested":{"$ref":"#/components/schemas/_types:NestedSortValue"}}},"_types:SortMode":{"type":"string","enum":["min","max","sum","avg","median"]},"_types:DistanceUnit":{"type":"string","enum":["in","ft","yd","mi","nmi","km","m","cm","mm"]},"_types:NestedSortValue":{"type":"object","properties":{"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"max_children":{"type":"number"},"nested":{"$ref":"#/components/schemas/_types:NestedSortValue"},"path":{"$ref":"#/components/schemas/_types:Field"}},"required":["path"]},"_types:ScriptSort":{"type":"object","properties":{"order":{"$ref":"#/components/schemas/_types:SortOrder"},"script":{"$ref":"#/components/schemas/_types:Script"},"type":{"$ref":"#/components/schemas/_types:ScriptSortType"},"mode":{"$ref":"#/components/schemas/_types:SortMode"},"nested":{"$ref":"#/components/schemas/_types:NestedSortValue"}},"required":["script"]},"_types:ScriptSortType":{"type":"string","enum":["string","number","version"]},"_global.search._types:SourceConfig":{"description":"Defines how to fetch a source. Fetching can be disabled entirely, or the source can be filtered.","oneOf":[{"type":"boolean"},{"$ref":"#/components/schemas/_global.search._types:SourceFilter"}]},"_global.search._types:SourceFilter":{"type":"object","properties":{"excludes":{"$ref":"#/components/schemas/_types:Fields"},"includes":{"$ref":"#/components/schemas/_types:Fields"}}},"_types.query_dsl:ChildScoreMode":{"type":"string","enum":["none","avg","sum","max","min"]},"_types:RelationName":{"type":"string"},"_types.query_dsl:HasParentQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped `parent_type` and not return any documents instead of an error.\\nYou can use this parameter to query multiple indices that may not contain the `parent_type`.","type":"boolean"},"inner_hits":{"$ref":"#/components/schemas/_global.search._types:InnerHits"},"parent_type":{"$ref":"#/components/schemas/_types:RelationName"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score":{"description":"Indicates whether the relevance score of a matching parent document is aggregated into its child documents.","type":"boolean"}},"required":["parent_type","query"]}]},"_types.query_dsl:IdsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"values":{"$ref":"#/components/schemas/_types:Ids"}}}]},"_types:Ids":{"oneOf":[{"$ref":"#/components/schemas/_types:Id"},{"type":"array","items":{"$ref":"#/components/schemas/_types:Id"}}]},"_types.query_dsl:IntervalsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-intervals-query.html"},"type":"object","properties":{"all_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAllOf"},"any_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAnyOf"},"fuzzy":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFuzzy"},"match":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsMatch"},"prefix":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsPrefix"},"wildcard":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsWildcard"}},"minProperties":1,"maxProperties":1}]},"_types.query_dsl:IntervalsAllOf":{"type":"object","properties":{"intervals":{"description":"An array of rules to combine. All rules must produce a match in a document for the overall source to match.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"}},"max_gaps":{"description":"Maximum number of positions between the matching terms.\\nIntervals produced by the rules further apart than this are not considered matches.","type":"number"},"ordered":{"description":"If `true`, intervals produced by the rules should appear in the order in which they are specified.","type":"boolean"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFilter"}},"required":["intervals"]},"_types.query_dsl:IntervalsContainer":{"type":"object","properties":{"all_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAllOf"},"any_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAnyOf"},"fuzzy":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFuzzy"},"match":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsMatch"},"prefix":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsPrefix"},"wildcard":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsWildcard"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:IntervalsAnyOf":{"type":"object","properties":{"intervals":{"description":"An array of rules to match.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"}},"filter":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFilter"}},"required":["intervals"]},"_types.query_dsl:IntervalsFilter":{"type":"object","properties":{"after":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"before":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"contained_by":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"containing":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"not_contained_by":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"not_containing":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"not_overlapping":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"overlapping":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"script":{"$ref":"#/components/schemas/_types:Script"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:IntervalsFuzzy":{"type":"object","properties":{"analyzer":{"description":"Analyzer used to normalize the term.","type":"string"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"prefix_length":{"description":"Number of beginning characters left unchanged when creating expansions.","type":"number"},"term":{"description":"The term to match.","type":"string"},"transpositions":{"description":"Indicates whether edits include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"use_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["term"]},"_types.query_dsl:IntervalsMatch":{"type":"object","properties":{"analyzer":{"description":"Analyzer used to analyze terms in the query.","type":"string"},"max_gaps":{"description":"Maximum number of positions between the matching terms.\\nTerms further apart than this are not considered matches.","type":"number"},"ordered":{"description":"If `true`, matching terms must appear in their specified order.","type":"boolean"},"query":{"description":"Text you wish to find in the provided field.","type":"string"},"use_field":{"$ref":"#/components/schemas/_types:Field"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFilter"}},"required":["query"]},"_types.query_dsl:IntervalsPrefix":{"type":"object","properties":{"analyzer":{"description":"Analyzer used to analyze the `prefix`.","type":"string"},"prefix":{"description":"Beginning characters of terms you wish to find in the top-level field.","type":"string"},"use_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["prefix"]},"_types.query_dsl:IntervalsWildcard":{"type":"object","properties":{"analyzer":{"description":"Analyzer used to analyze the `pattern`.\\nDefaults to the top-level field\'s analyzer.","type":"string"},"pattern":{"description":"Wildcard pattern used to find matching terms.","type":"string"},"use_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["pattern"]},"_types:KnnQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"query_vector":{"$ref":"#/components/schemas/_types:QueryVector"},"query_vector_builder":{"$ref":"#/components/schemas/_types:QueryVectorBuilder"},"num_candidates":{"description":"The number of nearest neighbor candidates to consider per shard","type":"number"},"k":{"description":"The final number of nearest neighbors to return as top hits","type":"number"},"filter":{"description":"Filters for the kNN search query","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"similarity":{"description":"The minimum similarity for a vector to be considered a match","type":"number"},"rescore_vector":{"$ref":"#/components/schemas/_types:RescoreVector"}},"required":["field"]}]},"_types:QueryVector":{"type":"array","items":{"type":"number"}},"_types:QueryVectorBuilder":{"type":"object","properties":{"text_embedding":{"$ref":"#/components/schemas/_types:TextEmbedding"}},"minProperties":1,"maxProperties":1},"_types:TextEmbedding":{"type":"object","properties":{"model_id":{"type":"string"},"model_text":{"type":"string"}},"required":["model_id","model_text"]},"_types:RescoreVector":{"type":"object","properties":{"oversample":{"description":"Applies the specified oversample factor to k on the approximate kNN search","type":"number"}},"required":["oversample"]},"_types.query_dsl:MatchQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"cutoff_frequency":{"deprecated":true,"type":"number"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text query value for a numeric field, are ignored.","type":"boolean"},"max_expansions":{"description":"Maximum number of terms to which the query will expand.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"query":{"description":"Text, number, boolean value or date you wish to find in the provided field.","oneOf":[{"type":"string"},{"type":"number"},{"type":"boolean"}]},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:ZeroTermsQuery":{"type":"string","enum":["all","none"]},"_types.query_dsl:MatchAllQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object"}]},"_types.query_dsl:MatchBoolPrefixQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"boolean"},"max_expansions":{"description":"Maximum number of terms to which the query will expand.\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"number"},"query":{"description":"Terms you wish to find in the provided field.\\nThe last term is used in a prefix query.","type":"string"}},"required":["query"]}]},"_types.query_dsl:MatchNoneQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object"}]},"_types.query_dsl:MatchPhraseQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"query":{"description":"Query terms that are analyzed and turned into a phrase query.","type":"string"},"slop":{"description":"Maximum number of positions allowed between matching tokens.","type":"number"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:MatchPhrasePrefixQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"description":"Analyzer used to convert text in the query value into tokens.","type":"string"},"max_expansions":{"description":"Maximum number of terms to which the last provided term of the query value will expand.","type":"number"},"query":{"description":"Text you wish to find in the provided field.","type":"string"},"slop":{"description":"Maximum number of positions allowed between matching tokens.","type":"number"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:MoreLikeThisQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"The analyzer that is used to analyze the free form text.\\nDefaults to the analyzer associated with the first field in fields.","type":"string"},"boost_terms":{"description":"Each term in the formed query could be further boosted by their tf-idf score.\\nThis sets the boost factor to use when using this feature.\\nDefaults to deactivated (0).","type":"number"},"fail_on_unsupported_field":{"description":"Controls whether the query should fail (throw an exception) if any of the specified fields are not of the supported types (`text` or `keyword`).","type":"boolean"},"fields":{"description":"A list of fields to fetch and analyze the text from.\\nDefaults to the `index.query.default_field` index setting, which has a default value of `*`.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"include":{"description":"Specifies whether the input documents should also be included in the search results returned.","type":"boolean"},"like":{"description":"Specifies free form text and/or a single or multiple documents for which you want to find similar documents.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:Like"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:Like"}}]},"max_doc_freq":{"description":"The maximum document frequency above which the terms are ignored from the input document.","type":"number"},"max_query_terms":{"description":"The maximum number of query terms that can be selected.","type":"number"},"max_word_length":{"description":"The maximum word length above which the terms are ignored.\\nDefaults to unbounded (`0`).","type":"number"},"min_doc_freq":{"description":"The minimum document frequency below which the terms are ignored from the input document.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"min_term_freq":{"description":"The minimum term frequency below which the terms are ignored from the input document.","type":"number"},"min_word_length":{"description":"The minimum word length below which the terms are ignored.","type":"number"},"routing":{"$ref":"#/components/schemas/_types:Routing"},"stop_words":{"$ref":"#/components/schemas/_types.analysis:StopWords"},"unlike":{"description":"Used in combination with `like` to exclude documents that match a set of terms.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:Like"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:Like"}}]},"version":{"$ref":"#/components/schemas/_types:VersionNumber"},"version_type":{"$ref":"#/components/schemas/_types:VersionType"}},"required":["like"]}]},"_types.query_dsl:Like":{"description":"Text that we want similar documents for or a lookup to a document\'s field for the text.","oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types.query_dsl:LikeDocument"}]},"_types.query_dsl:LikeDocument":{"type":"object","properties":{"doc":{"description":"A document not present in the index.","type":"object"},"fields":{"type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"_id":{"$ref":"#/components/schemas/_types:Id"},"_index":{"$ref":"#/components/schemas/_types:IndexName"},"per_field_analyzer":{"description":"Overrides the default analyzer.","type":"object","additionalProperties":{"type":"string"}},"routing":{"$ref":"#/components/schemas/_types:Routing"},"version":{"$ref":"#/components/schemas/_types:VersionNumber"},"version_type":{"$ref":"#/components/schemas/_types:VersionType"}}},"_types:IndexName":{"type":"string"},"_types:Routing":{"type":"string"},"_types:VersionNumber":{"type":"number"},"_types:VersionType":{"type":"string","enum":["internal","external","external_gte","force"]},"_types.query_dsl:MultiMatchQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"cutoff_frequency":{"deprecated":true,"type":"number"},"fields":{"$ref":"#/components/schemas/_types:Fields"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text query value for a numeric field, are ignored.","type":"boolean"},"max_expansions":{"description":"Maximum number of terms to which the query will expand.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"query":{"description":"Text, number, boolean value or date you wish to find in the provided field.","type":"string"},"slop":{"description":"Maximum number of positions allowed between matching tokens.","type":"number"},"tie_breaker":{"description":"Determines how scores for each per-term blended query and scores across groups are combined.","type":"number"},"type":{"$ref":"#/components/schemas/_types.query_dsl:TextQueryType"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:TextQueryType":{"type":"string","enum":["best_fields","most_fields","cross_fields","phrase","phrase_prefix","bool_prefix"]},"_types.query_dsl:NestedQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped path and not return any documents instead of an error.","type":"boolean"},"inner_hits":{"$ref":"#/components/schemas/_global.search._types:InnerHits"},"path":{"$ref":"#/components/schemas/_types:Field"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score_mode":{"$ref":"#/components/schemas/_types.query_dsl:ChildScoreMode"}},"required":["path","query"]}]},"_types.query_dsl:ParentIdQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"id":{"$ref":"#/components/schemas/_types:Id"},"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped `type` and not return any documents instead of an error.","type":"boolean"},"type":{"$ref":"#/components/schemas/_types:RelationName"}}}]},"_types.query_dsl:PercolateQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"document":{"description":"The source of the document being percolated.","type":"object"},"documents":{"description":"An array of sources of the documents being percolated.","type":"array","items":{"type":"object"}},"field":{"$ref":"#/components/schemas/_types:Field"},"id":{"$ref":"#/components/schemas/_types:Id"},"index":{"$ref":"#/components/schemas/_types:IndexName"},"name":{"description":"The suffix used for the `_percolator_document_slot` field when multiple `percolate` queries are specified.","type":"string"},"preference":{"description":"Preference used to fetch document to percolate.","type":"string"},"routing":{"$ref":"#/components/schemas/_types:Routing"},"version":{"$ref":"#/components/schemas/_types:VersionNumber"}},"required":["field"]}]},"_types.query_dsl:PinnedQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-pinned-query.html"},"allOf":[{"type":"object","properties":{"organic":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["organic"]},{"type":"object","properties":{"ids":{"description":"Document IDs listed in the order they are to appear in results.\\nRequired if `docs` is not specified.","type":"array","items":{"$ref":"#/components/schemas/_types:Id"}},"docs":{"description":"Documents listed in the order they are to appear in results.\\nRequired if `ids` is not specified.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:PinnedDoc"}}},"minProperties":1,"maxProperties":1}]}]},"_types.query_dsl:PinnedDoc":{"type":"object","properties":{"_id":{"$ref":"#/components/schemas/_types:Id"},"_index":{"$ref":"#/components/schemas/_types:IndexName"}},"required":["_id","_index"]},"_types.query_dsl:PrefixQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"value":{"description":"Beginning characters of terms you wish to find in the provided field.","type":"string"},"case_insensitive":{"description":"Allows ASCII case insensitive matching of the value with the indexed field values when set to `true`.\\nDefault is `false` which means the case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"}},"required":["value"]}]},"_types.query_dsl:QueryStringQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"allow_leading_wildcard":{"description":"If `true`, the wildcard characters `*` and `?` are allowed as the first character of the query string.","type":"boolean"},"analyzer":{"description":"Analyzer used to convert text in the query string into tokens.","type":"string"},"analyze_wildcard":{"description":"If `true`, the query attempts to analyze wildcard terms in the query string.","type":"boolean"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"default_field":{"$ref":"#/components/schemas/_types:Field"},"default_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"enable_position_increments":{"description":"If `true`, enable position increments in queries constructed from a `query_string` search.","type":"boolean"},"escape":{"type":"boolean"},"fields":{"description":"Array of fields to search. Supports wildcards (`*`).","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_max_expansions":{"description":"Maximum number of terms to which the query expands for fuzzy matching.","type":"number"},"fuzzy_prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text value for a numeric field, are ignored.","type":"boolean"},"max_determinized_states":{"description":"Maximum number of automaton states required for the query.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"phrase_slop":{"description":"Maximum number of positions allowed between matching tokens for phrases.","type":"number"},"query":{"description":"Query string you wish to parse and use for search.","type":"string"},"quote_analyzer":{"description":"Analyzer used to convert quoted text in the query string into tokens.\\nFor quoted text, this parameter overrides the analyzer specified in the `analyzer` parameter.","type":"string"},"quote_field_suffix":{"description":"Suffix appended to quoted text in the query string.\\nYou can use this suffix to use a different analysis method for exact matches.","type":"string"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"tie_breaker":{"description":"How to combine the queries generated from the individual search terms in the resulting `dis_max` query.","type":"number"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"},"type":{"$ref":"#/components/schemas/_types.query_dsl:TextQueryType"}},"required":["query"]}]},"_types:TimeZone":{"type":"string"},"_types.query_dsl:RangeQuery":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-range-query.html"},"oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:UntypedRangeQuery"},{"$ref":"#/components/schemas/_types.query_dsl:DateRangeQuery"},{"$ref":"#/components/schemas/_types.query_dsl:NumberRangeQuery"},{"$ref":"#/components/schemas/_types.query_dsl:TermRangeQuery"}]},"_types.query_dsl:UntypedRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBase"},{"type":"object","properties":{"format":{"$ref":"#/components/schemas/_types:DateFormat"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"}}}]},"_types.query_dsl:RangeQueryBase":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"relation":{"$ref":"#/components/schemas/_types.query_dsl:RangeRelation"},"gt":{"description":"Greater than.","type":"object"},"gte":{"description":"Greater than or equal to.","type":"object"},"lt":{"description":"Less than.","type":"object"},"lte":{"description":"Less than or equal to.","type":"object"},"from":{"deprecated":true,"oneOf":[{"type":"object"},{"nullable":true,"type":"string"}]},"to":{"deprecated":true,"oneOf":[{"type":"object"},{"nullable":true,"type":"string"}]}}}]},"_types.query_dsl:RangeRelation":{"type":"string","enum":["within","contains","intersects"]},"_types:DateFormat":{"type":"string"},"_types.query_dsl:DateRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBaseDateMath"},{"type":"object","properties":{"format":{"$ref":"#/components/schemas/_types:DateFormat"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"}}}]},"_types.query_dsl:RangeQueryBaseDateMath":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"relation":{"$ref":"#/components/schemas/_types.query_dsl:RangeRelation"},"gt":{"$ref":"#/components/schemas/_types:DateMath"},"gte":{"$ref":"#/components/schemas/_types:DateMath"},"lt":{"$ref":"#/components/schemas/_types:DateMath"},"lte":{"$ref":"#/components/schemas/_types:DateMath"},"from":{"deprecated":true,"oneOf":[{"$ref":"#/components/schemas/_types:DateMath"},{"nullable":true,"type":"string"}]},"to":{"deprecated":true,"oneOf":[{"$ref":"#/components/schemas/_types:DateMath"},{"nullable":true,"type":"string"}]}}}]},"_types.query_dsl:NumberRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBasedouble"},{"type":"object"}]},"_types.query_dsl:RangeQueryBasedouble":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"relation":{"$ref":"#/components/schemas/_types.query_dsl:RangeRelation"},"gt":{"description":"Greater than.","type":"number"},"gte":{"description":"Greater than or equal to.","type":"number"},"lt":{"description":"Less than.","type":"number"},"lte":{"description":"Less than or equal to.","type":"number"},"from":{"deprecated":true,"oneOf":[{"type":"number"},{"nullable":true,"type":"string"}]},"to":{"deprecated":true,"oneOf":[{"type":"number"},{"nullable":true,"type":"string"}]}}}]},"_types.query_dsl:TermRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBasestring"},{"type":"object"}]},"_types.query_dsl:RangeQueryBasestring":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"relation":{"$ref":"#/components/schemas/_types.query_dsl:RangeRelation"},"gt":{"description":"Greater than.","type":"string"},"gte":{"description":"Greater than or equal to.","type":"string"},"lt":{"description":"Less than.","type":"string"},"lte":{"description":"Less than or equal to.","type":"string"},"from":{"deprecated":true,"oneOf":[{"type":"string"},{"nullable":true,"type":"string"}]},"to":{"deprecated":true,"oneOf":[{"type":"string"},{"nullable":true,"type":"string"}]}}}]},"_types.query_dsl:RankFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"saturation":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionSaturation"},"log":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionLogarithm"},"linear":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionLinear"},"sigmoid":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionSigmoid"}},"required":["field"]}]},"_types.query_dsl:RankFeatureFunctionSaturation":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object","properties":{"pivot":{"description":"Configurable pivot value so that the result will be less than 0.5.","type":"number"}}}]},"_types.query_dsl:RankFeatureFunction":{"type":"object"},"_types.query_dsl:RankFeatureFunctionLogarithm":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object","properties":{"scaling_factor":{"description":"Configurable scaling factor.","type":"number"}},"required":["scaling_factor"]}]},"_types.query_dsl:RankFeatureFunctionLinear":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object"}]},"_types.query_dsl:RankFeatureFunctionSigmoid":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object","properties":{"pivot":{"description":"Configurable pivot value so that the result will be less than 0.5.","type":"number"},"exponent":{"description":"Configurable Exponent.","type":"number"}},"required":["pivot","exponent"]}]},"_types.query_dsl:RegexpQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"case_insensitive":{"description":"Allows case insensitive matching of the regular expression value with the indexed field values when set to `true`.\\nWhen `false`, case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"},"flags":{"description":"Enables optional operators for the regular expression.","type":"string"},"max_determinized_states":{"description":"Maximum number of automaton states required for the query.","type":"number"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"value":{"description":"Regular expression for terms you wish to find in the provided field.","type":"string"}},"required":["value"]}]},"_types.query_dsl:RuleQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"organic":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"ruleset_ids":{"type":"array","items":{"$ref":"#/components/schemas/_types:Id"}},"match_criteria":{"type":"object"}},"required":["organic","ruleset_ids","match_criteria"]}]},"_types.query_dsl:ScriptQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["script"]}]},"_types.query_dsl:ScriptScoreQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"min_score":{"description":"Documents with a score lower than this floating point number are excluded from the search results.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["query","script"]}]},"_types.query_dsl:SemanticQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"description":"The field to query, which must be a semantic_text field type","type":"string"},"query":{"description":"The query text","type":"string"}},"required":["field","query"]}]},"_types.query_dsl:ShapeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"When set to `true` the query ignores an unmapped field and will not match any documents.","type":"boolean"}}}]},"_types.query_dsl:SimpleQueryStringQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"description":"Analyzer used to convert text in the query string into tokens.","type":"string"},"analyze_wildcard":{"description":"If `true`, the query attempts to analyze wildcard terms in the query string.","type":"boolean"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, the parser creates a match_phrase query for each multi-position token.","type":"boolean"},"default_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"fields":{"description":"Array of fields you wish to search.\\nAccepts wildcard expressions.\\nYou also can boost relevance scores for matches to particular fields using a caret (`^`) notation.\\nDefaults to the `index.query.default_field index` setting, which has a default value of `*`.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"flags":{"$ref":"#/components/schemas/_types.query_dsl:SimpleQueryStringFlags"},"fuzzy_max_expansions":{"description":"Maximum number of terms to which the query expands for fuzzy matching.","type":"number"},"fuzzy_prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text value for a numeric field, are ignored.","type":"boolean"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"query":{"description":"Query string in the simple query string syntax you wish to parse and use for search.","type":"string"},"quote_field_suffix":{"description":"Suffix appended to quoted text in the query string.","type":"string"}},"required":["query"]}]},"_types.query_dsl:SimpleQueryStringFlags":{"description":"Query flags can be either a single flag or a combination of flags, e.g. `OR|AND|PREFIX`","allOf":[{"$ref":"#/components/schemas/_spec_utils:PipeSeparatedFlagsSimpleQueryStringFlag"}]},"_spec_utils:PipeSeparatedFlagsSimpleQueryStringFlag":{"description":"A set of flags that can be represented as a single enum value or a set of values that are encoded\\nas a pipe-separated string\\n\\nDepending on the target language, code generators can use this hint to generate language specific\\nflags enum constructs and the corresponding (de-)serialization code.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:SimpleQueryStringFlag"},{"type":"string"}]},"_types.query_dsl:SimpleQueryStringFlag":{"type":"string","enum":["NONE","AND","NOT","OR","PREFIX","PHRASE","PRECEDENCE","ESCAPE","WHITESPACE","FUZZY","NEAR","SLOP","ALL"]},"_types.query_dsl:SpanContainingQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"big":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"little":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["big","little"]}]},"_types.query_dsl:SpanQuery":{"type":"object","properties":{"span_containing":{"$ref":"#/components/schemas/_types.query_dsl:SpanContainingQuery"},"span_field_masking":{"$ref":"#/components/schemas/_types.query_dsl:SpanFieldMaskingQuery"},"span_first":{"$ref":"#/components/schemas/_types.query_dsl:SpanFirstQuery"},"span_gap":{"$ref":"#/components/schemas/_types.query_dsl:SpanGapQuery"},"span_multi":{"$ref":"#/components/schemas/_types.query_dsl:SpanMultiTermQuery"},"span_near":{"$ref":"#/components/schemas/_types.query_dsl:SpanNearQuery"},"span_not":{"$ref":"#/components/schemas/_types.query_dsl:SpanNotQuery"},"span_or":{"$ref":"#/components/schemas/_types.query_dsl:SpanOrQuery"},"span_term":{"description":"The equivalent of the `term` query but for use with other span queries.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:SpanTermQuery"},"minProperties":1,"maxProperties":1},"span_within":{"$ref":"#/components/schemas/_types.query_dsl:SpanWithinQuery"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:SpanFieldMaskingQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"query":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["field","query"]}]},"_types.query_dsl:SpanFirstQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"end":{"description":"Controls the maximum end position permitted in a match.","type":"number"},"match":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["end","match"]}]},"_types.query_dsl:SpanGapQuery":{"description":"Can only be used as a clause in a span_near query.","type":"object","additionalProperties":{"type":"number"},"minProperties":1,"maxProperties":1},"_types.query_dsl:SpanMultiTermQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"match":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["match"]}]},"_types.query_dsl:SpanNearQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"clauses":{"description":"Array of one or more other span type queries.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"in_order":{"description":"Controls whether matches are required to be in-order.","type":"boolean"},"slop":{"description":"Controls the maximum number of intervening unmatched positions permitted.","type":"number"}},"required":["clauses"]}]},"_types.query_dsl:SpanNotQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"dist":{"description":"The number of tokens from within the include span that can’t have overlap with the exclude span.\\nEquivalent to setting both `pre` and `post`.","type":"number"},"exclude":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"include":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"post":{"description":"The number of tokens after the include span that can’t have overlap with the exclude span.","type":"number"},"pre":{"description":"The number of tokens before the include span that can’t have overlap with the exclude span.","type":"number"}},"required":["exclude","include"]}]},"_types.query_dsl:SpanOrQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"clauses":{"description":"Array of one or more other span type queries.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}}},"required":["clauses"]}]},"_types.query_dsl:SpanTermQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"value":{"type":"string"}},"required":["value"]}]},"_types.query_dsl:SpanWithinQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"big":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"little":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["big","little"]}]},"_types.query_dsl:SparseVectorQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-sparse-vector-query.html"},"allOf":[{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"query":{"description":"The query text you want to use for search.\\nIf inference_id is specified, query must also be specified.","type":"string"},"prune":{"description":"Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.\\nIf prune is true but the pruning_config is not specified, pruning will occur but default values will be used.\\nDefault: false","x-state":"Technical preview","type":"boolean"},"pruning_config":{"$ref":"#/components/schemas/_types.query_dsl:TokenPruningConfig"}},"required":["field"]},{"type":"object","properties":{"query_vector":{"description":"Dictionary of precomputed sparse vectors and their associated weights.\\nOnly one of inference_id or query_vector may be supplied in a request.","type":"object","additionalProperties":{"type":"number"}},"inference_id":{"$ref":"#/components/schemas/_types:Id"}},"minProperties":1,"maxProperties":1}]}]},"_types.query_dsl:TokenPruningConfig":{"type":"object","properties":{"tokens_freq_ratio_threshold":{"description":"Tokens whose frequency is more than this threshold times the average frequency of all tokens in the specified field are considered outliers and pruned.","type":"number"},"tokens_weight_threshold":{"description":"Tokens whose weight is less than this threshold are considered nonsignificant and pruned.","type":"number"},"only_score_pruned_tokens":{"description":"Whether to only score pruned tokens, vs only scoring kept tokens.","type":"boolean"}}},"_types.query_dsl:TermQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"value":{"$ref":"#/components/schemas/_types:FieldValue"},"case_insensitive":{"description":"Allows ASCII case insensitive matching of the value with the indexed field values when set to `true`.\\nWhen `false`, the case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"}},"required":["value"]}]},"_types:FieldValue":{"description":"A field value.","oneOf":[{"type":"number"},{"type":"number"},{"type":"string"},{"type":"boolean"},{"nullable":true,"type":"string"},{"type":"object"}]},"_types.query_dsl:TermsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object"}]},"_types.query_dsl:TermsSetQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"minimum_should_match_field":{"$ref":"#/components/schemas/_types:Field"},"minimum_should_match_script":{"$ref":"#/components/schemas/_types:Script"},"terms":{"description":"Array of terms you wish to find in the provided field.","type":"array","items":{"$ref":"#/components/schemas/_types:FieldValue"}}},"required":["terms"]}]},"_types.query_dsl:TextExpansionQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"model_id":{"description":"The text expansion NLP model to use","type":"string"},"model_text":{"description":"The query text","type":"string"},"pruning_config":{"$ref":"#/components/schemas/_types.query_dsl:TokenPruningConfig"}},"required":["model_id","model_text"]}]},"_types.query_dsl:WeightedTokensQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"tokens":{"description":"The tokens representing this query","type":"object","additionalProperties":{"type":"number"}},"pruning_config":{"$ref":"#/components/schemas/_types.query_dsl:TokenPruningConfig"}},"required":["tokens"]}]},"_types.query_dsl:WildcardQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"case_insensitive":{"description":"Allows case insensitive matching of the pattern with the indexed field values when set to true. Default is false which means the case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"value":{"description":"Wildcard pattern for terms you wish to find in the provided field. Required, when wildcard is not set.","type":"string"},"wildcard":{"description":"Wildcard pattern for terms you wish to find in the provided field. Required, when value is not set.","type":"string"}}}]},"_types.query_dsl:WrapperQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"query":{"description":"A base64 encoded query.\\nThe binary data format can be any of JSON, YAML, CBOR or SMILE encodings","type":"string"}},"required":["query"]}]},"_types.query_dsl:TypeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"value":{"type":"string"}},"required":["value"]}]},"_types.aggregations:AutoDateHistogramAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"buckets":{"description":"The target number of buckets.","type":"number"},"field":{"$ref":"#/components/schemas/_types:Field"},"format":{"description":"The date format used to format `key_as_string` in the response.\\nIf no `format` is specified, the first date format specified in the field mapping is used.","type":"string"},"minimum_interval":{"$ref":"#/components/schemas/_types.aggregations:MinimumInterval"},"missing":{"$ref":"#/components/schemas/_types:DateTime"},"offset":{"description":"Time zone specified as a ISO 8601 UTC offset.","type":"string"},"params":{"type":"object","additionalProperties":{"type":"object"}},"script":{"$ref":"#/components/schemas/_types:Script"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"}}}]},"_types.aggregations:MinimumInterval":{"type":"string","enum":["second","minute","hour","day","month","year"]},"_types:DateTime":{"description":"A date and time, either as a string whose format can depend on the context (defaulting to ISO 8601), or a\\nnumber of milliseconds since the Epoch. Elasticsearch accepts both as input, but will generally output a string\\nrepresentation.","oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types:EpochTimeUnitMillis"}]},"_types:EpochTimeUnitMillis":{"allOf":[{"$ref":"#/components/schemas/_types:UnitMillis"}]},"_types:UnitMillis":{"description":"Time unit for milliseconds","type":"number"},"_types.aggregations:AverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object"}]},"_types.aggregations:FormatMetricAggregationBase":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"format":{"type":"string"}}}]},"_types.aggregations:MetricAggregationBase":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"missing":{"$ref":"#/components/schemas/_types.aggregations:Missing"},"script":{"$ref":"#/components/schemas/_types:Script"}}},"_types.aggregations:Missing":{"oneOf":[{"type":"string"},{"type":"number"},{"type":"number"},{"type":"boolean"}]},"_types.aggregations:AverageBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:PipelineAggregationBase":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketPathAggregation"},{"type":"object","properties":{"format":{"description":"`DecimalFormat` pattern for the output value.\\nIf specified, the formatted value is returned in the aggregation’s `value_as_string` property.","type":"string"},"gap_policy":{"$ref":"#/components/schemas/_types.aggregations:GapPolicy"}}}]},"_types.aggregations:BucketPathAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object","properties":{"buckets_path":{"$ref":"#/components/schemas/_types.aggregations:BucketsPath"}}}]},"_types.aggregations:BucketsPath":{"description":"Buckets path can be expressed in different ways, and an aggregation may accept some or all of these\\nforms depending on its type. Please refer to each aggregation\'s documentation to know what buckets\\npath forms they accept.","oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"type":"object","additionalProperties":{"type":"string"}}]},"_types.aggregations:GapPolicy":{"type":"string","enum":["skip","insert_zeros","keep_values"]},"_types.aggregations:BoxplotAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"compression":{"description":"Limits the maximum number of nodes used by the underlying TDigest algorithm to `20 * compression`, enabling control of memory usage and approximation error.","type":"number"}}}]},"_types.aggregations:BucketScriptAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}}}]},"_types.aggregations:BucketSelectorAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}}}]},"_types.aggregations:BucketSortAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object","properties":{"from":{"description":"Buckets in positions prior to `from` will be truncated.","type":"number"},"gap_policy":{"$ref":"#/components/schemas/_types.aggregations:GapPolicy"},"size":{"description":"The number of buckets to return.\\nDefaults to all buckets of the parent aggregation.","type":"number"},"sort":{"$ref":"#/components/schemas/_types:Sort"}}}]},"_types.aggregations:BucketKsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketPathAggregation"},{"type":"object","properties":{"alternative":{"description":"A list of string values indicating which K-S test alternative to calculate. The valid values\\nare: \\"greater\\", \\"less\\", \\"two_sided\\". This parameter is key for determining the K-S statistic used\\nwhen calculating the K-S test. Default value is all possible alternative hypotheses.","type":"array","items":{"type":"string"}},"fractions":{"description":"A list of doubles indicating the distribution of the samples with which to compare to the `buckets_path` results.\\nIn typical usage this is the overall proportion of documents in each bucket, which is compared with the actual\\ndocument proportions in each bucket from the sibling aggregation counts. The default is to assume that overall\\ndocuments are uniformly distributed on these buckets, which they would be if one used equal percentiles of a\\nmetric to define the bucket end points.","type":"array","items":{"type":"number"}},"sampling_method":{"description":"Indicates the sampling methodology when calculating the K-S test. Note, this is sampling of the returned values.\\nThis determines the cumulative distribution function (CDF) points used comparing the two samples. Default is\\n`upper_tail`, which emphasizes the upper end of the CDF points. Valid options are: `upper_tail`, `uniform`,\\nand `lower_tail`.","type":"string"}}}]},"_types.aggregations:BucketCorrelationAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketPathAggregation"},{"type":"object","properties":{"function":{"$ref":"#/components/schemas/_types.aggregations:BucketCorrelationFunction"}},"required":["function"]}]},"_types.aggregations:BucketCorrelationFunction":{"type":"object","properties":{"count_correlation":{"$ref":"#/components/schemas/_types.aggregations:BucketCorrelationFunctionCountCorrelation"}},"required":["count_correlation"]},"_types.aggregations:BucketCorrelationFunctionCountCorrelation":{"type":"object","properties":{"indicator":{"$ref":"#/components/schemas/_types.aggregations:BucketCorrelationFunctionCountCorrelationIndicator"}},"required":["indicator"]},"_types.aggregations:BucketCorrelationFunctionCountCorrelationIndicator":{"type":"object","properties":{"doc_count":{"description":"The total number of documents that initially created the expectations. It’s required to be greater\\nthan or equal to the sum of all values in the buckets_path as this is the originating superset of data\\nto which the term values are correlated.","type":"number"},"expectations":{"description":"An array of numbers with which to correlate the configured `bucket_path` values.\\nThe length of this value must always equal the number of buckets returned by the `bucket_path`.","type":"array","items":{"type":"number"}},"fractions":{"description":"An array of fractions to use when averaging and calculating variance. This should be used if\\nthe pre-calculated data and the buckets_path have known gaps. The length of fractions, if provided,\\nmust equal expectations.","type":"array","items":{"type":"number"}}},"required":["doc_count","expectations"]},"_types.aggregations:CardinalityAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"precision_threshold":{"description":"A unique count below which counts are expected to be close to accurate.\\nThis allows to trade memory for accuracy.","type":"number"},"rehash":{"type":"boolean"},"execution_hint":{"$ref":"#/components/schemas/_types.aggregations:CardinalityExecutionMode"}}}]},"_types.aggregations:CardinalityExecutionMode":{"type":"string","enum":["global_ordinals","segment_ordinals","direct","save_memory_heuristic","save_time_heuristic"]},"_types.aggregations:CategorizeTextAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"max_unique_tokens":{"description":"The maximum number of unique tokens at any position up to max_matched_tokens. Must be larger than 1.\\nSmaller values use less memory and create fewer categories. Larger values will use more memory and\\ncreate narrower categories. Max allowed value is 100.","type":"number"},"max_matched_tokens":{"description":"The maximum number of token positions to match on before attempting to merge categories. Larger\\nvalues will use more memory and create narrower categories. Max allowed value is 100.","type":"number"},"similarity_threshold":{"description":"The minimum percentage of tokens that must match for text to be added to the category bucket. Must\\nbe between 1 and 100. The larger the value the narrower the categories. Larger values will increase memory\\nusage and create narrower categories.","type":"number"},"categorization_filters":{"description":"This property expects an array of regular expressions. The expressions are used to filter out matching\\nsequences from the categorization field values. You can use this functionality to fine tune the categorization\\nby excluding sequences from consideration when categories are defined. For example, you can exclude SQL\\nstatements that appear in your log files. This property cannot be used at the same time as categorization_analyzer.\\nIf you only want to define simple regular expression filters that are applied prior to tokenization, setting\\nthis property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering,\\nuse the categorization_analyzer property instead and include the filters as pattern_replace character filters.","type":"array","items":{"type":"string"}},"categorization_analyzer":{"$ref":"#/components/schemas/_types.aggregations:CategorizeTextAnalyzer"},"shard_size":{"description":"The number of categorization buckets to return from each shard before merging all the results.","type":"number"},"size":{"description":"The number of buckets to return.","type":"number"},"min_doc_count":{"description":"The minimum number of documents in a bucket to be returned to the results.","type":"number"},"shard_min_doc_count":{"description":"The minimum number of documents in a bucket to be returned from the shard before merging.","type":"number"}},"required":["field"]}]},"_types.aggregations:CategorizeTextAnalyzer":{"oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types.aggregations:CustomCategorizeTextAnalyzer"}]},"_types.aggregations:CustomCategorizeTextAnalyzer":{"type":"object","properties":{"char_filter":{"type":"array","items":{"type":"string"}},"tokenizer":{"type":"string"},"filter":{"type":"array","items":{"type":"string"}}}},"_types.aggregations:ChildrenAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_types:RelationName"}}}]},"_types.aggregations:CompositeAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"after":{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregateKey"},"size":{"description":"The number of composite buckets that should be returned.","type":"number"},"sources":{"description":"The value sources used to build composite buckets.\\nKeys are returned in the order of the `sources` definition.","type":"array","items":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregationSource"}}}}}]},"_types.aggregations:CompositeAggregateKey":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:FieldValue"}},"_types.aggregations:CompositeAggregationSource":{"type":"object","properties":{"terms":{"$ref":"#/components/schemas/_types.aggregations:CompositeTermsAggregation"},"histogram":{"$ref":"#/components/schemas/_types.aggregations:CompositeHistogramAggregation"},"date_histogram":{"$ref":"#/components/schemas/_types.aggregations:CompositeDateHistogramAggregation"},"geotile_grid":{"$ref":"#/components/schemas/_types.aggregations:CompositeGeoTileGridAggregation"}}},"_types.aggregations:CompositeTermsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregationBase"},{"type":"object"}]},"_types.aggregations:CompositeAggregationBase":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"missing_bucket":{"type":"boolean"},"missing_order":{"$ref":"#/components/schemas/_types.aggregations:MissingOrder"},"script":{"$ref":"#/components/schemas/_types:Script"},"value_type":{"$ref":"#/components/schemas/_types.aggregations:ValueType"},"order":{"$ref":"#/components/schemas/_types:SortOrder"}}},"_types.aggregations:MissingOrder":{"type":"string","enum":["first","last","default"]},"_types.aggregations:ValueType":{"type":"string","enum":["string","long","double","number","date","date_nanos","ip","numeric","geo_point","boolean"]},"_types.aggregations:CompositeHistogramAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregationBase"},{"type":"object","properties":{"interval":{"type":"number"}},"required":["interval"]}]},"_types.aggregations:CompositeDateHistogramAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregationBase"},{"type":"object","properties":{"format":{"type":"string"},"calendar_interval":{"$ref":"#/components/schemas/_types:DurationLarge"},"fixed_interval":{"$ref":"#/components/schemas/_types:DurationLarge"},"offset":{"$ref":"#/components/schemas/_types:Duration"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"}}}]},"_types:DurationLarge":{"description":"A date histogram interval. Similar to `Duration` with additional units: `w` (week), `M` (month), `q` (quarter) and\\n`y` (year)","type":"string"},"_types.aggregations:CompositeGeoTileGridAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:CompositeAggregationBase"},{"type":"object","properties":{"precision":{"type":"number"},"bounds":{"$ref":"#/components/schemas/_types:GeoBounds"}}}]},"_types:GeoBounds":{"description":"A geo bounding box. It can be represented in various ways:\\n- as 4 top/bottom/left/right coordinates\\n- as 2 top_left / bottom_right points\\n- as 2 top_right / bottom_left points\\n- as a WKT bounding box","oneOf":[{"$ref":"#/components/schemas/_types:CoordsGeoBounds"},{"$ref":"#/components/schemas/_types:TopLeftBottomRightGeoBounds"},{"$ref":"#/components/schemas/_types:TopRightBottomLeftGeoBounds"},{"$ref":"#/components/schemas/_types:WktGeoBounds"}]},"_types:CoordsGeoBounds":{"type":"object","properties":{"top":{"type":"number"},"bottom":{"type":"number"},"left":{"type":"number"},"right":{"type":"number"}},"required":["top","bottom","left","right"]},"_types:TopLeftBottomRightGeoBounds":{"type":"object","properties":{"top_left":{"$ref":"#/components/schemas/_types:GeoLocation"},"bottom_right":{"$ref":"#/components/schemas/_types:GeoLocation"}},"required":["top_left","bottom_right"]},"_types:TopRightBottomLeftGeoBounds":{"type":"object","properties":{"top_right":{"$ref":"#/components/schemas/_types:GeoLocation"},"bottom_left":{"$ref":"#/components/schemas/_types:GeoLocation"}},"required":["top_right","bottom_left"]},"_types:WktGeoBounds":{"type":"object","properties":{"wkt":{"type":"string"}},"required":["wkt"]},"_types.aggregations:CumulativeCardinalityAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:CumulativeSumAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:DateHistogramAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"calendar_interval":{"$ref":"#/components/schemas/_types.aggregations:CalendarInterval"},"extended_bounds":{"$ref":"#/components/schemas/_types.aggregations:ExtendedBoundsFieldDateMath"},"hard_bounds":{"$ref":"#/components/schemas/_types.aggregations:ExtendedBoundsFieldDateMath"},"field":{"$ref":"#/components/schemas/_types:Field"},"fixed_interval":{"$ref":"#/components/schemas/_types:Duration"},"format":{"description":"The date format used to format `key_as_string` in the response.\\nIf no `format` is specified, the first date format specified in the field mapping is used.","type":"string"},"interval":{"$ref":"#/components/schemas/_types:Duration"},"min_doc_count":{"description":"Only returns buckets that have `min_doc_count` number of documents.\\nBy default, all buckets between the first bucket that matches documents and the last one are returned.","type":"number"},"missing":{"$ref":"#/components/schemas/_types:DateTime"},"offset":{"$ref":"#/components/schemas/_types:Duration"},"order":{"$ref":"#/components/schemas/_types.aggregations:AggregateOrder"},"params":{"type":"object","additionalProperties":{"type":"object"}},"script":{"$ref":"#/components/schemas/_types:Script"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"},"keyed":{"description":"Set to `true` to associate a unique string key with each bucket and return the ranges as a hash rather than an array.","type":"boolean"}}}]},"_types.aggregations:CalendarInterval":{"type":"string","enum":["second","1s","minute","1m","hour","1h","day","1d","week","1w","month","1M","quarter","1q","year","1y"]},"_types.aggregations:ExtendedBoundsFieldDateMath":{"type":"object","properties":{"max":{"$ref":"#/components/schemas/_types.aggregations:FieldDateMath"},"min":{"$ref":"#/components/schemas/_types.aggregations:FieldDateMath"}}},"_types.aggregations:FieldDateMath":{"description":"A date range limit, represented either as a DateMath expression or a number expressed\\naccording to the target field\'s precision.","oneOf":[{"$ref":"#/components/schemas/_types:DateMath"},{"type":"number"}]},"_types.aggregations:AggregateOrder":{"oneOf":[{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:SortOrder"},"minProperties":1,"maxProperties":1},{"type":"array","items":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:SortOrder"},"minProperties":1,"maxProperties":1}}]},"_types.aggregations:DateRangeAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"format":{"description":"The date format used to format `from` and `to` in the response.","type":"string"},"missing":{"$ref":"#/components/schemas/_types.aggregations:Missing"},"ranges":{"description":"Array of date ranges.","type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:DateRangeExpression"}},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"},"keyed":{"description":"Set to `true` to associate a unique string key with each bucket and returns the ranges as a hash rather than an array.","type":"boolean"}}}]},"_types.aggregations:DateRangeExpression":{"type":"object","properties":{"from":{"$ref":"#/components/schemas/_types.aggregations:FieldDateMath"},"key":{"description":"Custom key to return the range with.","type":"string"},"to":{"$ref":"#/components/schemas/_types.aggregations:FieldDateMath"}}},"_types.aggregations:DerivativeAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:DiversifiedSamplerAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"execution_hint":{"$ref":"#/components/schemas/_types.aggregations:SamplerAggregationExecutionHint"},"max_docs_per_value":{"description":"Limits how many documents are permitted per choice of de-duplicating value.","type":"number"},"script":{"$ref":"#/components/schemas/_types:Script"},"shard_size":{"description":"Limits how many top-scoring documents are collected in the sample processed on each shard.","type":"number"},"field":{"$ref":"#/components/schemas/_types:Field"}}}]},"_types.aggregations:SamplerAggregationExecutionHint":{"type":"string","enum":["map","global_ordinals","bytes_hash"]},"_types.aggregations:ExtendedStatsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object","properties":{"sigma":{"description":"The number of standard deviations above/below the mean to display.","type":"number"}}}]},"_types.aggregations:ExtendedStatsBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"sigma":{"description":"The number of standard deviations above/below the mean to display.","type":"number"}}}]},"_types.aggregations:FrequentItemSetsAggregation":{"type":"object","properties":{"fields":{"description":"Fields to analyze.","type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:FrequentItemSetsField"}},"minimum_set_size":{"description":"The minimum size of one item set.","type":"number"},"minimum_support":{"description":"The minimum support of one item set.","type":"number"},"size":{"description":"The number of top item sets to return.","type":"number"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["fields"]},"_types.aggregations:FrequentItemSetsField":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"exclude":{"$ref":"#/components/schemas/_types.aggregations:TermsExclude"},"include":{"$ref":"#/components/schemas/_types.aggregations:TermsInclude"}},"required":["field"]},"_types.aggregations:TermsExclude":{"oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},"_types.aggregations:TermsInclude":{"oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"$ref":"#/components/schemas/_types.aggregations:TermsPartition"}]},"_types.aggregations:TermsPartition":{"type":"object","properties":{"num_partitions":{"description":"The number of partitions.","type":"number"},"partition":{"description":"The partition number for this request.","type":"number"}},"required":["num_partitions","partition"]},"_types.aggregations:FiltersAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"filters":{"$ref":"#/components/schemas/_types.aggregations:BucketsQueryContainer"},"other_bucket":{"description":"Set to `true` to add a bucket to the response which will contain all documents that do not match any of the given filters.","type":"boolean"},"other_bucket_key":{"description":"The key with which the other bucket is returned.","type":"string"},"keyed":{"description":"By default, the named filters aggregation returns the buckets as an object.\\nSet to `false` to return the buckets as an array of objects.","type":"boolean"}}}]},"_types.aggregations:BucketsQueryContainer":{"description":"Aggregation buckets. By default they are returned as an array, but if the aggregation has keys configured for\\nthe different buckets, the result is a dictionary.","oneOf":[{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"_types.aggregations:GeoBoundsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"wrap_longitude":{"description":"Specifies whether the bounding box should be allowed to overlap the international date line.","type":"boolean"}}}]},"_types.aggregations:GeoCentroidAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"count":{"type":"number"},"location":{"$ref":"#/components/schemas/_types:GeoLocation"}}}]},"_types.aggregations:GeoDistanceAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"distance_type":{"$ref":"#/components/schemas/_types:GeoDistanceType"},"field":{"$ref":"#/components/schemas/_types:Field"},"origin":{"$ref":"#/components/schemas/_types:GeoLocation"},"ranges":{"description":"An array of ranges used to bucket documents.","type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:AggregationRange"}},"unit":{"$ref":"#/components/schemas/_types:DistanceUnit"}}}]},"_types.aggregations:AggregationRange":{"type":"object","properties":{"from":{"description":"Start of the range (inclusive).","oneOf":[{"type":"number"},{"nullable":true,"type":"string"}]},"key":{"description":"Custom key to return the range with.","type":"string"},"to":{"description":"End of the range (exclusive).","oneOf":[{"type":"number"},{"nullable":true,"type":"string"}]}}},"_types.aggregations:GeoHashGridAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"bounds":{"$ref":"#/components/schemas/_types:GeoBounds"},"field":{"$ref":"#/components/schemas/_types:Field"},"precision":{"$ref":"#/components/schemas/_types:GeoHashPrecision"},"shard_size":{"description":"Allows for more accurate counting of the top cells returned in the final result the aggregation.\\nDefaults to returning `max(10,(size x number-of-shards))` buckets from each shard.","type":"number"},"size":{"description":"The maximum number of geohash buckets to return.","type":"number"}}}]},"_types:GeoHashPrecision":{"description":"A precision that can be expressed as a geohash length between 1 and 12, or a distance measure like \\"1km\\", \\"10m\\".","oneOf":[{"type":"number"},{"type":"string"}]},"_types.aggregations:GeoLineAggregation":{"type":"object","properties":{"point":{"$ref":"#/components/schemas/_types.aggregations:GeoLinePoint"},"sort":{"$ref":"#/components/schemas/_types.aggregations:GeoLineSort"},"include_sort":{"description":"When `true`, returns an additional array of the sort values in the feature properties.","type":"boolean"},"sort_order":{"$ref":"#/components/schemas/_types:SortOrder"},"size":{"description":"The maximum length of the line represented in the aggregation.\\nValid sizes are between 1 and 10000.","type":"number"}},"required":["point","sort"]},"_types.aggregations:GeoLinePoint":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["field"]},"_types.aggregations:GeoLineSort":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["field"]},"_types.aggregations:GeoTileGridAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"precision":{"$ref":"#/components/schemas/_types:GeoTilePrecision"},"shard_size":{"description":"Allows for more accurate counting of the top cells returned in the final result the aggregation.\\nDefaults to returning `max(10,(size x number-of-shards))` buckets from each shard.","type":"number"},"size":{"description":"The maximum number of buckets to return.","type":"number"},"bounds":{"$ref":"#/components/schemas/_types:GeoBounds"}}}]},"_types:GeoTilePrecision":{"type":"number"},"_types.aggregations:GeohexGridAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"precision":{"description":"Integer zoom of the key used to defined cells or buckets\\nin the results. Value should be between 0-15.","type":"number"},"bounds":{"$ref":"#/components/schemas/_types:GeoBounds"},"size":{"description":"Maximum number of buckets to return.","type":"number"},"shard_size":{"description":"Number of buckets returned from each shard.","type":"number"}},"required":["field"]}]},"_types.aggregations:GlobalAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object"}]},"_types.aggregations:HistogramAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"extended_bounds":{"$ref":"#/components/schemas/_types.aggregations:ExtendedBoundsdouble"},"hard_bounds":{"$ref":"#/components/schemas/_types.aggregations:ExtendedBoundsdouble"},"field":{"$ref":"#/components/schemas/_types:Field"},"interval":{"description":"The interval for the buckets.\\nMust be a positive decimal.","type":"number"},"min_doc_count":{"description":"Only returns buckets that have `min_doc_count` number of documents.\\nBy default, the response will fill gaps in the histogram with empty buckets.","type":"number"},"missing":{"description":"The value to apply to documents that do not have a value.\\nBy default, documents without a value are ignored.","type":"number"},"offset":{"description":"By default, the bucket keys start with 0 and then continue in even spaced steps of `interval`.\\nThe bucket boundaries can be shifted by using the `offset` option.","type":"number"},"order":{"$ref":"#/components/schemas/_types.aggregations:AggregateOrder"},"script":{"$ref":"#/components/schemas/_types:Script"},"format":{"type":"string"},"keyed":{"description":"If `true`, returns buckets as a hash instead of an array, keyed by the bucket keys.","type":"boolean"}}}]},"_types.aggregations:ExtendedBoundsdouble":{"type":"object","properties":{"max":{"description":"Maximum value for the bound.","type":"number"},"min":{"description":"Minimum value for the bound.","type":"number"}}},"_types.aggregations:IpRangeAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"ranges":{"description":"Array of IP ranges.","type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:IpRangeAggregationRange"}}}}]},"_types.aggregations:IpRangeAggregationRange":{"type":"object","properties":{"from":{"description":"Start of the range.","oneOf":[{"type":"string"},{"nullable":true,"type":"string"}]},"mask":{"description":"IP range defined as a CIDR mask.","type":"string"},"to":{"description":"End of the range.","oneOf":[{"type":"string"},{"nullable":true,"type":"string"}]}}},"_types.aggregations:IpPrefixAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"prefix_length":{"description":"Length of the network prefix. For IPv4 addresses the accepted range is [0, 32].\\nFor IPv6 addresses the accepted range is [0, 128].","type":"number"},"is_ipv6":{"description":"Defines whether the prefix applies to IPv6 addresses.","type":"boolean"},"append_prefix_length":{"description":"Defines whether the prefix length is appended to IP address keys in the response.","type":"boolean"},"keyed":{"description":"Defines whether buckets are returned as a hash rather than an array in the response.","type":"boolean"},"min_doc_count":{"description":"Minimum number of documents in a bucket for it to be included in the response.","type":"number"}},"required":["field","prefix_length"]}]},"_types.aggregations:InferenceAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"model_id":{"$ref":"#/components/schemas/_types:Name"},"inference_config":{"$ref":"#/components/schemas/_types.aggregations:InferenceConfigContainer"}},"required":["model_id"]}]},"_types.aggregations:InferenceConfigContainer":{"type":"object","properties":{"regression":{"$ref":"#/components/schemas/ml._types:RegressionInferenceOptions"},"classification":{"$ref":"#/components/schemas/ml._types:ClassificationInferenceOptions"}},"minProperties":1,"maxProperties":1},"ml._types:RegressionInferenceOptions":{"type":"object","properties":{"results_field":{"$ref":"#/components/schemas/_types:Field"},"num_top_feature_importance_values":{"description":"Specifies the maximum number of feature importance values per document.","type":"number"}}},"ml._types:ClassificationInferenceOptions":{"type":"object","properties":{"num_top_classes":{"description":"Specifies the number of top class predictions to return. Defaults to 0.","type":"number"},"num_top_feature_importance_values":{"description":"Specifies the maximum number of feature importance values per document.","type":"number"},"prediction_field_type":{"description":"Specifies the type of the predicted field to write. Acceptable values are: string, number, boolean. When boolean is provided 1.0 is transformed to true and 0.0 to false.","type":"string"},"results_field":{"description":"The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.","type":"string"},"top_classes_results_field":{"description":"Specifies the field to which the top classes are written. Defaults to top_classes.","type":"string"}}},"_types.aggregations:MatrixStatsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MatrixAggregation"},{"type":"object","properties":{"mode":{"$ref":"#/components/schemas/_types:SortMode"}}}]},"_types.aggregations:MatrixAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object","properties":{"fields":{"$ref":"#/components/schemas/_types:Fields"},"missing":{"description":"The value to apply to documents that do not have a value.\\nBy default, documents without a value are ignored.","type":"object","additionalProperties":{"type":"number"}}}}]},"_types.aggregations:MaxAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object"}]},"_types.aggregations:MaxBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:MedianAbsoluteDeviationAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object","properties":{"compression":{"description":"Limits the maximum number of nodes used by the underlying TDigest algorithm to `20 * compression`, enabling control of memory usage and approximation error.","type":"number"}}}]},"_types.aggregations:MinAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object"}]},"_types.aggregations:MinBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:MissingAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"missing":{"$ref":"#/components/schemas/_types.aggregations:Missing"}}}]},"_types.aggregations:MovingAverageAggregation":{"discriminator":{"propertyName":"model"},"oneOf":[{"$ref":"#/components/schemas/_types.aggregations:LinearMovingAverageAggregation"},{"$ref":"#/components/schemas/_types.aggregations:SimpleMovingAverageAggregation"},{"$ref":"#/components/schemas/_types.aggregations:EwmaMovingAverageAggregation"},{"$ref":"#/components/schemas/_types.aggregations:HoltMovingAverageAggregation"},{"$ref":"#/components/schemas/_types.aggregations:HoltWintersMovingAverageAggregation"}]},"_types.aggregations:LinearMovingAverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MovingAverageAggregationBase"},{"type":"object","properties":{"model":{"type":"string","enum":["linear"]},"settings":{"$ref":"#/components/schemas/_types:EmptyObject"}},"required":["model","settings"]}]},"_types.aggregations:MovingAverageAggregationBase":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"minimize":{"type":"boolean"},"predict":{"type":"number"},"window":{"type":"number"}}}]},"_types:EmptyObject":{"type":"object"},"_types.aggregations:SimpleMovingAverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MovingAverageAggregationBase"},{"type":"object","properties":{"model":{"type":"string","enum":["simple"]},"settings":{"$ref":"#/components/schemas/_types:EmptyObject"}},"required":["model","settings"]}]},"_types.aggregations:EwmaMovingAverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MovingAverageAggregationBase"},{"type":"object","properties":{"model":{"type":"string","enum":["ewma"]},"settings":{"$ref":"#/components/schemas/_types.aggregations:EwmaModelSettings"}},"required":["model","settings"]}]},"_types.aggregations:EwmaModelSettings":{"type":"object","properties":{"alpha":{"type":"number"}}},"_types.aggregations:HoltMovingAverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MovingAverageAggregationBase"},{"type":"object","properties":{"model":{"type":"string","enum":["holt"]},"settings":{"$ref":"#/components/schemas/_types.aggregations:HoltLinearModelSettings"}},"required":["model","settings"]}]},"_types.aggregations:HoltLinearModelSettings":{"type":"object","properties":{"alpha":{"type":"number"},"beta":{"type":"number"}}},"_types.aggregations:HoltWintersMovingAverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MovingAverageAggregationBase"},{"type":"object","properties":{"model":{"type":"string","enum":["holt_winters"]},"settings":{"$ref":"#/components/schemas/_types.aggregations:HoltWintersModelSettings"}},"required":["model","settings"]}]},"_types.aggregations:HoltWintersModelSettings":{"type":"object","properties":{"alpha":{"type":"number"},"beta":{"type":"number"},"gamma":{"type":"number"},"pad":{"type":"boolean"},"period":{"type":"number"},"type":{"$ref":"#/components/schemas/_types.aggregations:HoltWintersType"}}},"_types.aggregations:HoltWintersType":{"type":"string","enum":["add","mult"]},"_types.aggregations:MovingPercentilesAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"window":{"description":"The size of window to \\"slide\\" across the histogram.","type":"number"},"shift":{"description":"By default, the window consists of the last n values excluding the current bucket.\\nIncreasing `shift` by 1, moves the starting window position by 1 to the right.","type":"number"},"keyed":{"type":"boolean"}}}]},"_types.aggregations:MovingFunctionAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"script":{"description":"The script that should be executed on each window of data.","type":"string"},"shift":{"description":"By default, the window consists of the last n values excluding the current bucket.\\nIncreasing `shift` by 1, moves the starting window position by 1 to the right.","type":"number"},"window":{"description":"The size of window to \\"slide\\" across the histogram.","type":"number"}}}]},"_types.aggregations:MultiTermsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"collect_mode":{"$ref":"#/components/schemas/_types.aggregations:TermsAggregationCollectMode"},"order":{"$ref":"#/components/schemas/_types.aggregations:AggregateOrder"},"min_doc_count":{"description":"The minimum number of documents in a bucket for it to be returned.","type":"number"},"shard_min_doc_count":{"description":"The minimum number of documents in a bucket on each shard for it to be returned.","type":"number"},"shard_size":{"description":"The number of candidate terms produced by each shard.\\nBy default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter.","type":"number"},"show_term_doc_count_error":{"description":"Calculates the doc count error on per term basis.","type":"boolean"},"size":{"description":"The number of term buckets should be returned out of the overall terms list.","type":"number"},"terms":{"description":"The field from which to generate sets of terms.","type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:MultiTermLookup"}}},"required":["terms"]}]},"_types.aggregations:TermsAggregationCollectMode":{"type":"string","enum":["depth_first","breadth_first"]},"_types.aggregations:MultiTermLookup":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"missing":{"$ref":"#/components/schemas/_types.aggregations:Missing"}},"required":["field"]},"_types.aggregations:NestedAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"path":{"$ref":"#/components/schemas/_types:Field"}}}]},"_types.aggregations:NormalizeAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"method":{"$ref":"#/components/schemas/_types.aggregations:NormalizeMethod"}}}]},"_types.aggregations:NormalizeMethod":{"type":"string","enum":["rescale_0_1","rescale_0_100","percent_of_sum","mean","z-score","softmax"]},"_types.aggregations:ParentAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_types:RelationName"}}}]},"_types.aggregations:PercentileRanksAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object","properties":{"keyed":{"description":"By default, the aggregation associates a unique string key with each bucket and returns the ranges as a hash rather than an array.\\nSet to `false` to disable this behavior.","type":"boolean"},"values":{"description":"An array of values for which to calculate the percentile ranks.","oneOf":[{"type":"array","items":{"type":"number"}},{"nullable":true,"type":"string"}]},"hdr":{"$ref":"#/components/schemas/_types.aggregations:HdrMethod"},"tdigest":{"$ref":"#/components/schemas/_types.aggregations:TDigest"}}}]},"_types.aggregations:HdrMethod":{"type":"object","properties":{"number_of_significant_value_digits":{"description":"Specifies the resolution of values for the histogram in number of significant digits.","type":"number"}}},"_types.aggregations:TDigest":{"type":"object","properties":{"compression":{"description":"Limits the maximum number of nodes used by the underlying TDigest algorithm to `20 * compression`, enabling control of memory usage and approximation error.","type":"number"}}},"_types.aggregations:PercentilesAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object","properties":{"keyed":{"description":"By default, the aggregation associates a unique string key with each bucket and returns the ranges as a hash rather than an array.\\nSet to `false` to disable this behavior.","type":"boolean"},"percents":{"description":"The percentiles to calculate.","type":"array","items":{"type":"number"}},"hdr":{"$ref":"#/components/schemas/_types.aggregations:HdrMethod"},"tdigest":{"$ref":"#/components/schemas/_types.aggregations:TDigest"}}}]},"_types.aggregations:PercentilesBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"percents":{"description":"The list of percentiles to calculate.","type":"array","items":{"type":"number"}}}}]},"_types.aggregations:RangeAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"missing":{"description":"The value to apply to documents that do not have a value.\\nBy default, documents without a value are ignored.","type":"number"},"ranges":{"description":"An array of ranges used to bucket documents.","type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:AggregationRange"}},"script":{"$ref":"#/components/schemas/_types:Script"},"keyed":{"description":"Set to `true` to associate a unique string key with each bucket and return the ranges as a hash rather than an array.","type":"boolean"},"format":{"type":"string"}}}]},"_types.aggregations:RareTermsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"exclude":{"$ref":"#/components/schemas/_types.aggregations:TermsExclude"},"field":{"$ref":"#/components/schemas/_types:Field"},"include":{"$ref":"#/components/schemas/_types.aggregations:TermsInclude"},"max_doc_count":{"description":"The maximum number of documents a term should appear in.","type":"number"},"missing":{"$ref":"#/components/schemas/_types.aggregations:Missing"},"precision":{"description":"The precision of the internal CuckooFilters.\\nSmaller precision leads to better approximation, but higher memory usage.","type":"number"},"value_type":{"type":"string"}}}]},"_types.aggregations:RateAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object","properties":{"unit":{"$ref":"#/components/schemas/_types.aggregations:CalendarInterval"},"mode":{"$ref":"#/components/schemas/_types.aggregations:RateMode"}}}]},"_types.aggregations:RateMode":{"type":"string","enum":["sum","value_count"]},"_types.aggregations:ReverseNestedAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"path":{"$ref":"#/components/schemas/_types:Field"}}}]},"_types.aggregations:SamplerAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"shard_size":{"description":"Limits how many top-scoring documents are collected in the sample processed on each shard.","type":"number"}}}]},"_types.aggregations:ScriptedMetricAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"combine_script":{"$ref":"#/components/schemas/_types:Script"},"init_script":{"$ref":"#/components/schemas/_types:Script"},"map_script":{"$ref":"#/components/schemas/_types:Script"},"params":{"description":"A global object with script parameters for `init`, `map` and `combine` scripts.\\nIt is shared between the scripts.","type":"object","additionalProperties":{"type":"object"}},"reduce_script":{"$ref":"#/components/schemas/_types:Script"}}}]},"_types.aggregations:SerialDifferencingAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object","properties":{"lag":{"description":"The historical bucket to subtract from the current value.\\nMust be a positive, non-zero integer.","type":"number"}}}]},"_types.aggregations:SignificantTermsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"background_filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"chi_square":{"$ref":"#/components/schemas/_types.aggregations:ChiSquareHeuristic"},"exclude":{"$ref":"#/components/schemas/_types.aggregations:TermsExclude"},"execution_hint":{"$ref":"#/components/schemas/_types.aggregations:TermsAggregationExecutionHint"},"field":{"$ref":"#/components/schemas/_types:Field"},"gnd":{"$ref":"#/components/schemas/_types.aggregations:GoogleNormalizedDistanceHeuristic"},"include":{"$ref":"#/components/schemas/_types.aggregations:TermsInclude"},"jlh":{"$ref":"#/components/schemas/_types:EmptyObject"},"min_doc_count":{"description":"Only return terms that are found in more than `min_doc_count` hits.","type":"number"},"mutual_information":{"$ref":"#/components/schemas/_types.aggregations:MutualInformationHeuristic"},"percentage":{"$ref":"#/components/schemas/_types.aggregations:PercentageScoreHeuristic"},"script_heuristic":{"$ref":"#/components/schemas/_types.aggregations:ScriptedHeuristic"},"shard_min_doc_count":{"description":"Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the `min_doc_count`.\\nTerms will only be considered if their local shard frequency within the set is higher than the `shard_min_doc_count`.","type":"number"},"shard_size":{"description":"Can be used to control the volumes of candidate terms produced by each shard.\\nBy default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter.","type":"number"},"size":{"description":"The number of buckets returned out of the overall terms list.","type":"number"}}}]},"_types.aggregations:ChiSquareHeuristic":{"type":"object","properties":{"background_is_superset":{"description":"Set to `false` if you defined a custom background filter that represents a different set of documents that you want to compare to.","type":"boolean"},"include_negatives":{"description":"Set to `false` to filter out the terms that appear less often in the subset than in documents outside the subset.","type":"boolean"}},"required":["background_is_superset","include_negatives"]},"_types.aggregations:TermsAggregationExecutionHint":{"type":"string","enum":["map","global_ordinals","global_ordinals_hash","global_ordinals_low_cardinality"]},"_types.aggregations:GoogleNormalizedDistanceHeuristic":{"type":"object","properties":{"background_is_superset":{"description":"Set to `false` if you defined a custom background filter that represents a different set of documents that you want to compare to.","type":"boolean"}}},"_types.aggregations:MutualInformationHeuristic":{"type":"object","properties":{"background_is_superset":{"description":"Set to `false` if you defined a custom background filter that represents a different set of documents that you want to compare to.","type":"boolean"},"include_negatives":{"description":"Set to `false` to filter out the terms that appear less often in the subset than in documents outside the subset.","type":"boolean"}}},"_types.aggregations:PercentageScoreHeuristic":{"type":"object"},"_types.aggregations:ScriptedHeuristic":{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["script"]},"_types.aggregations:SignificantTextAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"background_filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"chi_square":{"$ref":"#/components/schemas/_types.aggregations:ChiSquareHeuristic"},"exclude":{"$ref":"#/components/schemas/_types.aggregations:TermsExclude"},"execution_hint":{"$ref":"#/components/schemas/_types.aggregations:TermsAggregationExecutionHint"},"field":{"$ref":"#/components/schemas/_types:Field"},"filter_duplicate_text":{"description":"Whether to out duplicate text to deal with noisy data.","type":"boolean"},"gnd":{"$ref":"#/components/schemas/_types.aggregations:GoogleNormalizedDistanceHeuristic"},"include":{"$ref":"#/components/schemas/_types.aggregations:TermsInclude"},"jlh":{"$ref":"#/components/schemas/_types:EmptyObject"},"min_doc_count":{"description":"Only return values that are found in more than `min_doc_count` hits.","type":"number"},"mutual_information":{"$ref":"#/components/schemas/_types.aggregations:MutualInformationHeuristic"},"percentage":{"$ref":"#/components/schemas/_types.aggregations:PercentageScoreHeuristic"},"script_heuristic":{"$ref":"#/components/schemas/_types.aggregations:ScriptedHeuristic"},"shard_min_doc_count":{"description":"Regulates the certainty a shard has if the values should actually be added to the candidate list or not with respect to the min_doc_count.\\nValues will only be considered if their local shard frequency within the set is higher than the `shard_min_doc_count`.","type":"number"},"shard_size":{"description":"The number of candidate terms produced by each shard.\\nBy default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter.","type":"number"},"size":{"description":"The number of buckets returned out of the overall terms list.","type":"number"},"source_fields":{"$ref":"#/components/schemas/_types:Fields"}}}]},"_types.aggregations:StatsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object"}]},"_types.aggregations:StatsBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:StringStatsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"show_distribution":{"description":"Shows the probability distribution for all characters.","type":"boolean"}}}]},"_types.aggregations:SumAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormatMetricAggregationBase"},{"type":"object"}]},"_types.aggregations:SumBucketAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:PipelineAggregationBase"},{"type":"object"}]},"_types.aggregations:TermsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"collect_mode":{"$ref":"#/components/schemas/_types.aggregations:TermsAggregationCollectMode"},"exclude":{"$ref":"#/components/schemas/_types.aggregations:TermsExclude"},"execution_hint":{"$ref":"#/components/schemas/_types.aggregations:TermsAggregationExecutionHint"},"field":{"$ref":"#/components/schemas/_types:Field"},"include":{"$ref":"#/components/schemas/_types.aggregations:TermsInclude"},"min_doc_count":{"description":"Only return values that are found in more than `min_doc_count` hits.","type":"number"},"missing":{"$ref":"#/components/schemas/_types.aggregations:Missing"},"missing_order":{"$ref":"#/components/schemas/_types.aggregations:MissingOrder"},"missing_bucket":{"type":"boolean"},"value_type":{"description":"Coerced unmapped fields into the specified type.","type":"string"},"order":{"$ref":"#/components/schemas/_types.aggregations:AggregateOrder"},"script":{"$ref":"#/components/schemas/_types:Script"},"shard_min_doc_count":{"description":"Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the `min_doc_count`.\\nTerms will only be considered if their local shard frequency within the set is higher than the `shard_min_doc_count`.","type":"number"},"shard_size":{"description":"The number of candidate terms produced by each shard.\\nBy default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter.","type":"number"},"show_term_doc_count_error":{"description":"Set to `true` to return the `doc_count_error_upper_bound`, which is an upper bound to the error on the `doc_count` returned by each shard.","type":"boolean"},"size":{"description":"The number of buckets returned out of the overall terms list.","type":"number"},"format":{"type":"string"}}}]},"_types.aggregations:TimeSeriesAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:BucketAggregationBase"},{"type":"object","properties":{"size":{"description":"The maximum number of results to return.","type":"number"},"keyed":{"description":"Set to `true` to associate a unique string key with each bucket and returns the ranges as a hash rather than an array.","type":"boolean"}}}]},"_types.aggregations:TopHitsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"docvalue_fields":{"description":"Fields for which to return doc values.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:FieldAndFormat"}},"explain":{"description":"If `true`, returns detailed information about score computation as part of a hit.","type":"boolean"},"fields":{"description":"Array of wildcard (*) patterns. The request returns values for field names\\nmatching these patterns in the hits.fields property of the response.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:FieldAndFormat"}},"from":{"description":"Starting document offset.","type":"number"},"highlight":{"$ref":"#/components/schemas/_global.search._types:Highlight"},"script_fields":{"description":"Returns the result of one or more script evaluations for each hit.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:ScriptField"}},"size":{"description":"The maximum number of top matching hits to return per bucket.","type":"number"},"sort":{"$ref":"#/components/schemas/_types:Sort"},"_source":{"$ref":"#/components/schemas/_global.search._types:SourceConfig"},"stored_fields":{"$ref":"#/components/schemas/_types:Fields"},"track_scores":{"description":"If `true`, calculates and returns document scores, even if the scores are not used for sorting.","type":"boolean"},"version":{"description":"If `true`, returns document version as part of a hit.","type":"boolean"},"seq_no_primary_term":{"description":"If `true`, returns sequence number and primary term of the last modification of each hit.","type":"boolean"}}}]},"_types.aggregations:TTestAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object","properties":{"a":{"$ref":"#/components/schemas/_types.aggregations:TestPopulation"},"b":{"$ref":"#/components/schemas/_types.aggregations:TestPopulation"},"type":{"$ref":"#/components/schemas/_types.aggregations:TTestType"}}}]},"_types.aggregations:TestPopulation":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"script":{"$ref":"#/components/schemas/_types:Script"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["field"]},"_types.aggregations:TTestType":{"type":"string","enum":["paired","homoscedastic","heteroscedastic"]},"_types.aggregations:TopMetricsAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"metrics":{"description":"The fields of the top document to return.","oneOf":[{"$ref":"#/components/schemas/_types.aggregations:TopMetricsValue"},{"type":"array","items":{"$ref":"#/components/schemas/_types.aggregations:TopMetricsValue"}}]},"size":{"description":"The number of top documents from which to return metrics.","type":"number"},"sort":{"$ref":"#/components/schemas/_types:Sort"}}}]},"_types.aggregations:TopMetricsValue":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["field"]},"_types.aggregations:ValueCountAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:FormattableMetricAggregation"},{"type":"object"}]},"_types.aggregations:FormattableMetricAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:MetricAggregationBase"},{"type":"object","properties":{"format":{"type":"string"}}}]},"_types.aggregations:WeightedAverageAggregation":{"allOf":[{"$ref":"#/components/schemas/_types.aggregations:Aggregation"},{"type":"object","properties":{"format":{"description":"A numeric response formatter.","type":"string"},"value":{"$ref":"#/components/schemas/_types.aggregations:WeightedAverageValue"},"value_type":{"$ref":"#/components/schemas/_types.aggregations:ValueType"},"weight":{"$ref":"#/components/schemas/_types.aggregations:WeightedAverageValue"}}}]},"_types.aggregations:WeightedAverageValue":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"missing":{"description":"A value or weight to use if the field is missing.","type":"number"},"script":{"$ref":"#/components/schemas/_types:Script"}}},"_types.aggregations:VariableWidthHistogramAggregation":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"buckets":{"description":"The target number of buckets.","type":"number"},"shard_size":{"description":"The number of buckets that the coordinating node will request from each shard.\\nDefaults to `buckets * 50`.","type":"number"},"initial_buffer":{"description":"Specifies the number of individual documents that will be stored in memory on a shard before the initial bucketing algorithm is run.\\nDefaults to `min(10 * shard_size, 50000)`.","type":"number"},"script":{"$ref":"#/components/schemas/_types:Script"}}},"ml._types:ChunkingConfig":{"type":"object","properties":{"mode":{"$ref":"#/components/schemas/ml._types:ChunkingMode"},"time_span":{"$ref":"#/components/schemas/_types:Duration"}},"required":["mode"]},"ml._types:ChunkingMode":{"type":"string","enum":["auto","manual","off"]},"ml._types:DelayedDataCheckConfig":{"type":"object","properties":{"check_window":{"$ref":"#/components/schemas/_types:Duration"},"enabled":{"description":"Specifies whether the datafeed periodically checks for delayed data.","type":"boolean"}},"required":["enabled"]},"_types:Indices":{"oneOf":[{"$ref":"#/components/schemas/_types:IndexName"},{"type":"array","items":{"$ref":"#/components/schemas/_types:IndexName"}}]},"_types:IndicesOptions":{"type":"object","properties":{"allow_no_indices":{"description":"If false, the request returns an error if any wildcard expression, index alias, or `_all` value targets only\\nmissing or closed indices. This behavior applies even if the request targets other open indices. For example,\\na request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`.","type":"boolean"},"expand_wildcards":{"$ref":"#/components/schemas/_types:ExpandWildcards"},"ignore_unavailable":{"description":"If true, missing or closed indices are not included in the response.","type":"boolean"},"ignore_throttled":{"description":"If true, concrete, expanded or aliased indices are ignored when frozen.","type":"boolean"}}},"_types:ExpandWildcards":{"oneOf":[{"$ref":"#/components/schemas/_types:ExpandWildcard"},{"type":"array","items":{"$ref":"#/components/schemas/_types:ExpandWildcard"}}]},"_types:ExpandWildcard":{"type":"string","enum":["all","open","closed","hidden","none"]},"_types.mapping:RuntimeFields":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.mapping:RuntimeField"}},"_types.mapping:RuntimeField":{"type":"object","properties":{"fields":{"description":"For type `composite`","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.mapping:CompositeSubField"}},"fetch_fields":{"description":"For type `lookup`","type":"array","items":{"$ref":"#/components/schemas/_types.mapping:RuntimeFieldFetchFields"}},"format":{"description":"A custom format for `date` type runtime fields.","type":"string"},"input_field":{"$ref":"#/components/schemas/_types:Field"},"target_field":{"$ref":"#/components/schemas/_types:Field"},"target_index":{"$ref":"#/components/schemas/_types:IndexName"},"script":{"$ref":"#/components/schemas/_types:Script"},"type":{"$ref":"#/components/schemas/_types.mapping:RuntimeFieldType"}},"required":["type"]},"_types.mapping:CompositeSubField":{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_types.mapping:RuntimeFieldType"}},"required":["type"]},"_types.mapping:RuntimeFieldType":{"type":"string","enum":["boolean","composite","date","double","geo_point","ip","keyword","long","lookup"]},"_types.mapping:RuntimeFieldFetchFields":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"format":{"type":"string"}},"required":["field"]},"ml._types:ModelPlotConfig":{"type":"object","properties":{"annotations_enabled":{"description":"If true, enables calculation and storage of the model change annotations for each entity that is being analyzed.","type":"boolean"},"enabled":{"description":"If true, enables calculation and storage of the model bounds for each entity that is being analyzed.","type":"boolean"},"terms":{"$ref":"#/components/schemas/_types:Field"}}}}}}')}}]);