"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateModelSnapshotsSchema = exports.updateModelSnapshotBodySchema = exports.jobIdSchemaBasic = exports.jobIdSchema = exports.jobForCloningSchema = exports.getOverallBucketsSchema = exports.getModelSnapshotsSchema = exports.getCategoriesSchema = exports.getBucketsSchema = exports.getBucketParamsSchema = exports.getAnomalyDetectorsResponse = exports.forecastAnomalyDetector = exports.forceQuerySchema = exports.deleteForecastSchema = exports.anomalyDetectionUpdateJobSchema = exports.anomalyDetectionJobSchema = exports.analysisConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _datafeeds_schema = require("./datafeeds_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customRulesSchema = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
  actions: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('skip_result'), _configSchema.schema.literal('skip_model_update'), _configSchema.schema.literal('force_time_shift')])),
  conditions: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  scope: _configSchema.schema.maybe(_configSchema.schema.any()),
  params: _configSchema.schema.maybe(_configSchema.schema.any())
}), {
  meta: {
    description: 'Custom rules'
  }
}));
const AnalysisLimits = _configSchema.schema.object({
  categorization_examples_limit: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Limit of categorization examples'
    }
  })),
  model_memory_limit: _configSchema.schema.string()
});
const detectorSchema = _configSchema.schema.object({
  identifier: _configSchema.schema.maybe(_configSchema.schema.string()),
  function: _configSchema.schema.string(),
  field_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  by_field_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  over_field_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  partition_field_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  detector_description: _configSchema.schema.maybe(_configSchema.schema.string()),
  exclude_frequent: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('none'), _configSchema.schema.literal('by'), _configSchema.schema.literal('over')])),
  use_null: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  custom_rules: customRulesSchema,
  detector_index: _configSchema.schema.maybe(_configSchema.schema.number())
});
const customUrlSchema = {
  url_name: _configSchema.schema.string(),
  url_value: _configSchema.schema.string(),
  time_range: _configSchema.schema.maybe(_configSchema.schema.any())
};
const customSettingsSchema = _configSchema.schema.object({
  created_by: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Indicates the creator entity'
    }
  })),
  custom_urls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.maybe(_configSchema.schema.object(customUrlSchema))))
}, {
  unknowns: 'allow'
} // Create / Update job API allows other fields to be added to custom_settings.
);
const anomalyDetectionUpdateJobSchema = exports.anomalyDetectionUpdateJobSchema = _configSchema.schema.object({
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  detectors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.maybe(_configSchema.schema.object({
    /** Detector index */
    detector_index: _configSchema.schema.number(),
    /** Description */
    description: _configSchema.schema.maybe(_configSchema.schema.string()),
    /** Custom rules */
    custom_rules: customRulesSchema
  })))),
  custom_settings: _configSchema.schema.maybe(customSettingsSchema),
  analysis_limits: _configSchema.schema.maybe(AnalysisLimits),
  groups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  model_snapshot_retention_days: _configSchema.schema.maybe(_configSchema.schema.number()),
  daily_model_snapshot_retention_after_days: _configSchema.schema.maybe(_configSchema.schema.number())
});
const analysisConfigSchema = exports.analysisConfigSchema = _configSchema.schema.object({
  bucket_span: _configSchema.schema.string(),
  summary_count_field_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  detectors: _configSchema.schema.arrayOf(detectorSchema),
  influencers: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  categorization_field_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  categorization_analyzer: _configSchema.schema.maybe(_configSchema.schema.any()),
  categorization_filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  latency: _configSchema.schema.maybe(_configSchema.schema.number()),
  multivariate_by_fields: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  per_partition_categorization: _configSchema.schema.maybe(_configSchema.schema.object({
    enabled: _configSchema.schema.boolean(),
    stop_on_warn: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })),
  model_prune_window: _configSchema.schema.maybe(_configSchema.schema.string())
});
const anomalyDetectionJobSchema = exports.anomalyDetectionJobSchema = {
  analysis_config: analysisConfigSchema,
  analysis_limits: _configSchema.schema.maybe(AnalysisLimits),
  background_persist_interval: _configSchema.schema.maybe(_configSchema.schema.string()),
  create_time: _configSchema.schema.maybe(_configSchema.schema.number()),
  custom_settings: _configSchema.schema.maybe(customSettingsSchema),
  allow_lazy_open: _configSchema.schema.maybe(_configSchema.schema.any()),
  data_counts: _configSchema.schema.maybe(_configSchema.schema.any()),
  data_description: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.string()),
    time_field: _configSchema.schema.string(),
    time_format: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  established_model_memory: _configSchema.schema.maybe(_configSchema.schema.number()),
  finished_time: _configSchema.schema.maybe(_configSchema.schema.number()),
  job_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  job_type: _configSchema.schema.maybe(_configSchema.schema.string()),
  job_version: _configSchema.schema.maybe(_configSchema.schema.string()),
  groups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.maybe(_configSchema.schema.string()))),
  model_plot_config: _configSchema.schema.maybe(_configSchema.schema.any()),
  model_plot: _configSchema.schema.maybe(_configSchema.schema.any()),
  model_size_stats: _configSchema.schema.maybe(_configSchema.schema.any()),
  model_snapshot_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  model_snapshot_min_version: _configSchema.schema.maybe(_configSchema.schema.string()),
  model_snapshot_retention_days: _configSchema.schema.maybe(_configSchema.schema.number()),
  daily_model_snapshot_retention_after_days: _configSchema.schema.maybe(_configSchema.schema.number()),
  renormalization_window_days: _configSchema.schema.maybe(_configSchema.schema.number()),
  results_index_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  results_retention_days: _configSchema.schema.maybe(_configSchema.schema.number()),
  state: _configSchema.schema.maybe(_configSchema.schema.string()),
  datafeed_config: _configSchema.schema.maybe(_datafeeds_schema.datafeedConfigSchema)
};
const jobIdSchemaBasic = exports.jobIdSchemaBasic = {
  jobId: _configSchema.schema.string({
    meta: {
      description: 'Job ID'
    }
  })
};
const jobIdSchema = exports.jobIdSchema = _configSchema.schema.object({
  ...jobIdSchemaBasic
});
const deleteForecastSchema = exports.deleteForecastSchema = _configSchema.schema.object({
  ...jobIdSchemaBasic,
  forecastId: _configSchema.schema.string()
});
const getBucketsSchema = exports.getBucketsSchema = _configSchema.schema.object({
  anomaly_score: _configSchema.schema.maybe(_configSchema.schema.number()),
  desc: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  exclude_interim: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  expand: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  page: _configSchema.schema.maybe(_configSchema.schema.object({
    from: _configSchema.schema.number({
      meta: {
        description: 'Page offset'
      }
    }),
    size: _configSchema.schema.number({
      meta: {
        description: 'Size of the page'
      }
    })
  }, {
    meta: {
      description: 'Page definition'
    }
  })),
  sort: _configSchema.schema.maybe(_configSchema.schema.string()),
  start: _configSchema.schema.maybe(_configSchema.schema.string())
});
const getBucketParamsSchema = exports.getBucketParamsSchema = _configSchema.schema.object({
  jobId: _configSchema.schema.string(),
  timestamp: _configSchema.schema.maybe(_configSchema.schema.string())
});
const getOverallBucketsSchema = exports.getOverallBucketsSchema = _configSchema.schema.object({
  topN: _configSchema.schema.number(),
  bucketSpan: _configSchema.schema.string(),
  start: _configSchema.schema.number(),
  end: _configSchema.schema.number(),
  overall_score: _configSchema.schema.maybe(_configSchema.schema.number())
});
const getCategoriesSchema = exports.getCategoriesSchema = _configSchema.schema.object({
  categoryId: _configSchema.schema.string({
    meta: {
      description: 'Category ID'
    }
  }),
  ...jobIdSchemaBasic
});
const getModelSnapshotsSchema = exports.getModelSnapshotsSchema = _configSchema.schema.object({
  snapshotId: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Snapshot ID'
    }
  })),
  ...jobIdSchemaBasic
});
const updateModelSnapshotsSchema = exports.updateModelSnapshotsSchema = _configSchema.schema.object({
  snapshotId: _configSchema.schema.string({
    meta: {
      description: 'Snapshot ID'
    }
  }),
  ...jobIdSchemaBasic
});
const updateModelSnapshotBodySchema = exports.updateModelSnapshotBodySchema = _configSchema.schema.object({
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  retain: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const forecastAnomalyDetector = exports.forecastAnomalyDetector = _configSchema.schema.object({
  duration: _configSchema.schema.any(),
  expires_in: _configSchema.schema.maybe(_configSchema.schema.any())
});
const forceQuerySchema = exports.forceQuerySchema = _configSchema.schema.object({
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const jobForCloningSchema = exports.jobForCloningSchema = _configSchema.schema.object({
  retainCreatedBy: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Whether to retain the created_by custom setting.'
    }
  })),
  ...jobIdSchemaBasic
});
const getAnomalyDetectorsResponse = () => {
  return _configSchema.schema.object({
    count: _configSchema.schema.number(),
    jobs: _configSchema.schema.arrayOf(_configSchema.schema.any())
  });
};
exports.getAnomalyDetectorsResponse = getAnomalyDetectorsResponse;