"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _aiops = require("./formatters/aiops");
var _locator = require("../../common/constants/locator");
var _formatters = require("./formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MlLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _locator.ML_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "validPaths", new Set(Object.values(_locator.ML_PAGES)));
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      let path = '';
      if (!this.validPaths.has(params.page)) {
        throw new Error('Page type is not provided or unknown');
      }
      switch (params.page) {
        case _locator.ML_PAGES.ANOMALY_EXPLORER:
          path = (0, _formatters.formatExplorerUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.SINGLE_METRIC_VIEWER:
          path = (0, _formatters.formatSingleMetricViewerUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP:
          path = (0, _formatters.formatDataFrameAnalyticsMapUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION:
          path = (0, _formatters.formatDataFrameAnalyticsExplorationUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION:
          path = (0, _aiops.formatChangePointDetectionUrl)('', params.pageState);
          break;
        default:
          path = (0, _formatters.formatGenericMlUrl)('', params.page, params.pageState);
          break;
      }
      return {
        app: 'ml',
        path,
        state: {}
      };
    });
  }
}
exports.MlLocatorDefinition = MlLocatorDefinition;