"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatChangePointDetectionUrl = formatChangePointDetectionUrl;
var _public = require("@kbn/kibana-utils-plugin/public");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates URL to the Change Point Detection page
 */
function formatChangePointDetectionUrl(appBasePath, params) {
  let url = `${appBasePath}/${_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION}`;
  if (!(params !== null && params !== void 0 && params.fieldConfigs)) {
    throw new Error('Field configs are required to create a change point detection URL');
  }
  if (!params.index) {
    throw new Error('Data view is required to create a change point detection URL');
  }
  url = `${url}?index=${params.index}`;
  const {
    timeRange,
    fieldConfigs
  } = params;
  const appState = {
    fieldConfigs
  };
  const queryState = {
    time: timeRange
  };
  url = (0, _public.setStateToKbnUrl)('_g', queryState, {
    useHash: false,
    storeInHashQuery: false
  }, url);
  url = (0, _public.setStateToKbnUrl)('_a', {
    changePoint: appState
  }, {
    useHash: false,
    storeInHashQuery: false
  }, url);
  return url;
}