"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CASES_TOAST_MESSAGES_TITLES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Titles for the cases toast messages
 */
const CASES_TOAST_MESSAGES_TITLES = exports.CASES_TOAST_MESSAGES_TITLES = {
  ANOMALY_TIMELINE: _i18n.i18n.translate('xpack.ml.cases.anomalyTimelineTitle', {
    defaultMessage: 'Anomaly timeline'
  }),
  ANOMALY_CHARTS: chartsCount => _i18n.i18n.translate('xpack.ml.cases.anomalyChartsTitle', {
    defaultMessage: 'Anomaly {chartsCount, plural, one {chart} other {charts}}',
    values: {
      chartsCount
    }
  }),
  SINGLE_METRIC_VIEWER: _i18n.i18n.translate('xpack.ml.cases.singleMetricViewerTitle', {
    defaultMessage: 'Single metric viewer'
  })
};