"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCriteriaFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates criteria fields for API calls, e.g. getAnomaliesTableData
 * @param detectorIndex
 * @param entities
 */
const getCriteriaFields = (detectorIndex, entities) => {
  // Only filter on the entity if the field has a value.
  const nonBlankEntities = entities.filter(entity => entity.fieldValue !== null);
  return [{
    fieldName: 'detector_index',
    fieldValue: detectorIndex
  }, ...nonBlankEntities];
};
exports.getCriteriaFields = getCriteriaFields;