"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForecastButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/forecasting_modal/forecast_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ForecastButton = ({
  isDisabled,
  onClick,
  mode = 'full'
}) => {
  const Button = mode === 'full' ? _eui.EuiButton : _eui.EuiButtonEmpty;
  return /*#__PURE__*/_react.default.createElement(Button
  // Keep primary color for EmptyButton
  , {
    color: mode === 'full' ? 'text' : 'primary',
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlSingleMetricViewerButtonForecast",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.forecastButtonLabel",
    defaultMessage: "Forecast",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }));
};
exports.ForecastButton = ForecastButton;