"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlCalendarService = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CalendarService {
  /**
   * Assigns a job id to the calendar.
   * @param calendar
   * @param jobId
   */
  async assignNewJobId(mlApi, calendar, jobId) {
    const {
      calendar_id: calendarId
    } = calendar;
    try {
      await mlApi.updateCalendar({
        ...calendar,
        calendarId,
        job_ids: [...calendar.job_ids, jobId]
      });
    } catch (e) {
      throw new Error(_i18n.i18n.translate('xpack.ml.calendarService.assignNewJobIdErrorMessage', {
        defaultMessage: 'Unable to assign {jobId} to {calendarId}',
        values: {
          calendarId,
          jobId
        }
      }));
    }
  }

  /**
   * Fetches calendars by the list of ids.
   * @param calendarIds
   */
  async fetchCalendarsByIds(mlApi, calendarIds) {
    try {
      const calendars = await mlApi.calendars({
        calendarIds
      });
      return Array.isArray(calendars) ? calendars : [calendars];
    } catch (e) {
      throw new Error(_i18n.i18n.translate('xpack.ml.calendarService.fetchCalendarsByIdsErrorMessage', {
        defaultMessage: 'Unable to fetch calendars: {calendarIds}',
        values: {
          calendarIds: calendarIds.join(', ')
        }
      }));
    }
  }
}
const mlCalendarService = exports.mlCalendarService = new CalendarService();