"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialState = void 0;
var _state = require("../../components/ml_inference/state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialState = (model, initialPipelineConfig) => ({
  creatingPipeline: false,
  error: false,
  ignoreFailure: false,
  modelId: model.model_id,
  onFailure: (0, _state.getDefaultOnFailureConfiguration)(),
  pipelineDescription: `Uses the pre-trained model ${model.model_id} to infer against the data that is being ingested in the pipeline`,
  pipelineName: `ml-inference-${model.model_id}`,
  pipelineCreated: false,
  initialPipelineConfig,
  takeActionOnFailure: true
});
exports.getInitialState = getInitialState;