"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _page_title = require("../../../../components/page_title");
var _create_data_view_button = require("../../../../components/create_data_view_button");
var _kibana = require("../../../../contexts/kibana");
var _page_header = require("../../../../components/page_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/index_or_search/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RESULTS_PER_PAGE = 20;
const Page = ({
  nextStepPath,
  extraButtons
}) => {
  const {
    contentManagement,
    uiSettings
  } = (0, _kibana.useMlKibana)().services;
  const mlLocator = (0, _kibana.useMlManagementLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const onObjectSelection = async (id, type, name) => {
    const urlPath = window.location.pathname;
    if (urlPath.includes('management')) {
      await (mlLocator === null || mlLocator === void 0 ? void 0 : mlLocator.navigate({
        sectionId: 'ml',
        appId: `anomaly_detection/${nextStepPath}?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`
      }));
    } else {
      navigateToPath(`${nextStepPath}?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`);
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageSourceSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.selectDataViewOrSavedSearch",
      defaultMessage: "Select data view or saved Discover session",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "mlJobsDatafeedDataView",
    key: "searchSavedObjectFinder",
    onChoose: onObjectSelection,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching data views or saved Discover sessions found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'discoverApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.discoverSession', {
        defaultMessage: 'Discover session'
      }),
      showSavedObject: savedObject =>
      // ES|QL Based saved searches are not supported across ML, filter them out
      savedObject.attributes.isTextBasedQuery !== true
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: RESULTS_PER_PAGE,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_create_data_view_button.CreateDataViewButton, {
    onDataViewCreated: dataView => {
      onObjectSelection(dataView.id, 'index-pattern', dataView.getIndexPattern());
    },
    allowAdHocDataView: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }), extraButtons ? extraButtons : null)))));
};
exports.Page = Page;