"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DedicatedIndexSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/advanced_section/components/dedicated_index/dedicated_index_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DedicatedIndexSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [useDedicatedIndex, setUseDedicatedIndex] = (0, _react.useState)(jobCreator.useDedicatedIndex);
  (0, _react.useEffect)(() => {
    jobCreator.useDedicatedIndex = useDedicatedIndex;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [useDedicatedIndex]);
  function toggleModelPlot() {
    setUseDedicatedIndex(!useDedicatedIndex);
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    checked: useDedicatedIndex,
    onChange: toggleModelPlot,
    "data-test-subj": "mlJobWizardSwitchUseDedicatedIndex",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.useDedicatedIndex.title', {
      defaultMessage: 'Use dedicated index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
};
exports.DedicatedIndexSwitch = DedicatedIndexSwitch;