"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/advanced_section/components/annotations/annotations_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnnotationsSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [annotationsEnabled, setAnnotationsEnabled] = (0, _react.useState)(jobCreator.modelChangeAnnotations);
  const [showCallOut, setShowCallout] = (0, _react.useState)(jobCreator.modelPlot && !jobCreator.modelChangeAnnotations);
  (0, _react.useEffect)(() => {
    jobCreator.modelChangeAnnotations = annotationsEnabled;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [annotationsEnabled]);
  (0, _react.useEffect)(() => {
    setShowCallout(jobCreator.modelPlot && !annotationsEnabled);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated, annotationsEnabled]);
  function toggleAnnotations() {
    setAnnotationsEnabled(!annotationsEnabled);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_description.Description, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    checked: annotationsEnabled,
    onChange: toggleAnnotations,
    "data-test-subj": "mlJobWizardSwitchAnnotations",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.enableModelPlotAnnotations.title', {
      defaultMessage: 'Enable model change annotations'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), showCallOut && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "mlJobWizardAlsoEnableAnnotationsRecommendationCallout",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.annotationsSwitchCallout.title",
      defaultMessage: "If you enable model plot with this configuration, we recommend you also enable annotations.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }),
    color: "primary",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }));
};
exports.AnnotationsSwitch = AnnotationsSwitch;