"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditCategorizationAnalyzerFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ml_job_editor = require("../../../../../jobs_list/components/ml_job_editor");
var _validation_utils = require("../../../../../../../../common/util/validation_utils");
var _job_creator_context = require("../../job_creator_context");
var _ml_server_info = require("../../../../../../services/ml_server_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/common/edit_categorization_analyzer_flyout/edit_categorization_analyzer_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EDITOR_HEIGHT = '800px';
const EditCategorizationAnalyzerFlyout = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [showJsonFlyout, setShowJsonFlyout] = (0, _react.useState)(false);
  const [saveable, setSaveable] = (0, _react.useState)(false);
  const [categorizationAnalyzerString, setCategorizationAnalyzerString] = (0, _react.useState)(JSON.stringify(jobCreator.categorizationAnalyzer, null, 2));
  (0, _react.useEffect)(() => {
    if (showJsonFlyout === true) {
      setCategorizationAnalyzerString(JSON.stringify(jobCreator.categorizationAnalyzer, null, 2));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [showJsonFlyout]);
  function toggleJsonFlyout() {
    setSaveable(false);
    setShowJsonFlyout(!showJsonFlyout);
  }
  function onJSONChange(json) {
    setCategorizationAnalyzerString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setSaveable(valid);
  }
  function onSave() {
    jobCreator.categorizationAnalyzer = JSON.parse(categorizationAnalyzerString);
    jobCreatorUpdate();
    setShowJsonFlyout(false);
  }
  function onUseDefault() {
    const {
      anomaly_detectors: anomalyDetectors
    } = (0, _ml_server_info.getNewJobDefaults)();
    const analyzerString = JSON.stringify(anomalyDetectors.categorization_analyzer, null, 2);
    onJSONChange(analyzerString);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleJsonFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), showJsonFlyout === true && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setShowJsonFlyout(false),
    hideCloseButton: true,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Contents, {
    onChange: onJSONChange,
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.title', {
      defaultMessage: 'Edit categorization analyzer JSON'
    }),
    value: categorizationAnalyzerString,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => setShowJsonFlyout(false),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onUseDefault,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.useDefaultButton",
    defaultMessage: "Use default ML analyzer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    isDisabled: saveable === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.saveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 19
    }
  })))))));
};
exports.EditCategorizationAnalyzerFlyout = EditCategorizationAnalyzerFlyout;
const FlyoutButton = ({
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    flush: "left",
    "data-test-subj": "mlJobWizardButtonPreviewJobJson",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.editCategorizationAnalyzerFlyoutButton",
    defaultMessage: "Edit categorization analyzer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }));
};
const Contents = ({
  title,
  value,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: value,
    height: EDITOR_HEIGHT,
    readOnly: false,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }));
};