"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartInfoTooltip = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _explorer_constants = require("../explorer_constants");
var _i18n = require("@kbn/i18n");
var _explorer_chart_tooltip_styles = require("./explorer_chart_tooltip_styles");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/explorer_chart_info_tooltip.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CHART_DESCRIPTION = {
  [_explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION]: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.chartEventDistributionDescription', {
    defaultMessage: 'The gray dots depict the approximate distribution of occurrences over time for a sample of {byFieldValuesParam} with' + ' more frequent event types at the top and rarer ones at the bottom.',
    values: {
      byFieldValuesParam: 'by_field_values'
    }
  }),
  [_explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION]: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.chartPopulationDistributionDescription', {
    defaultMessage: 'The gray dots depict the approximate distribution of values over time for a sample of {overFieldValuesParam}.',
    values: {
      overFieldValuesParam: 'over_field_values'
    }
  })
};
function TooltipDefinitionList({
  toolTipData
}) {
  const {
    title: titleStyle,
    description: descriptionStyle,
    descriptionList
  } = (0, _explorer_chart_tooltip_styles.useExplorerChartTooltipStyles)();
  return /*#__PURE__*/_react.default.createElement("dl", {
    css: descriptionList,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, toolTipData.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `${title} ${description}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("dt", {
    css: titleStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, title), /*#__PURE__*/_react.default.createElement("dd", {
    css: descriptionStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, description))));
}
const ExplorerChartInfoTooltip = ({
  jobId,
  aggregationInterval,
  chartFunction,
  chartType,
  entityFields = []
}) => {
  const {
    tooltip,
    chartDescription: chartDescriptionStyle
  } = (0, _explorer_chart_tooltip_styles.useExplorerChartTooltipStyles)();
  const chartDescription = CHART_DESCRIPTION[chartType];
  const toolTipData = [{
    title: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.jobIdTitle', {
      defaultMessage: 'job ID'
    }),
    description: jobId
  }, {
    title: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.aggregationIntervalTitle', {
      defaultMessage: 'aggregation interval'
    }),
    description: aggregationInterval
  }, {
    title: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.chartFunctionTitle', {
      defaultMessage: 'chart function'
    }),
    description: chartFunction
  }];
  entityFields.forEach(entityField => {
    toolTipData.push({
      title: entityField.fieldName,
      description: entityField.fieldValue
    });
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: tooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TooltipDefinitionList, {
    toolTipData: toolTipData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), chartDescription && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: chartDescriptionStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, chartDescription)));
};
exports.ExplorerChartInfoTooltip = ExplorerChartInfoTooltip;
ExplorerChartInfoTooltip.propTypes = {
  jobId: _propTypes.default.string.isRequired,
  aggregationInterval: _propTypes.default.string,
  chartFunction: _propTypes.default.string,
  entityFields: _propTypes.default.array
};