"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyExplorerCommonStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _explorer_utils = require("./explorer_utils");
var _state_service = require("../services/state_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Anomaly Explorer common state.
 * Manages related values in the URL state and applies required formatting.
 */
class AnomalyExplorerCommonStateService extends _state_service.StateService {
  _getDefaultFilterSettings() {
    return {
      filterActive: false,
      filteredFields: [],
      queryString: '',
      influencersFilterQuery: undefined
    };
  }
  constructor(anomalyExplorerUrlStateService, globalUrlStateService, mlJobsService) {
    super();
    (0, _defineProperty2.default)(this, "_selectedJobs$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "_selectedGroups$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "_filterSettings$", new _rxjs.BehaviorSubject(this._getDefaultFilterSettings()));
    (0, _defineProperty2.default)(this, "_invalidJobIds$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "selectedGroups$", this._selectedGroups$.pipe((0, _rxjs.distinctUntilChanged)(_lodash.isEqual), (0, _rxjs.shareReplay)(1)));
    (0, _defineProperty2.default)(this, "invalidJobIds$", this._invalidJobIds$.pipe((0, _rxjs.distinctUntilChanged)(_lodash.isEqual), (0, _rxjs.shareReplay)(1)));
    (0, _defineProperty2.default)(this, "selectedJobs$", this._selectedJobs$.pipe((0, _rxjs.filter)(v => Array.isArray(v) && v.length > 0), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual), (0, _rxjs.shareReplay)(1)));
    (0, _defineProperty2.default)(this, "influencerFilterQuery$", this._filterSettings$.pipe((0, _rxjs.map)(v => v === null || v === void 0 ? void 0 : v.influencersFilterQuery), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)));
    (0, _defineProperty2.default)(this, "filterSettings$", this._filterSettings$.asObservable());
    this.anomalyExplorerUrlStateService = anomalyExplorerUrlStateService;
    this.globalUrlStateService = globalUrlStateService;
    this.mlJobsService = mlJobsService;
    this._init();
  }
  get selectedGroups() {
    return this._selectedGroups$.getValue();
  }
  get invalidJobIds() {
    return this._invalidJobIds$.getValue();
  }
  get selectedJobs() {
    return this._selectedJobs$.getValue();
  }
  get filterSettings() {
    return this._filterSettings$.getValue();
  }
  _initSubscriptions() {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(this.anomalyExplorerUrlStateService.getUrlState$().pipe((0, _rxjs.map)(urlState => urlState === null || urlState === void 0 ? void 0 : urlState.mlExplorerFilter), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(v => {
      const result = {
        ...this._getDefaultFilterSettings(),
        ...v
      };
      this._filterSettings$.next(result);
    }));
    subscriptions.add(this.globalUrlStateService.getUrlState$().pipe((0, _rxjs.map)(urlState => {
      var _urlState$ml;
      return urlState === null || urlState === void 0 ? void 0 : (_urlState$ml = urlState.ml) === null || _urlState$ml === void 0 ? void 0 : _urlState$ml.jobIds;
    }), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(selectedJobIds => {
      this._processSelectedJobs(selectedJobIds);
    }));
    return subscriptions;
  }
  _processSelectedJobs(selectedJobIds) {
    if (!selectedJobIds || selectedJobIds.length === 0) {
      this._selectedJobs$.next([]);
      this._invalidJobIds$.next([]);
      this._selectedGroups$.next([]);
      return;
    }
    // TODO: We are using mlJobService jobs, which has stale data.

    const groupIds = selectedJobIds.filter(id => this.mlJobsService.jobs.some(job => {
      var _job$groups;
      return (_job$groups = job.groups) === null || _job$groups === void 0 ? void 0 : _job$groups.includes(id);
    }));
    const selectedGroups = groupIds.map(groupId => ({
      groupId,
      jobIds: this.mlJobsService.jobs.filter(job => {
        var _job$groups2;
        return (_job$groups2 = job.groups) === null || _job$groups2 === void 0 ? void 0 : _job$groups2.includes(groupId);
      }).map(job => job.job_id)
    }));
    const selectedJobs = this.mlJobsService.jobs.filter(j => {
      var _j$groups;
      return selectedJobIds.includes(j.job_id) || ((_j$groups = j.groups) === null || _j$groups === void 0 ? void 0 : _j$groups.some(g => groupIds.includes(g)));
    });
    const mappedJobs = (0, _explorer_utils.createJobs)(selectedJobs);
    const invalidJobIds = this._getInvalidJobIds(selectedJobIds);
    this._invalidJobIds$.next(invalidJobIds);
    this._selectedJobs$.next(mappedJobs);
    this._selectedGroups$.next(selectedGroups);
  }
  _getInvalidJobIds(jobIds) {
    return jobIds.filter(id => !this.mlJobsService.jobs.some(j => {
      var _j$groups2;
      return j.job_id === id || ((_j$groups2 = j.groups) === null || _j$groups2 === void 0 ? void 0 : _j$groups2.includes(id));
    }));
  }
  setSelectedJobs(jobIds, time) {
    this.globalUrlStateService.updateUrlState({
      ml: {
        jobIds
      },
      ...(time ? {
        time
      } : {})
    });
  }
  setFilterSettings(update) {
    this.anomalyExplorerUrlStateService.updateUrlState({
      mlExplorerFilter: {
        influencersFilterQuery: update.filterQuery,
        filterActive: true,
        filteredFields: update.filteredFields,
        queryString: update.queryString
      }
    });
  }
  clearFilterSettings() {
    this.anomalyExplorerUrlStateService.updateUrlState({
      mlExplorerFilter: {}
    });
  }
}
exports.AnomalyExplorerCommonStateService = AnomalyExplorerCommonStateService;