"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluatePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../../../contexts/kibana");
var _common = require("../../../../common");
var _analytics = require("../../../../common/analytics");
var _expandable_section = require("../expandable_section");
var _evaluate_stat = require("./evaluate_stat");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/regression_exploration/evaluate_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_STATS = {
  mse: _analytics.EMPTY_STAT,
  msle: _analytics.EMPTY_STAT,
  huber: _analytics.EMPTY_STAT,
  rSquared: _analytics.EMPTY_STAT
};
const defaultEval = {
  ...EMPTY_STATS,
  error: null
};
const EvaluatePanel = ({
  jobConfig,
  jobStatus,
  searchQuery
}) => {
  var _jobConfig$dest$resul;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const docLink = docLinks.links.ml.regressionEvaluation;
  const [trainingEval, setTrainingEval] = (0, _react.useState)(defaultEval);
  const [generalizationEval, setGeneralizationEval] = (0, _react.useState)(defaultEval);
  const [isLoadingTraining, setIsLoadingTraining] = (0, _react.useState)(false);
  const [isLoadingGeneralization, setIsLoadingGeneralization] = (0, _react.useState)(false);
  const [isTrainingFilter, setIsTrainingFilter] = (0, _react.useState)(undefined);
  const [trainingDocsCount, setTrainingDocsCount] = (0, _react.useState)(null);
  const [generalizationDocsCount, setGeneralizationDocsCount] = (0, _react.useState)(null);
  const index = jobConfig.dest.index;
  const dependentVariable = (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis);
  const predictionFieldName = (0, _mlDataFrameAnalyticsUtils.getPredictionFieldName)(jobConfig.analysis);
  // default is 'ml'
  const resultsField = (_jobConfig$dest$resul = jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : 'ml';
  const loadGeneralizationData = async (ignoreDefaultQuery = true) => {
    setIsLoadingGeneralization(true);
    const genErrorEval = await (0, _common.loadEvalData)({
      mlApi,
      isTraining: false,
      index,
      dependentVariable,
      resultsField,
      predictionFieldName,
      searchQuery,
      ignoreDefaultQuery,
      jobType: _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION
    });
    if (genErrorEval.success === true && genErrorEval.eval && (0, _analytics.isRegressionEvaluateResponse)(genErrorEval.eval)) {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        mse,
        msle,
        huber,
        r_squared
      } = (0, _common.getValuesFromResponse)(genErrorEval.eval);
      setGeneralizationEval({
        mse,
        msle,
        huber,
        rSquared: r_squared,
        error: null
      });
      setIsLoadingGeneralization(false);
    } else {
      setIsLoadingGeneralization(false);
      setGeneralizationEval({
        ...EMPTY_STATS,
        error: genErrorEval.error
      });
    }
  };
  const loadTrainingData = async (ignoreDefaultQuery = true) => {
    setIsLoadingTraining(true);
    const trainingErrorEval = await (0, _common.loadEvalData)({
      mlApi,
      isTraining: true,
      index,
      dependentVariable,
      resultsField,
      predictionFieldName,
      searchQuery,
      ignoreDefaultQuery,
      jobType: _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION
    });
    if (trainingErrorEval.success === true && trainingErrorEval.eval && (0, _analytics.isRegressionEvaluateResponse)(trainingErrorEval.eval)) {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        mse,
        msle,
        huber,
        r_squared
      } = (0, _common.getValuesFromResponse)(trainingErrorEval.eval);
      setTrainingEval({
        mse,
        msle,
        huber,
        rSquared: r_squared,
        error: null
      });
      setIsLoadingTraining(false);
    } else {
      setIsLoadingTraining(false);
      setTrainingEval({
        ...EMPTY_STATS,
        error: trainingErrorEval.error
      });
    }
  };
  const loadData = async () => {
    loadGeneralizationData(false);
    const genDocsCountResp = await (0, _common.loadDocsCount)({
      mlApi,
      ignoreDefaultQuery: false,
      isTraining: false,
      searchQuery,
      resultsField,
      destIndex: jobConfig.dest.index
    });
    if (genDocsCountResp.success === true) {
      setGeneralizationDocsCount(genDocsCountResp.docsCount);
    } else {
      setGeneralizationDocsCount(null);
    }
    loadTrainingData(false);
    const trainDocsCountResp = await (0, _common.loadDocsCount)({
      mlApi,
      ignoreDefaultQuery: false,
      isTraining: true,
      searchQuery,
      resultsField,
      destIndex: jobConfig.dest.index
    });
    if (trainDocsCountResp.success === true) {
      setTrainingDocsCount(trainDocsCountResp.docsCount);
    } else {
      setTrainingDocsCount(null);
    }
  };
  (0, _react.useEffect)(() => {
    let isTraining;
    const query = (0, _analytics.isResultsSearchBoolQuery)(searchQuery) && (searchQuery.bool.should || searchQuery.bool.filter);
    if (query !== undefined && query !== false) {
      for (let i = 0; i < query.length; i++) {
        const clause = query[i];
        if (clause.match && clause.match[`${resultsField}.is_training`] !== undefined) {
          isTraining = clause.match[`${resultsField}.is_training`];
          break;
        } else if (clause.bool && (clause.bool.should !== undefined || clause.bool.filter !== undefined)) {
          const innerQuery = clause.bool.should || clause.bool.filter;
          if (innerQuery !== undefined) {
            for (let j = 0; j < innerQuery.length; j++) {
              const innerClause = innerQuery[j];
              if (innerClause.match && innerClause.match[`${resultsField}.is_training`] !== undefined) {
                isTraining = innerClause.match[`${resultsField}.is_training`];
                break;
              }
            }
          }
        }
      }
    }
    setIsTrainingFilter(isTraining);
    loadData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(searchQuery)]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    urlStateKey: 'evaluation',
    dataTestId: "RegressionEvaluation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.evaluateSectionTitle",
      defaultMessage: "Model evaluation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 11
      }
    }),
    docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      iconType: "question",
      iconSide: "left",
      size: "xs",
      color: "primary",
      href: docLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.regressionDocsLink",
      defaultMessage: "Regression evaluation docs ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 15
      }
    }))),
    headerItems: jobStatus !== undefined ? [{
      id: 'jobStatus',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateJobStatusLabel', {
        defaultMessage: 'Job status'
      }),
      value: jobStatus
    }] : [],
    contentPadding: true,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.generalizationErrorTitle', {
      defaultMessage: 'Generalization error'
    }))), generalizationDocsCount !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.generalizationDocsCount",
      defaultMessage: "{docsCount, plural, one {# doc} other {# docs}} evaluated",
      values: {
        docsCount: generalizationDocsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 19
      }
    }), isTrainingFilter === true && generalizationDocsCount === 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.generalizationFilterText",
      defaultMessage: ". Filtering for training data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenMSEstat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.mse,
      statType: _analytics.REGRESSION_STATS.MSE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenRSquaredStat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.rSquared,
      statType: _analytics.REGRESSION_STATS.R_SQUARED,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 27
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenMsleStat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.msle,
      statType: _analytics.REGRESSION_STATS.MSLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenHuberStat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.huber,
      statType: _analytics.REGRESSION_STATS.HUBER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 27
      }
    })))))), generalizationEval.error !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 21
      }
    }, isTrainingFilter === true && generalizationDocsCount === 0 && generalizationEval.error.includes('No documents found') ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.evaluateNoTestingDocsError', {
      defaultMessage: 'No testing documents found'
    }) : generalizationEval.error)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.trainingErrorTitle', {
      defaultMessage: 'Training error'
    }))), trainingDocsCount !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.trainingDocsCount",
      defaultMessage: "{docsCount, plural, one {# doc} other {# docs}} evaluated",
      values: {
        docsCount: trainingDocsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 19
      }
    }), isTrainingFilter === false && trainingDocsCount === 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.trainingFilterText",
      defaultMessage: ". Filtering for testing data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 398,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 400,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 402,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingMSEstat',
      isLoading: isLoadingTraining,
      title: trainingEval.mse,
      statType: _analytics.REGRESSION_STATS.MSE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 412,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingRSquaredStat',
      isLoading: isLoadingTraining,
      title: trainingEval.rSquared,
      statType: _analytics.REGRESSION_STATS.R_SQUARED,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 27
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 425,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingMsleStat',
      isLoading: isLoadingTraining,
      title: trainingEval.msle,
      statType: _analytics.REGRESSION_STATS.MSLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 426,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 433,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingHuberStat',
      isLoading: isLoadingTraining,
      title: trainingEval.huber,
      statType: _analytics.REGRESSION_STATS.HUBER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 27
      }
    })))))), trainingEval.error !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 446,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 447,
        columnNumber: 21
      }
    }, isTrainingFilter === false && trainingDocsCount === 0 && trainingEval.error.includes('No documents found') ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.evaluateNoTrainingDocsError', {
      defaultMessage: 'No training documents found'
    }) : trainingEval.error))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 7
    }
  }));
};
exports.EvaluatePanel = EvaluatePanel;